/*
 * Decompiled with CFR 0.152.
 */
package deep_ci.mcmods.simpleflight;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import deep_ci.mcmods.simpleflight.SimpleConfig;
import deep_ci.mcmods.simpleflight.enchantment.EnchantmentFlightTime;
import deep_ci.mcmods.simpleflight.enchantment.EnchantmentMoreFlaps;
import deep_ci.mcmods.simpleflight.event.SimpleFlightEventHandler;
import deep_ci.mcmods.simpleflight.item.crafting.EnchantmentRecipe;
import deep_ci.mcmods.simpleflight.item.crafting.WingDyeRecipes;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.init.Blocks;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.RecipeSorter;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SimpleFlightAPI {
    private static boolean LOADED = false;
    private static File configFilePath;
    private static SimpleConfig config;
    public static Enchantment moreFlaps;
    public static Enchantment quickerFlaps;
    private static Logger logger;

    private SimpleFlightAPI() {
    }

    public static void init(Side side) {
        if (!LOADED) {
            logger = LogManager.getLogger((String)"SimpleFlightAPI");
            SimpleFlightAPI.initConfig(side);
            SimpleFlightAPI.registerEventHandler();
            SimpleFlightAPI.registerEnchantments();
            SimpleFlightAPI.registerRecipies();
            LOADED = true;
        }
    }

    private static void initConfig(Side side) {
        if (LOADED) {
            return;
        }
        configFilePath = side == Side.SERVER ? new File(MinecraftServer.func_71276_C().func_71270_I(), "config/simpleflight.cfg") : new File(Minecraft.func_71410_x().field_71412_D, "config/simpleflight.cfg");
        config = new SimpleConfig(new Configuration(configFilePath));
    }

    private static void registerEventHandler() {
        MinecraftForge.EVENT_BUS.register((Object)new SimpleFlightEventHandler());
        logger.log(Level.INFO, "Simple Flight Event Handler has been registered.");
    }

    private static void registerEnchantments() {
        moreFlaps = new EnchantmentMoreFlaps(78, 10, SimpleFlightAPI.getConfig().MoreFlaps_MaxValue, EnumEnchantmentType.armor);
        moreFlaps.func_77322_b("fly_longer");
        Enchantment.addToBookList((Enchantment)moreFlaps);
        quickerFlaps = new EnchantmentFlightTime(79, 10, SimpleFlightAPI.getConfig().QuickerFlaps_MaxValue, EnumEnchantmentType.armor);
        quickerFlaps.func_77322_b("fly_faster");
        Enchantment.addToBookList((Enchantment)quickerFlaps);
    }

    private static void registerRecipies() {
        RecipeSorter.register((String)"simpleflight:dyes", WingDyeRecipes.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        RecipeSorter.register((String)"simpleflight:enchantments", EnchantmentRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        GameRegistry.addRecipe((IRecipe)new WingDyeRecipes());
        GameRegistry.addRecipe((IRecipe)new EnchantmentRecipe(Blocks.field_150368_y, moreFlaps));
        GameRegistry.addRecipe((IRecipe)new EnchantmentRecipe(Blocks.field_150451_bX, quickerFlaps));
        logger.log(Level.INFO, "Wing Dye & Enchantment handlers have been registered.");
    }

    public static SimpleConfig getConfig() {
        return config;
    }
}

