/*
 * Decompiled with CFR 0.152.
 */
package deep_ci.mcmods.simpleflight.item;

import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import deep_ci.mcmods.simpleflight.SimpleFlight;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class ItemArmorSimpleWings
extends ItemArmor {
    public final int flapsPerFlight;
    public final int flapCooldownTime;
    public final boolean enablesGlide;
    protected int flapCounter;
    protected long lastFlap;

    public ItemArmorSimpleWings(int maxFlaps, int flapCooldown, boolean isGlideCapable, ItemArmor.ArmorMaterial armorType, int renderType, int armorSlot) {
        super(armorType, renderType, armorSlot);
        this.flapsPerFlight = maxFlaps;
        this.flapCooldownTime = flapCooldown;
        this.enablesGlide = isGlideCapable;
        this.flapCounter = 0;
        this.lastFlap = 0L;
    }

    public ItemArmorSimpleWings(ItemArmor.ArmorMaterial armorType, int renderType, int armorSlot) {
        this(0, 0, false, armorType, renderType, armorSlot);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack item) {
        ++this.lastFlap;
        if (world.field_72995_K && Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d()) {
            this.tryToFly(world, player, item);
        }
        if (player.field_70122_E) {
            this.lastFlap = 0L;
            this.flapCounter = 0;
        }
    }

    public final void tryToFly(World world, EntityPlayer player, ItemStack items) {
        boolean flag1 = false;
        boolean flag2 = false;
        if (player.field_70160_al && !player.func_70115_ae()) {
            flag1 = true;
        }
        if (this.flapCounter < this.getMaxFlaps(items, player) && this.lastFlap >= (long)this.getFlapsCooldown(items, player)) {
            flag2 = true;
        }
        if (flag1 && flag2) {
            if (world.field_72995_K) {
                ByteBuf payload = Unpooled.buffer();
                payload.writeInt(this.field_77881_a);
                SimpleFlight.channel.sendToServer(new FMLProxyPacket(payload, "DP_SimpleFlight"));
            }
            this.flap(world, player, items);
        }
    }

    private final void flap(World world, EntityPlayer player, ItemStack items) {
        this.lastFlap = 0L;
        ++this.flapCounter;
        player.func_70664_aZ();
        this.onFlap(world, player, items);
        player.func_85030_a(this.getSound(items, player, world), this.getSoundVolume(items, player, world), this.getSoundPitch(items, player, world));
    }

    public void onFlap(World world, EntityPlayer player, ItemStack items) {
    }

    public boolean enablesForGliding(ItemStack itemstack, EntityLivingBase entity) {
        return this.enablesGlide;
    }

    public int getMaxFlaps(ItemStack itemstack, EntityPlayer player) {
        int finalFlaps = this.flapsPerFlight;
        if (itemstack.func_77948_v()) {
            NBTTagList nbt = itemstack.func_77986_q();
            for (int i = 0; i < nbt.func_74745_c(); ++i) {
                NBTTagCompound comp = nbt.func_150305_b(i);
                if (comp.func_74762_e("id") != SimpleFlight.items.flyLonger.field_77352_x) continue;
                float power = (float)(0.2 * (double)comp.func_74762_e("lvl"));
                finalFlaps += (int)((float)finalFlaps * power);
            }
        }
        return finalFlaps;
    }

    public int getFlapsCooldown(ItemStack itemstack, EntityPlayer player) {
        int cooldown = this.flapCooldownTime;
        if (itemstack.func_77948_v()) {
            NBTTagList nbt = itemstack.func_77986_q();
            for (int i = 0; i < nbt.func_74745_c(); ++i) {
                NBTTagCompound comp = nbt.func_150305_b(i);
                if (comp.func_74762_e("id") != SimpleFlight.items.flyFaster.field_77352_x) continue;
                int power = comp.func_74762_e("lvl");
                cooldown -= power;
            }
        }
        return cooldown;
    }

    public String getSound(ItemStack stack, EntityPlayer player, World world) {
        return "mob.enderdragon.wings";
    }

    public float getSoundPitch(ItemStack stack, EntityPlayer player, World world) {
        return 1.25f;
    }

    public float getSoundVolume(ItemStack stack, EntityPlayer player, World world) {
        return 0.8f;
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack item, Entity entity, int slot, String type) {
        return super.getArmorTexture(item, entity, slot, type);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        return super.getArmorModel(entityLiving, itemStack, armorSlot);
    }

    public float getFlapFactor() {
        return this.lastFlap > (long)this.flapCooldownTime ? 0.0f : (float)(this.lastFlap * (long)this.flapCooldownTime / 100L);
    }

    public void func_77624_a(ItemStack items, EntityPlayer player, List list, boolean bool) {
        if (items.func_77973_b() instanceof ItemArmorSimpleWings) {
            ItemArmorSimpleWings wings = (ItemArmorSimpleWings)items.func_77973_b();
            list.add(I18n.func_135052_a((String)"simpleflight.item.tooltip.flapcount", (Object[])new Object[]{wings.getMaxFlaps(items, player)}));
            if (wings.enablesForGliding(items, (EntityLivingBase)player)) {
                list.add(I18n.func_135052_a((String)"simpleflight.item.tooltip.glideenabled", (Object[])new Object[0]));
            } else {
                list.add(I18n.func_135052_a((String)"simpleflight.item.tooltip.glidedisabled", (Object[])new Object[0]));
            }
        }
    }
}

