package uk.co.toomuchminecraft.sabermod;

import net.minecraft.block.Block;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.item.EnumArmorMaterial;
import net.minecraft.item.EnumToolMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.src.ModLoader;
import net.minecraft.world.biome.BiomeGenBase;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.Instance;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraftforge.common.DungeonHooks;
import net.minecraftforge.common.EnumHelper;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid = "sabermod", name = "SaberMod", version = "0.17.1")
@NetworkMod(clientSideRequired = true, serverSideRequired = false, versionBounds = "0.17.1", channels = { "SaberExtend" , "SaberSound" }, packetHandler = PacketHandler.class)
public class SaberMod
{
	@SidedProxy(clientSide = "uk.co.toomuchminecraft.sabermod.client.ClientProxy", serverSide = "uk.co.toomuchminecraft.sabermod.CommonProxy")
	public static CommonProxy proxy;
	@Instance("sabermod")
	public static SaberMod instance;
	
	private static int baseBlockID = 1151;
	private static int baseItemID = 1000;
	
	// gem ores
	public static Block oreAmethyst;
	public static Block oreRuby;
	public static Block oreAmber;
	public static Block oreOnyx;
	public static Block oreJade;
	public static Block oreIolite;
	public static Block oreSapphire;
	public static Block oreTopaz;
	public static Block orePower;

	// gem blocks
	public static Block blockAmethyst;
	public static Block blockRuby;
	public static Block blockAmber;
	public static Block blockOnyx;
	public static Block blockJade;
	public static Block blockIolite;
	public static Block blockSapphire;
	public static Block blockTopaz;
	public static Block blockPower;

	// gems
	public static Item gemAmethyst;
	public static Item gemRuby;
	public static Item gemAmber;
	public static Item gemOnyx;
	public static Item gemJade;
	public static Item gemIolite;
	public static Item gemSapphire;
	public static Item gemTopaz;
	public static Item gemPower;

	// enums
	// - tools
	static EnumToolMaterial enumAmethystTool = EnumHelper.addToolMaterial("Amethyst", 3, 1561, 8.0F, 3, 10);
	static EnumToolMaterial enumRubyTool = EnumHelper.addToolMaterial("Ruby", 3, 1561, 8.0F, 3, 10);
	static EnumToolMaterial enumAmberTool = EnumHelper.addToolMaterial("Amber", 3, 1561, 8.0F, 3, 10);
	static EnumToolMaterial enumOnyxTool = EnumHelper.addToolMaterial("Onyx", 3, 1561, 8.0F, 3, 10);
	static EnumToolMaterial enumJadeTool = EnumHelper.addToolMaterial("Jade", 3, 1561, 8.0F, 3, 10);
	static EnumToolMaterial enumIoliteTool = EnumHelper.addToolMaterial("Iolite", 3, 1561, 8.0F, 3, 10);
	static EnumToolMaterial enumSapphireTool = EnumHelper.addToolMaterial("Sapphire", 3, 1561, 8.0F, 3, 10);
	static EnumToolMaterial enumTopazTool = EnumHelper.addToolMaterial("Topaz", 3, 1561, 8.0F, 3, 10);
	static EnumToolMaterial saberOn = EnumHelper.addToolMaterial("saberOn", 3, 5000, 15.0F, 25, 0);

	// - armour
	static EnumArmorMaterial enumAmethystArmour = EnumHelper.addArmorMaterial("Amethyst", 33, new int[] { 3, 8, 6, 3 }, 10);
	static EnumArmorMaterial enumRubyArmour = EnumHelper.addArmorMaterial("Ruby", 33, new int[] { 3, 8, 6, 3 }, 10);
	static EnumArmorMaterial enumAmberArmour = EnumHelper.addArmorMaterial("Amber", 33, new int[] { 3, 8, 6, 3 }, 10);
	static EnumArmorMaterial enumOnyxArmour = EnumHelper.addArmorMaterial("Onyx", 33, new int[] { 3, 8, 6, 3 }, 10);
	static EnumArmorMaterial enumJadeArmour = EnumHelper.addArmorMaterial("Jade", 33, new int[] { 3, 8, 6, 3 }, 10);
	static EnumArmorMaterial enumIoliteArmour = EnumHelper.addArmorMaterial("Iolite", 33, new int[] { 3, 8, 6, 3 }, 10);
	static EnumArmorMaterial enumSapphireArmour = EnumHelper.addArmorMaterial("Sapphire", 33, new int[] { 3, 8, 6, 3 }, 10);
	static EnumArmorMaterial enumTopazArmour = EnumHelper.addArmorMaterial("Topaz", 33, new int[] { 3, 8, 6, 3 }, 10);

	public static Item lens;

	// gem tools
	// - Amethyst
	public static Item swordAmethyst;
	public static Item pickaxeAmethyst;
	public static Item spadeAmethyst;
	public static Item axeAmethyst;
	public static Item hoeAmethyst;

	// - Ruby
	public static Item swordRuby;
	public static Item pickaxeRuby;
	public static Item spadeRuby;
	public static Item axeRuby;
	public static Item hoeRuby;

	// - Amber
	public static Item swordAmber;
	public static Item pickaxeAmber;
	public static Item spadeAmber;
	public static Item axeAmber;
	public static Item hoeAmber;

	// - Onyx
	public static Item swordOnyx;
	public static Item pickaxeOnyx;
	public static Item spadeOnyx;
	public static Item axeOnyx;
	public static Item hoeOnyx;

	// - Jade
	public static Item swordJade;
	public static Item pickaxeJade;
	public static Item spadeJade;
	public static Item axeJade;
	public static Item hoeJade;

	// - Iolite
	public static Item swordIolite;
	public static Item pickaxeIolite;
	public static Item spadeIolite;
	public static Item axeIolite;
	public static Item hoeIolite;

	// - Sapphire
	public static Item swordSapphire;
	public static Item pickaxeSapphire;
	public static Item spadeSapphire;
	public static Item axeSapphire;
	public static Item hoeSapphire;

	// - Topaz
	public static Item swordTopaz;
	public static Item pickaxeTopaz;
	public static Item spadeTopaz;
	public static Item axeTopaz;
	public static Item hoeTopaz;

	// gem armour
	// - Amethyst
	public static Item helmetAmethyst;
	public static Item chestplateAmethyst;
	public static Item leggingsAmethyst;
	public static Item bootsAmethyst;

	// - Ruby
	public static Item helmetRuby;
	public static Item chestplateRuby;
	public static Item leggingsRuby;
	public static Item bootsRuby;

	// - Amber
	public static Item helmetAmber;
	public static Item chestplateAmber;
	public static Item leggingsAmber;
	public static Item bootsAmber;

	// - Onyx
	public static Item helmetOnyx;
	public static Item chestplateOnyx;
	public static Item leggingsOnyx;
	public static Item bootsOnyx;

	// - Jade
	public static Item helmetJade;
	public static Item chestplateJade;
	public static Item leggingsJade;
	public static Item bootsJade;

	// - Iolite
	public static Item helmetIolite;
	public static Item chestplateIolite;
	public static Item leggingsIolite;
	public static Item bootsIolite;

	// - Sapphire
	public static Item helmetSapphire;
	public static Item chestplateSapphire;
	public static Item leggingsSapphire;
	public static Item bootsSapphire;

	// - Topaz
	public static Item helmetTopaz;
	public static Item chestplateTopaz;
	public static Item leggingsTopaz;
	public static Item bootsTopaz;

	// sabers
	// - Purple
	public static Item saberPurpleOff;
	public static Item saberPurpleOn;

	// - Red
	public static Item saberRedOff;
	public static Item saberRedOn;

	// - Yellow
	public static Item saberYellowOff;
	public static Item saberYellowOn;

	// - Black
	public static Item saberBlackOff;
	public static Item saberBlackOn;

	// - Green
	public static Item saberGreenOff;
	public static Item saberGreenOn;

	// - Indigo
	public static Item saberIndigoOff;
	public static Item saberIndigoOn;

	// - Dark Blue
	public static Item saberDarkBlueOff;
	public static Item saberDarkBlueOn;

	// - Gold
	public static Item saberGoldOff;
	public static Item saberGoldOn;

	// - Light Blue
	public static Item saberLightBlueOff;
	public static Item saberLightBlueOn;
	
	//StarMaps
	public static Item starMap;
	
	//SaberPieces
	public static Item beamFocuser;
	public static Item pigmentGenerator;
	public static Item energyCore;
	
	//Blaster
	public static Item blaster;
	public static Item blasterBattery;
	public static Item batteryCharge;
	
	public static final String[] pigmentNames = { "Purple", "Red",
			"Yellow", "Black", "Green", "Indigo", "Dark Blue", "Gold",
			"Light Blue"};
	
	public static final String[] starMapNames = { "Alderaan", "Bespin",
		"Coruscant", "Dagobah", "Endor", "Felucia", "Geonosis", "Hoth",
		"Kamino", "Kashyyyk", "Kessel", "Mustafar", "Mygeeto", "Naboo",
		"Tatooine", "Utapau" };

	// renderers
	public static int amethystRenderer = 0;
	public static int rubyRenderer = 0;
	public static int amberRenderer = 0;
	public static int jadeRenderer = 0;
	public static int onyxRenderer = 0;
	public static int ioliteRenderer = 0;
	public static int sapphireRenderer = 0;
	public static int topazRenderer = 0;
	
	@PreInit
	public void preloadSaberMod(FMLPreInitializationEvent event)
	{
		proxy.initializeSounds();
	}

	@Init
	public void loadSaberMod(FMLInitializationEvent event)
	{
		// init names
		proxy.addNames();

		// init textures
		proxy.preloadTextures();

		proxy.initializeRenderers();

		proxy.registerTickHandler();

		proxy.registerKeyBindings();
		
		proxy.renderEntities();
		
		DungeonHooks.addDungeonLoot((new ItemStack(starMap, 1, 0)), 1, 1, 1);
		DungeonHooks.addDungeonLoot((new ItemStack(starMap, 1, 1)), 1, 1, 1);
		DungeonHooks.addDungeonLoot((new ItemStack(starMap, 1, 2)), 1, 1, 1);
		DungeonHooks.addDungeonLoot((new ItemStack(starMap, 1, 3)), 1, 1, 1);
		DungeonHooks.addDungeonLoot((new ItemStack(starMap, 1, 4)), 1, 1, 1);
		DungeonHooks.addDungeonLoot((new ItemStack(starMap, 1, 5)), 1, 1, 1);
		DungeonHooks.addDungeonLoot((new ItemStack(starMap, 1, 6)), 1, 1, 1);
		DungeonHooks.addDungeonLoot((new ItemStack(starMap, 1, 7)), 1, 1, 1);
		DungeonHooks.addDungeonLoot((new ItemStack(starMap, 1, 8)), 1, 1, 1);
		DungeonHooks.addDungeonLoot((new ItemStack(starMap, 1, 9)), 1, 1, 1);
		DungeonHooks.addDungeonLoot((new ItemStack(starMap, 1, 10)), 1, 1, 1);
		DungeonHooks.addDungeonLoot((new ItemStack(starMap, 1, 11)), 1, 1, 1);
		DungeonHooks.addDungeonLoot((new ItemStack(starMap, 1, 12)), 1, 1, 1);
		DungeonHooks.addDungeonLoot((new ItemStack(starMap, 1, 13)), 1, 1, 1);
		DungeonHooks.addDungeonLoot((new ItemStack(starMap, 1, 14)), 1, 1, 1);
		DungeonHooks.addDungeonLoot((new ItemStack(starMap, 1, 15)), 1, 1, 1);
		
		// Entities
		//- Jawa
		int jawaEntityID = ModLoader.getUniqueEntityId();
		EntityRegistry.registerGlobalEntityID(EntityJawa.class, "Jawa", jawaEntityID, 0x161208, 0x4E2F21);
		EntityRegistry.registerModEntity(EntityJawa.class, "Jawa", jawaEntityID, this, 250, 5, false);
		EntityRegistry.addSpawn(EntityJawa.class, 3, 3, 7, EnumCreatureType.creature, BiomeGenBase.desert);
		
		//- Ewok
		int ewokEntityID = ModLoader.getUniqueEntityId();
		EntityRegistry.registerGlobalEntityID(EntityEwok.class, "Ewok", ewokEntityID, 0x896139, 0xD37A03);
		EntityRegistry.registerModEntity(EntityEwok.class, "Ewok", ewokEntityID, this, 250, 5, false);
		EntityRegistry.addSpawn(EntityEwok.class, 5, 1, 4, EnumCreatureType.creature, BiomeGenBase.jungle);
		
		//- StormTrooper
		int stormTrooperEntityID = ModLoader.getUniqueEntityId();
		EntityRegistry.registerGlobalEntityID(EntityStormTrooper.class, "StormTrooper", stormTrooperEntityID, 0xFFFDFD, 0x000000);
		EntityRegistry.registerModEntity(EntityStormTrooper.class, "StormTrooper", stormTrooperEntityID, this, 250, 5, false);
		EntityRegistry.addSpawn(EntityStormTrooper.class, 5, 3, 5, EnumCreatureType.creature);
		
		//blast
		int blastID = ModLoader.getUniqueEntityId();
		EntityRegistry.registerGlobalEntityID(EntityBlast.class, "Blast", blastID);
		EntityRegistry.registerModEntity(EntityBlast.class, "Blast", blastID, this, 250, 5, false);

		// gem ores
		GameRegistry.registerBlock(oreAmethyst, "oreAmethyst");
		GameRegistry.registerBlock(oreRuby, "oreRuby");
		GameRegistry.registerBlock(oreAmber, "oreAmber");
		GameRegistry.registerBlock(oreOnyx, "oreOnyx");
		GameRegistry.registerBlock(oreJade, "oreJade");
		GameRegistry.registerBlock(oreIolite, "oreIolite");
		GameRegistry.registerBlock(oreSapphire, "oreSapphire");
		GameRegistry.registerBlock(oreTopaz, "oreTopaz");
		GameRegistry.registerBlock(orePower, "orePower");
		MinecraftForge.setBlockHarvestLevel(oreAmethyst, "pickaxe", 2);
		MinecraftForge.setBlockHarvestLevel(oreRuby, "pickaxe", 2);
		MinecraftForge.setBlockHarvestLevel(oreAmber, "pickaxe", 2);
		MinecraftForge.setBlockHarvestLevel(oreOnyx, "pickaxe", 2);
		MinecraftForge.setBlockHarvestLevel(oreJade, "pickaxe", 2);
		MinecraftForge.setBlockHarvestLevel(oreIolite, "pickaxe", 2);
		MinecraftForge.setBlockHarvestLevel(oreSapphire, "pickaxe", 2);
		MinecraftForge.setBlockHarvestLevel(oreTopaz, "pickaxe", 2);

		// gem blocks
		GameRegistry.registerBlock(blockAmethyst, "blockAmethyst");
		GameRegistry.registerBlock(blockRuby, "blockRuby");
		GameRegistry.registerBlock(blockAmber, "blockAmber");
		GameRegistry.registerBlock(blockOnyx, "blockOnyx");
		GameRegistry.registerBlock(blockJade, "blockJade");
		GameRegistry.registerBlock(blockIolite, "blockIolite");
		GameRegistry.registerBlock(blockSapphire, "blockSapphire");
		GameRegistry.registerBlock(blockTopaz, "blockTopaz");
		GameRegistry.registerBlock(blockPower, "blockPower");
		MinecraftForge.setBlockHarvestLevel(blockAmethyst, "pickaxe", 2);
		MinecraftForge.setBlockHarvestLevel(blockRuby, "pickaxe", 2);
		MinecraftForge.setBlockHarvestLevel(blockAmber, "pickaxe", 2);
		MinecraftForge.setBlockHarvestLevel(blockOnyx, "pickaxe", 2);
		MinecraftForge.setBlockHarvestLevel(blockJade, "pickaxe", 2);
		MinecraftForge.setBlockHarvestLevel(blockIolite, "pickaxe", 2);
		MinecraftForge.setBlockHarvestLevel(blockSapphire, "pickaxe", 2);
		MinecraftForge.setBlockHarvestLevel(blockTopaz, "pickaxe", 2);
		

		// Crafting Recipes
		// - Gems2Gemblock
		// - - Amethyst
		GameRegistry.addRecipe(new ItemStack(blockAmethyst, 1), new Object[]
				{
			"###", "###", "###",
			Character.valueOf('#'), gemAmethyst 
				});

		// - - Ruby
		GameRegistry.addRecipe(new ItemStack(blockRuby, 1), new Object[]
				{
			"###", "###", "###",
			Character.valueOf('#'), gemRuby
				});

		// - - Amber
		GameRegistry.addRecipe(new ItemStack(blockAmber, 1), new Object[]
				{
			"###", "###", "###",
			Character.valueOf('#'), gemAmber
				});

		// - - Onyx
		GameRegistry.addRecipe(new ItemStack(blockOnyx, 1), new Object[]
				{
			"###", "###", "###",
			Character.valueOf('#'), gemOnyx
				});

		// - - Jade
		GameRegistry.addRecipe(new ItemStack(blockJade, 1), new Object[]
				{
			"###", "###", "###",
			Character.valueOf('#'), gemJade
				});

		// - - Iolite
		GameRegistry.addRecipe(new ItemStack(blockIolite, 1), new Object[]
				{
			"###", "###", "###",
			Character.valueOf('#'), gemIolite
				});

		// - - Sapphire
		GameRegistry.addRecipe(new ItemStack(blockSapphire, 1), new Object[]
				{
			"###", "###", "###",
			Character.valueOf('#'), gemSapphire
				});

		// - - Topaz
		GameRegistry.addRecipe(new ItemStack(blockTopaz, 1), new Object[]
				{
			"###", "###", "###",
			Character.valueOf('#'),gemTopaz
				});

		// - blockblock2Gems
		// - - Amethyst
		GameRegistry.addRecipe(new ItemStack(gemAmethyst, 9), new Object[]
				{
			"#",
			Character.valueOf('#'), blockAmethyst
				});

		// - - Ruby
		GameRegistry.addRecipe(new ItemStack(gemRuby, 9), new Object[]
				{
			"#",
			Character.valueOf('#'), blockRuby
				});

		// - - Amber
		GameRegistry.addRecipe(new ItemStack(gemAmber, 9), new Object[]
				{
			"#",
			Character.valueOf('#'), blockAmber
				});

		// - - Onyx
		GameRegistry.addRecipe(new ItemStack(gemOnyx, 9), new Object[]
				{
			"#",
			Character.valueOf('#'), blockOnyx
				});

		// - - Jade
		GameRegistry.addRecipe(new ItemStack(gemJade, 9), new Object[]
				{
			"#",
			Character.valueOf('#'), blockJade
				});

		// - - Iolite
		GameRegistry.addRecipe(new ItemStack(gemIolite, 9), new Object[]
				{
			"#",
			Character.valueOf('#'), blockIolite
				});

		// - - Sapphire
		GameRegistry.addRecipe(new ItemStack(gemSapphire, 9), new Object[]
				{
			"#",
			Character.valueOf('#'), blockSapphire
				});

		// - - Topaz
		GameRegistry.addRecipe(new ItemStack(gemTopaz, 9), new Object[]
				{
			"#",
			Character.valueOf('#'), blockTopaz
				});
		
		
		//lens
		GameRegistry.addRecipe(new ItemStack(lens, 3), new Object[]
				{
			" # ", "# #",
			Character.valueOf('#'), Block.glass 
				});
		

		// - tools
		// - - amethyst
		GameRegistry.addRecipe(new ItemStack(pickaxeAmethyst, 1), new Object[]
				{
			"###", " @ ", " @ ",
			Character.valueOf('#'), gemAmethyst,
			Character.valueOf('@'), Item.stick
				});

		GameRegistry.addRecipe(new ItemStack(spadeAmethyst, 1), new Object[]
				{
			" # ", " @ ", " @ ",
			Character.valueOf('#'), gemAmethyst,
			Character.valueOf('@'), Item.stick
				});

		GameRegistry.addRecipe(new ItemStack(axeAmethyst, 1), new Object[]
				{
			" ##", " @#", " @ ",
			Character.valueOf('#'), gemAmethyst,
			Character.valueOf('@'), Item.stick
				});

		GameRegistry.addRecipe(new ItemStack(hoeAmethyst, 1), new Object[]
				{
			" ##", " @ ", " @ ",
			Character.valueOf('#'), gemAmethyst,
			Character.valueOf('@'), Item.stick
				});
		
		GameRegistry.addRecipe(new ItemStack(swordAmethyst, 1), new Object[]
				{
			"#", "#", "@",
			Character.valueOf('#'), gemAmethyst,
			Character.valueOf('@'), Item.stick
				});

		// - - Ruby
		GameRegistry.addRecipe(new ItemStack(pickaxeRuby, 1), new Object[]
				{
			"###", " @ ", " @ ",
			Character.valueOf('#'), gemRuby,
			Character.valueOf('@'), Item.stick
				});

		GameRegistry.addRecipe(new ItemStack(spadeRuby, 1), new Object[]
				{
			" # ", " @ ", " @ ",
			Character.valueOf('#'),gemRuby,
			Character.valueOf('@'), Item.stick
				});

		GameRegistry.addRecipe(new ItemStack(axeRuby, 1), new Object[]
				{
			" ##", " @#", " @ ",
			Character.valueOf('#'), gemRuby,
			Character.valueOf('@'), Item.stick
				});

		GameRegistry.addRecipe(new ItemStack(hoeRuby, 1), new Object[]
				{
			" ##", " @ ", " @ ",
			Character.valueOf('#'),gemRuby,
			Character.valueOf('@'), Item.stick
				});
		
		GameRegistry.addRecipe(new ItemStack(swordRuby, 1), new Object[]
				{
			"#", "#", "@",
			Character.valueOf('#'), gemRuby,
			Character.valueOf('@'), Item.stick
				});

		// - - Amber
		GameRegistry.addRecipe(new ItemStack(pickaxeAmber, 1), new Object[]
				{
			"###", " @ ", " @ ",
			Character.valueOf('#'), gemAmber,
			Character.valueOf('@'), Item.stick
				});

		GameRegistry.addRecipe(new ItemStack(spadeAmber, 1), new Object[]
				{
			" # ", " @ ", " @ ",
			Character.valueOf('#'), gemAmber,
			Character.valueOf('@'), Item.stick
				});

		GameRegistry.addRecipe(new ItemStack(axeAmber, 1), new Object[]
				{
			" ##", " @#", " @ ",
			Character.valueOf('#'), gemAmber,
			Character.valueOf('@'), Item.stick
				});

		GameRegistry.addRecipe(new ItemStack(hoeAmber, 1), new Object[]
				{
			" ##", " @ ", " @ ",
			Character.valueOf('#'), gemAmber,
			Character.valueOf('@'), Item.stick
				});
		
		GameRegistry.addRecipe(new ItemStack(swordAmber, 1), new Object[]
				{
			"#", "#", "@",
			Character.valueOf('#'), gemAmber,
			Character.valueOf('@'), Item.stick
				});

		// - - Jade
		GameRegistry.addRecipe(new ItemStack(pickaxeJade, 1), new Object[]
				{
			"###", " @ ", " @ ",
			Character.valueOf('#'),
			gemJade, Character.valueOf('@'),
			Item.stick
				});

		GameRegistry.addRecipe(new ItemStack(spadeJade, 1), new Object[]
				{
			" # ", " @ ", " @ ",
			Character.valueOf('#'),gemJade,
			Character.valueOf('@'), Item.stick
				});

		GameRegistry.addRecipe(new ItemStack(axeJade, 1), new Object[] 
				{
			" ##", " @#", " @ ",
			Character.valueOf('#'),gemJade, 
			Character.valueOf('@'), Item.stick
				});

		GameRegistry.addRecipe(new ItemStack(hoeJade, 1),new Object[]
				{
			" ##", " @ ", " @ ",
			Character.valueOf('#'), gemJade, 
			Character.valueOf('@'), Item.stick
				});
		
		GameRegistry.addRecipe(new ItemStack(swordJade, 1), new Object[]
				{
			"#", "#", "@",
			Character.valueOf('#'), gemJade,
			Character.valueOf('@'), Item.stick
				});

		// - - Onyx
		GameRegistry.addRecipe(new ItemStack(pickaxeOnyx, 1),new Object[]
				{
			"###", " @ ", " @ ",
			Character.valueOf('#'),gemOnyx, 
			Character.valueOf('@'), Item.stick
				});

		GameRegistry.addRecipe(new ItemStack(spadeOnyx, 1),new Object[]
				{
			" # ", " @ ", " @ ",
			Character.valueOf('#'),gemOnyx,
			Character.valueOf('@'), Item.stick
				});

		GameRegistry.addRecipe(new ItemStack(axeOnyx, 1), new Object[]
				{
			" ##", " @#", " @ ",
			Character.valueOf('#'),gemOnyx,
			Character.valueOf('@'), Item.stick
				});

		GameRegistry.addRecipe(new ItemStack(hoeOnyx, 1),new Object[]
				{
			" ##", " @ ", " @ ",
			Character.valueOf('#'),
			gemOnyx, Character.valueOf('@'), Item.stick
				});
		
		GameRegistry.addRecipe(new ItemStack(swordOnyx, 1), new Object[]
				{
			"#", "#", "@",
			Character.valueOf('#'), gemOnyx,
			Character.valueOf('@'), Item.stick
				});

		// - - Iolite
		GameRegistry.addRecipe(new ItemStack(pickaxeIolite, 1), new Object[]
				{
			"###", " @ ", " @ ",
			Character.valueOf('#'), gemIolite,
			Character.valueOf('@'), Item.stick
				});

		GameRegistry.addRecipe(new ItemStack(spadeIolite, 1), new Object[]
				{
			" # ", " @ ", " @ ",
			Character.valueOf('#'), gemIolite,
			Character.valueOf('@'), Item.stick
				});

		GameRegistry.addRecipe(new ItemStack(axeIolite, 1), new Object[]
				{
			" ##", " @#", " @ ",
			Character.valueOf('#'), gemIolite,
			Character.valueOf('@'), Item.stick
				});

		GameRegistry.addRecipe(new ItemStack(hoeIolite, 1), new Object[]
				{
			" ##", " @ ", " @ ",
			Character.valueOf('#'), gemIolite,
			Character.valueOf('@'), Item.stick
				});
		
		GameRegistry.addRecipe(new ItemStack(swordIolite, 1), new Object[]
				{
			"#", "#", "@",
			Character.valueOf('#'), gemIolite,
			Character.valueOf('@'), Item.stick
				});

		// - - Sapphire
		GameRegistry.addRecipe(new ItemStack(pickaxeSapphire, 1), new Object[]
				{
			"###", " @ ", " @ ",
			Character.valueOf('#'), gemSapphire,
			Character.valueOf('@'), Item.stick
				});

		GameRegistry.addRecipe(new ItemStack(spadeSapphire, 1), new Object[]
				{
			" # ", " @ ", " @ ",
			Character.valueOf('#'), gemSapphire,
			Character.valueOf('@'), Item.stick
				});

		GameRegistry.addRecipe(new ItemStack(axeSapphire, 1), new Object[]
				{
			" ##", " @#", " @ ",
			Character.valueOf('#'), gemSapphire,
			Character.valueOf('@'), Item.stick
				});

		GameRegistry.addRecipe(new ItemStack(hoeSapphire, 1), new Object[]
				{
			" ##", " @ ", " @ ",
			Character.valueOf('#'), gemSapphire,
			Character.valueOf('@'), Item.stick
				});
		
		GameRegistry.addRecipe(new ItemStack(swordSapphire, 1), new Object[]
				{
			"#", "#", "@",
			Character.valueOf('#'), gemSapphire,
			Character.valueOf('@'), Item.stick
				});

		// - - Topaz
		GameRegistry.addRecipe(new ItemStack(pickaxeTopaz, 1), new Object[]
				{
			"###", " @ ", " @ ",
			Character.valueOf('#'), gemTopaz,
			Character.valueOf('@'), Item.stick
				});

		GameRegistry.addRecipe(new ItemStack(spadeTopaz, 1), new Object[]
				{
			" # ", " @ ", " @ ",
			Character.valueOf('#'), gemTopaz,
			Character.valueOf('@'), Item.stick
				});

		GameRegistry.addRecipe(new ItemStack(axeTopaz, 1), new Object[]
				{
			" ##", " @#", " @ ",
			Character.valueOf('#'), gemTopaz,
			Character.valueOf('@'), Item.stick
				});

		GameRegistry.addRecipe(new ItemStack(hoeTopaz, 1), new Object[]
				{
			" ##", " @ ", " @ ",
			Character.valueOf('#'), gemTopaz,
			Character.valueOf('@'), Item.stick
				});
		
		GameRegistry.addRecipe(new ItemStack(swordTopaz, 1), new Object[]
				{
			"#", "#", "@",
			Character.valueOf('#'), gemTopaz,
			Character.valueOf('@'), Item.stick
				});

		// - armour
		// - - Amethyst
		GameRegistry.addRecipe(new ItemStack(helmetAmethyst, 1), new Object[]
				{
			"###", "# #",
			Character.valueOf('#'), gemAmethyst
				});

		GameRegistry.addRecipe(new ItemStack(chestplateAmethyst, 1), new Object[]
				{
			"# #", "###", "###",
			Character.valueOf('#'), gemAmethyst
				});

		GameRegistry.addRecipe(new ItemStack(leggingsAmethyst, 1), new Object[]
				{
			"###", "# #", "# #",
			Character.valueOf('#'), gemAmethyst
				});

		GameRegistry.addRecipe(new ItemStack(bootsAmethyst, 1), new Object[]
				{
			"# #", "# #",
			Character.valueOf('#'), gemAmethyst
				});

		// - - Ruby
		GameRegistry.addRecipe(new ItemStack(helmetRuby, 1), new Object[]
				{
			"###", "# #",
			Character.valueOf('#'), gemRuby
				});

		GameRegistry.addRecipe(new ItemStack(chestplateRuby, 1), new Object[]
				{
			"# #", "###", "###",
			Character.valueOf('#'), gemRuby
				});

		GameRegistry.addRecipe(new ItemStack(leggingsRuby, 1), new Object[]
				{
			"###", "# #", "# #",
			Character.valueOf('#'), gemRuby
				});

		GameRegistry.addRecipe(new ItemStack(bootsRuby, 1), new Object[]
				{
			"# #", "# #",
			Character.valueOf('#'), gemRuby
				});

		// - - Amber
		GameRegistry.addRecipe(new ItemStack(helmetAmber, 1), new Object[]
				{
			"###", "# #",
			Character.valueOf('#'), gemAmber
				});

		GameRegistry.addRecipe(new ItemStack(chestplateAmber, 1), new Object[]
				{
			"# #", "###", "###",
			Character.valueOf('#'), gemAmber
				});

		GameRegistry.addRecipe(new ItemStack(leggingsAmber, 1), new Object[]
				{
			"###", "# #", "# #",
			Character.valueOf('#'), gemAmber
				});

		GameRegistry.addRecipe(new ItemStack(bootsAmber, 1), new Object[]
				{
			"# #", "# #",
			Character.valueOf('#'), gemAmber
				});

		// - - Jade
		GameRegistry.addRecipe(new ItemStack(helmetJade, 1), new Object[]
				{
			"###", "# #",
			Character.valueOf('#'), gemJade
				});

		GameRegistry.addRecipe(new ItemStack(chestplateJade, 1), new Object[]
				{
			"# #", "###", "###",
			Character.valueOf('#'), gemJade
				});

		GameRegistry.addRecipe(new ItemStack(leggingsJade, 1), new Object[]
				{
			"###", "# #", "# #",
			Character.valueOf('#'), gemJade
				});

		GameRegistry.addRecipe(new ItemStack(bootsJade, 1), new Object[]
				{
			"# #", "# #",
			Character.valueOf('#'), gemJade
				});

		// - - Onyx
		GameRegistry.addRecipe(new ItemStack(helmetOnyx, 1), new Object[]
				{
			"###", "# #",
			Character.valueOf('#'), gemOnyx
				});

		GameRegistry.addRecipe(new ItemStack(chestplateOnyx, 1), new Object[]
				{
			"# #", "###", "###",
			Character.valueOf('#'), gemOnyx
				});

		GameRegistry.addRecipe(new ItemStack(leggingsOnyx, 1), new Object[]
				{
			"###", "# #", "# #",
			Character.valueOf('#'), gemOnyx
				});

		GameRegistry.addRecipe(new ItemStack(bootsOnyx, 1), new Object[]
				{
			"# #", "# #",
			Character.valueOf('#'), gemOnyx
				});

		// - - Iolite
		GameRegistry.addRecipe(new ItemStack(helmetIolite, 1), new Object[]
				{
			"###", "# #",
			Character.valueOf('#'), gemIolite
				});

		GameRegistry.addRecipe(new ItemStack(chestplateIolite, 1),new Object[]
				{
			"# #", "###", "###", Character.valueOf('#'), gemIolite
				});

		GameRegistry.addRecipe(new ItemStack(leggingsIolite, 1), new Object[]
				{
			"###", "# #", "# #",
			Character.valueOf('#'), gemIolite
				});

		GameRegistry.addRecipe(new ItemStack(bootsIolite, 1), new Object[]
				{
			"# #", "# #",
			Character.valueOf('#'), gemIolite
				});

		// - - Sapphire
		GameRegistry.addRecipe(new ItemStack(helmetSapphire, 1), new Object[]
				{
			"###", "# #",
			Character.valueOf('#'), gemSapphire
				});

		GameRegistry.addRecipe(new ItemStack(chestplateSapphire, 1),new Object[]
				{
			"# #", "###", "###",
			Character.valueOf('#'), gemSapphire
				});

		GameRegistry.addRecipe(new ItemStack(leggingsSapphire, 1),new Object[]
				{
			"###", "# #", "# #",
			Character.valueOf('#'), gemSapphire
				});

		GameRegistry.addRecipe(new ItemStack(bootsSapphire, 1), new Object[]
				{
			"# #", "# #",
			Character.valueOf('#'), gemSapphire
				});

		// - - Topaz
		GameRegistry.addRecipe(new ItemStack(helmetTopaz, 1), new Object[]
				{
			"###", "# #",
			Character.valueOf('#'), gemTopaz
				});

		GameRegistry.addRecipe(new ItemStack(chestplateTopaz, 1), new Object[]
				{
			"# #", "###", "###",
			Character.valueOf('#'), gemTopaz
				});

		GameRegistry.addRecipe(new ItemStack(leggingsTopaz, 1), new Object[]
				{
			"###", "# #", "# #",
			Character.valueOf('#'), gemTopaz
				});

		GameRegistry.addRecipe(new ItemStack(bootsTopaz, 1), new Object[]
				{
			"# #", "# #",
			Character.valueOf('#'), gemTopaz
				});

		GameRegistry.addRecipe(new ItemStack(saberPurpleOff, 1), new Object[]
				{
			"ABA", "ACA", "ADA",
			Character.valueOf('A'), Item.ingotIron,
			Character.valueOf('B'), beamFocuser, 
			Character.valueOf('C'), new ItemStack(pigmentGenerator, 1, 0),
			Character.valueOf('D'), energyCore
				});

		GameRegistry.addRecipe(new ItemStack(saberRedOff, 1), new Object[]
				{
			"ABA", "ACA", "ADA",
			Character.valueOf('A'), Item.ingotIron,
			Character.valueOf('B'), beamFocuser, 
			Character.valueOf('C'), new ItemStack(pigmentGenerator, 1, 1),
			Character.valueOf('D'), energyCore
				});

		GameRegistry.addRecipe(new ItemStack(saberYellowOff, 1), new Object[]
				{
			"ABA", "ACA", "ADA",
			Character.valueOf('A'), Item.ingotIron,
			Character.valueOf('B'), beamFocuser, 
			Character.valueOf('C'), new ItemStack(pigmentGenerator, 1, 2),
			Character.valueOf('D'), energyCore
				});

		GameRegistry.addRecipe(new ItemStack(saberBlackOff, 1), new Object[]
				{
			"ABA", "ACA", "ADA",
			Character.valueOf('A'), Item.ingotIron,
			Character.valueOf('B'), beamFocuser, 
			Character.valueOf('C'), new ItemStack(pigmentGenerator, 1, 3),
			Character.valueOf('D'), energyCore
				});

		GameRegistry.addRecipe(new ItemStack(saberGreenOff, 1), new Object[]
				{
			"ABA", "ACA", "ADA",
			Character.valueOf('A'), Item.ingotIron,
			Character.valueOf('B'), beamFocuser, 
			Character.valueOf('C'), new ItemStack(pigmentGenerator, 1, 4),
			Character.valueOf('D'), energyCore
				});

		GameRegistry.addRecipe(new ItemStack(saberIndigoOff, 1), new Object[]
				{
			"ABA", "ACA", "ADA",
			Character.valueOf('A'), Item.ingotIron,
			Character.valueOf('B'), beamFocuser, 
			Character.valueOf('C'), new ItemStack(pigmentGenerator, 1, 5),
			Character.valueOf('D'), energyCore
				});

		GameRegistry.addRecipe(new ItemStack(saberDarkBlueOff, 1), new Object[]
				{
			"ABA", "ACA", "ADA",
			Character.valueOf('A'), Item.ingotIron,
			Character.valueOf('B'), beamFocuser, 
			Character.valueOf('C'), new ItemStack(pigmentGenerator, 1, 6),
			Character.valueOf('D'), energyCore
				});

		GameRegistry.addRecipe(new ItemStack(saberGoldOff, 1), new Object[]
				{
			"ABA", "ACA", "ADA",
			Character.valueOf('A'), Item.ingotIron,
			Character.valueOf('B'), beamFocuser, 
			Character.valueOf('C'), new ItemStack(pigmentGenerator, 1, 7),
			Character.valueOf('D'), energyCore
				});

		GameRegistry.addRecipe(new ItemStack(saberLightBlueOff, 1),new Object[]
				{
			"ABA", "ACA", "ADA",
			Character.valueOf('A'), Item.ingotIron,
			Character.valueOf('B'), beamFocuser, 
			Character.valueOf('C'), new ItemStack(pigmentGenerator, 1, 8),
			Character.valueOf('D'), energyCore
				});

		GameRegistry.addRecipe(new ItemStack(gemPower, 9), new Object[]
				{
			"#",
			Character.valueOf('#'), blockPower
				});

		GameRegistry.addRecipe(new ItemStack(blockPower, 1), new Object[]
				{
			"###", "###", "###",
			Character.valueOf('#'), gemPower
				});
		
		GameRegistry.addRecipe(new ItemStack(beamFocuser, 1), new Object[]
				{
			"#A#", "#B#", " C ",
			Character.valueOf('#'), Item.ingotIron,
			Character.valueOf('A'), lens,
			Character.valueOf('B'), Item.redstone,
			Character.valueOf('C'), Item.ingotGold
				});
		
		GameRegistry.addRecipe(new ItemStack(energyCore, 1), new Object[]
				{
			" A ", "#B#", " # ",
			Character.valueOf('#'), Item.ingotIron,
			Character.valueOf('A'), Item.ingotGold,
			Character.valueOf('B'), gemPower
				});
		
		GameRegistry.addRecipe(new ItemStack(pigmentGenerator, 1, 0), new Object[]
				{
			" # ", "#A#", " # ",
			Character.valueOf('#'), Item.ingotIron,
			Character.valueOf('A'), gemAmethyst
				});
		
		GameRegistry.addRecipe(new ItemStack(pigmentGenerator, 1, 1), new Object[]
				{
			" # ", "#A#", " # ",
			Character.valueOf('#'), Item.ingotIron,
			Character.valueOf('A'), gemRuby
				});
		
		GameRegistry.addRecipe(new ItemStack(pigmentGenerator, 1, 2), new Object[]
				{
			" # ", "#A#", " # ",
			Character.valueOf('#'), Item.ingotIron,
			Character.valueOf('A'), gemAmber
				});
		
		GameRegistry.addRecipe(new ItemStack(pigmentGenerator, 1, 3), new Object[]
				{
			" # ", "#A#", " # ",
			Character.valueOf('#'), Item.ingotIron,
			Character.valueOf('A'), gemOnyx
				});
		
		GameRegistry.addRecipe(new ItemStack(pigmentGenerator, 1, 4), new Object[]
				{
			" # ", "#A#", " # ",
			Character.valueOf('#'), Item.ingotIron,
			Character.valueOf('A'), gemJade
				});
		
		GameRegistry.addRecipe(new ItemStack(pigmentGenerator, 1, 5), new Object[]
				{
			" # ", "#A#", " # ",
			Character.valueOf('#'), Item.ingotIron,
			Character.valueOf('A'), gemIolite
				});
		
		GameRegistry.addRecipe(new ItemStack(pigmentGenerator, 1, 6), new Object[]
				{
			" # ", "#A#", " # ",
			Character.valueOf('#'), Item.ingotIron,
			Character.valueOf('A'), gemSapphire
				});
		
		GameRegistry.addRecipe(new ItemStack(pigmentGenerator, 1, 7), new Object[]
				{
			" # ", "#A#", " # ",
			Character.valueOf('#'), Item.ingotIron,
			Character.valueOf('A'), gemTopaz
				});
		
		GameRegistry.addRecipe(new ItemStack(pigmentGenerator, 1, 8), new Object[]
				{
			" # ", "#A#", " # ",
			Character.valueOf('#'), Item.ingotIron,
			Character.valueOf('A'), Item.diamond
				});
		
		GameRegistry.addRecipe(new ItemStack(blasterBattery, 1, 0), new Object[]
				{
			" # ", "# #", "###",
			Character.valueOf('#'), Item.ingotIron,
				});
		
		GameRegistry.addRecipe(new ItemStack(blasterBattery, 1, 15), new Object[]
				{
			" # ", "#A#", "###",
			Character.valueOf('#'), Item.ingotIron,
			Character.valueOf('A'), batteryCharge,
				});
		
		GameRegistry.addShapelessRecipe(new ItemStack(blasterBattery, 1, 15), new Object[]
				{
			blasterBattery, batteryCharge
				});
		
		GameRegistry.addRecipe(new ItemStack(blaster, 1), new Object[]
				{
			" A#", "B##", "  #",
			Character.valueOf('#'), Item.ingotIron,
			Character.valueOf('A'), lens,
			Character.valueOf('B'), Item.diamond
				});
		
		GameRegistry.addShapelessRecipe(new ItemStack(batteryCharge, 1), new Object[]
				{
			Item.redstone, Item.redstone, Item.redstone, Item.lightStoneDust
				});

		GameRegistry.registerWorldGenerator(new OreGenerator());
	}

	static
	{
		// gem ores
		oreAmethyst = (new BlockOre(baseBlockID, 0)).setBlockName("amethystOre");
		oreRuby = (new BlockOre(baseBlockID + 1, 1)).setBlockName("rubyOre");
		oreAmber = (new BlockOre(baseBlockID + 2, 2)).setBlockName("amberOre");
		oreOnyx = (new BlockOre(baseBlockID + 3, 3)).setBlockName("onyxOre");
		oreJade = (new BlockOre(baseBlockID + 4, 4)).setBlockName("jadeOre");
		oreIolite = (new BlockOre(baseBlockID + 5, 5)).setBlockName("ioliteOre");
		oreSapphire = (new BlockOre(baseBlockID + 6, 6)).setBlockName("sapphireOre");
		oreTopaz = (new BlockOre(baseBlockID + 7, 7)).setBlockName("topazOre");
		orePower = (new BlockOre(baseBlockID + 8, 8)).setBlockName("orePower").setLightValue(0.5F);

		// gem blocks
		blockAmethyst = (new BlockStorage(baseBlockID + 9, 9)).setBlockName("amethystBlock");
		blockRuby = (new BlockStorage(baseBlockID + 10, 10)).setBlockName("rubyBlock");
		blockAmber = (new BlockStorage(baseBlockID + 11, 11)).setBlockName("amberBlock");
		blockOnyx = (new BlockStorage(baseBlockID + 12, 12)).setBlockName("onyxBlock");
		blockJade = (new BlockStorage(baseBlockID + 13, 13)).setBlockName("jadeBlock");
		blockIolite = (new BlockStorage(baseBlockID + 14, 14)).setBlockName("ioliteBlock");
		blockSapphire = (new BlockStorage(baseBlockID + 15, 15)).setBlockName("sapphireBlock");
		blockTopaz = (new BlockStorage(baseBlockID + 16, 16)).setBlockName("topazBlock");
		blockPower = (new BlockStorage(baseBlockID + 17, 17)).setBlockName("blockPower").setLightValue(1.0F);

		// gems
		gemAmethyst = (new SaberItem(baseItemID, 144)).setItemName("amethyst");
		gemRuby = (new SaberItem(baseItemID + 1, 145)).setItemName("ruby");
		gemAmber = (new SaberItem(baseItemID + 2, 146)).setItemName("amber");
		gemOnyx = (new SaberItem(baseItemID + 3, 147)).setItemName("onyx");
		gemJade = (new SaberItem(baseItemID + 4, 148)).setItemName("jade");
		gemIolite = (new SaberItem(baseItemID + 5, 149)).setItemName("iolite");
		gemSapphire = (new SaberItem(baseItemID + 6, 150)).setItemName("sapphire");
		gemTopaz = (new SaberItem(baseItemID + 7, 151)).setItemName("topaz");
		gemPower = (new SaberItem(baseItemID + 8, 152)).setItemName("gemPower");

		lens = (new SaberItem(baseItemID + 9, 136)).setItemName("lens");

		// gem tools
		// - Amethyst
		swordAmethyst = (new SaberSword(baseItemID + 10, 64, enumAmethystTool)).setItemName("amethystSword");
		pickaxeAmethyst = (new SaberPickaxe(baseItemID + 11, 96, enumAmethystTool)).setItemName("amethystPickaxe");
		spadeAmethyst = (new SaberSpade(baseItemID + 12, 80, enumAmethystTool)).setItemName("amethystSpade");
		axeAmethyst = (new SaberAxe(baseItemID + 13, 112, enumAmethystTool)).setItemName("amethystAxe");
		hoeAmethyst = (new SaberHoe(baseItemID + 14, 128, enumAmethystTool)).setItemName("amethystHoe");

		// - Ruby
		swordRuby = (new SaberSword(baseItemID + 15, 65, enumRubyTool)).setItemName("rubySword");
		pickaxeRuby = (new SaberPickaxe(baseItemID + 16, 97, enumRubyTool)).setItemName("rubyPickaxe");
		spadeRuby = (new SaberSpade(baseItemID + 17, 81, enumRubyTool)).setItemName("rubySpade");
		axeRuby = (new SaberAxe(baseItemID + 18, 113, enumRubyTool)).setItemName("rubyAxe");
		hoeRuby = (new SaberHoe(baseItemID + 19, 129, enumRubyTool)).setItemName("rubyHoe");

		// - Amber
		swordAmber = (new SaberSword(baseItemID + 20, 66, enumAmberTool)).setItemName("amberSword");
		pickaxeAmber = (new SaberPickaxe(baseItemID + 21, 98, enumAmberTool)).setItemName("amberPickaxe");
		spadeAmber = (new SaberSpade(baseItemID + 22, 82, enumAmberTool)).setItemName("amberSpade");
		axeAmber = (new SaberAxe(baseItemID + 23, 114, enumAmberTool)).setItemName("amberAxe");
		hoeAmber = (new SaberHoe(baseItemID + 24, 130, enumAmberTool)).setItemName("amberHoe");

		// - Onyx
		swordOnyx = (new SaberSword(baseItemID + 25, 67, enumOnyxTool)).setItemName("onyxSword");
		pickaxeOnyx = (new SaberPickaxe(baseItemID + 26, 99, enumOnyxTool)).setItemName("onyxPickaxe");
		spadeOnyx = (new SaberSpade(baseItemID + 27, 83, enumOnyxTool)).setItemName("onyxSpade");
		axeOnyx = (new SaberAxe(baseItemID + 28, 115, enumOnyxTool)).setItemName("onyxAxe");
		hoeOnyx = (new SaberHoe(baseItemID + 29, 131, enumOnyxTool)).setItemName("onyxHoe");

		// - Jade
		swordJade = (new SaberSword(baseItemID + 30, 68, enumJadeTool)).setItemName("jadeSword");
		pickaxeJade = (new SaberPickaxe(baseItemID + 31, 100, enumJadeTool)).setItemName("jadePickaxe");
		spadeJade = (new SaberSpade(baseItemID + 32, 84, enumJadeTool)).setItemName("jadeSpade");
		axeJade = (new SaberAxe(baseItemID + 33, 116, enumJadeTool)).setItemName("jadeAxe");
		hoeJade = (new SaberHoe(baseItemID + 34, 132, enumJadeTool)).setItemName("jadeHoe");

		// - Iolite
		swordIolite = (new SaberSword(baseItemID + 35, 69, enumIoliteTool)).setItemName("ioliteSword");
		pickaxeIolite = (new SaberPickaxe(baseItemID + 36, 101, enumIoliteTool)).setItemName("iolitePickaxe");
		spadeIolite = (new SaberSpade(baseItemID + 37, 85, enumIoliteTool)).setItemName("ioliteSpade");
		axeIolite = (new SaberAxe(baseItemID + 38, 117, enumIoliteTool)).setItemName("ioliteAxe");
		hoeIolite = (new SaberHoe(baseItemID + 39, 133, enumIoliteTool)).setItemName("ioliteHoe");

		// - Sapphire
		swordSapphire = (new SaberSword(baseItemID + 40, 70, enumSapphireTool)).setItemName("sapphireSword");
		pickaxeSapphire = (new SaberPickaxe(baseItemID + 41, 102, enumSapphireTool)).setItemName("sapphirePickaxe");
		spadeSapphire = (new SaberSpade(baseItemID + 42, 86, enumSapphireTool)).setItemName("sapphireSpade");
		axeSapphire = (new SaberAxe(baseItemID + 43, 118, enumSapphireTool)).setItemName("sapphireAxe");
		hoeSapphire = (new SaberHoe(baseItemID + 44, 134, enumSapphireTool)).setItemName("sapphireHoe");

		// - Topaz
		swordTopaz = (new SaberSword(baseItemID + 45, 71, enumTopazTool)).setItemName("topazSword");
		pickaxeTopaz = (new SaberPickaxe(baseItemID + 46, 103, enumTopazTool)).setItemName("topazPickaxe");
		spadeTopaz = (new SaberSpade(baseItemID + 47, 87, enumTopazTool)).setItemName("topazSpade");
		axeTopaz = (new SaberAxe(baseItemID + 48, 119, enumTopazTool)).setItemName("topazAxe");
		hoeTopaz = (new SaberHoe(baseItemID + 49, 135, enumTopazTool)).setItemName("topazHoe");

		// gem armour
		// - Amethyst
		helmetAmethyst = (new SaberArmor(baseItemID + 50, 0, enumAmethystArmour, amethystRenderer, 0)).setItemName("amethystHelmet");
		chestplateAmethyst = (new SaberArmor(baseItemID + 51, 16, enumAmethystArmour, amethystRenderer, 1)).setItemName("amethystChestplate");
		leggingsAmethyst = (new SaberArmor(baseItemID + 52, 32, enumAmethystArmour, amethystRenderer, 2)).setItemName("amethystLeggings");
		bootsAmethyst = (new SaberArmor(baseItemID + 53, 48, enumAmethystArmour, amethystRenderer, 3)).setItemName("amethystBoots");

		// - Ruby
		helmetRuby = (new SaberArmor(baseItemID + 54, 1, enumRubyArmour, rubyRenderer, 0)).setItemName("rubyHelmet");
		chestplateRuby = (new SaberArmor(baseItemID + 55, 17, enumRubyArmour, rubyRenderer, 1)).setItemName("rubyChestplate");
		leggingsRuby = (new SaberArmor(baseItemID + 56, 33, enumRubyArmour, rubyRenderer, 2)).setItemName("rubyLeggings");
		bootsRuby = (new SaberArmor(baseItemID + 57, 49, enumRubyArmour, rubyRenderer, 3)).setItemName("rubyBoots");

		// - Amber
		helmetAmber = (new SaberArmor(baseItemID + 58, 2, enumAmberArmour, amberRenderer, 0)).setItemName("amberHelmet");
		chestplateAmber = (new SaberArmor(baseItemID + 59, 18, enumAmberArmour, amberRenderer, 1)).setItemName("amberChestplate");
		leggingsAmber = (new SaberArmor(baseItemID + 60, 34, enumAmberArmour, amberRenderer, 2)).setItemName("amberLeggings");
		bootsAmber = (new SaberArmor(baseItemID + 61, 50, enumAmberArmour, amberRenderer, 3)).setItemName("amberBoots");

		// - Onyx
		helmetOnyx = (new SaberArmor(baseItemID + 62, 3, enumOnyxArmour, onyxRenderer, 0)).setItemName("onyxHelmet");
		chestplateOnyx = (new SaberArmor(baseItemID + 63, 19, enumOnyxArmour, onyxRenderer, 1)).setItemName("onyxChestplate");
		leggingsOnyx = (new SaberArmor(baseItemID + 64, 35, enumOnyxArmour, onyxRenderer, 2)).setItemName("onyxLeggings");
		bootsOnyx = (new SaberArmor(baseItemID + 65, 51, enumOnyxArmour, onyxRenderer, 3)).setItemName("onyxBoots");

		// - Jade
		helmetJade = (new SaberArmor(baseItemID + 66, 4, enumJadeArmour, jadeRenderer, 0)).setItemName("jadeHelmet");
		chestplateJade = (new SaberArmor(baseItemID + 67, 20, enumJadeArmour, jadeRenderer, 1)).setItemName("jadeChestplate");
		leggingsJade = (new SaberArmor(baseItemID + 68, 36, enumJadeArmour, jadeRenderer, 2)).setItemName("jadeLeggings");
		bootsJade = (new SaberArmor(baseItemID + 69, 52, enumJadeArmour, jadeRenderer, 3)).setItemName("jadeBoots");

		// - Iolite
		helmetIolite = (new SaberArmor(baseItemID + 70, 5, enumIoliteArmour, ioliteRenderer, 0)).setItemName("ioliteHelmet");
		chestplateIolite = (new SaberArmor(baseItemID + 71, 21, enumIoliteArmour, ioliteRenderer, 1)).setItemName("ioliteChestplate");
		leggingsIolite = (new SaberArmor(baseItemID + 72, 37, enumIoliteArmour, ioliteRenderer, 2)).setItemName("ioliteLeggings");
		bootsIolite = (new SaberArmor(baseItemID + 73, 53, enumIoliteArmour, ioliteRenderer, 3)).setItemName("ioliteBoots");

		// - Sapphire
		helmetSapphire = (new SaberArmor(baseItemID + 74, 6, enumSapphireArmour, sapphireRenderer, 0)).setItemName("SapphireHelmet");
		chestplateSapphire = (new SaberArmor(baseItemID + 75, 22, enumSapphireArmour, sapphireRenderer, 1)).setItemName("sapphireChestplate");
		leggingsSapphire = (new SaberArmor(baseItemID + 76, 38, enumSapphireArmour, sapphireRenderer, 2)).setItemName("sapphireLeggings");
		bootsSapphire = (new SaberArmor(baseItemID + 77, 54, enumSapphireArmour, sapphireRenderer, 3)).setItemName("sapphireBoots");

		// - Topaz
		helmetTopaz = (new SaberArmor(baseItemID + 78, 7, enumTopazArmour, topazRenderer, 0)).setItemName("topazHelmet");
		chestplateTopaz = (new SaberArmor(baseItemID + 79, 23, enumTopazArmour, topazRenderer, 1)).setItemName("topazChestplate");
		leggingsTopaz = (new SaberArmor(baseItemID + 80, 39, enumTopazArmour, topazRenderer, 2)).setItemName("topazLeggings");
		bootsTopaz = (new SaberArmor(baseItemID + 81, 55, enumTopazArmour, topazRenderer, 3)).setItemName("topazBoots");

		// lightsabers
		// - Purple
		saberPurpleOff = (new ItemSaberOff(baseItemID + 82, 176)).setItemName("saberPurpleOff");
		saberPurpleOn = (new ItemSaber(baseItemID + 83, 160, saberOn)).setItemName("saberPurpleOn");

		// - Red
		saberRedOff = (new ItemSaberOff(baseItemID + 84, 177)).setItemName("saberRedOff");
		saberRedOn = (new ItemSaber(baseItemID + 85, 161, saberOn)).setItemName("saberRedOn");

		// - Yellow
		saberYellowOff = (new ItemSaberOff(baseItemID + 86, 178)).setItemName("saberYellowOff");
		saberYellowOn = (new ItemSaber(baseItemID + 87, 162, saberOn)).setItemName("saberYellowOn");

		// - Black
		saberBlackOff = (new ItemSaberOff(baseItemID + 88, 179)).setItemName("saberBlackOff");
		saberBlackOn = (new ItemSaber(baseItemID + 89, 163, saberOn)).setItemName("saberBlackOn");

		// - Green
		saberGreenOff = (new ItemSaberOff(baseItemID + 90, 180)).setItemName("saberGreenOff");
		saberGreenOn = (new ItemSaber(baseItemID + 91, 164, saberOn)).setItemName("saberGreenOn");

		// - Indigo
		saberIndigoOff = (new ItemSaberOff(baseItemID + 92, 181)).setItemName("saberIndigoOff");
		saberIndigoOn = (new ItemSaber(baseItemID + 93, 165, saberOn)).setItemName("saberIndigoOn");

		// - DarkBlue
		saberDarkBlueOff = (new ItemSaberOff(baseItemID + 94, 182)).setItemName("saberDarkBlueOff");
		saberDarkBlueOn = (new ItemSaber(baseItemID + 95, 166, saberOn)).setItemName("saberDarkBlueOn");

		// - Gold
		saberGoldOff = (new ItemSaberOff(baseItemID + 96, 183)).setItemName("saberGoldOff");
		saberGoldOn = (new ItemSaber(baseItemID + 97, 167, saberOn)).setItemName("saberGoldOn");

		// - LightBlue
		saberLightBlueOff = (new ItemSaberOff(baseItemID + 98, 184)).setItemName("saberLightBlueOff");
		saberLightBlueOn = (new ItemSaber(baseItemID + 99, 168, saberOn)).setItemName("saberLightBlueOn");
		
		//Star Maps
		starMap = (new SaberStarMap(baseItemID + 100, 120)).setItemName("starMap");
		
		//Saber Pieces
		beamFocuser = (new SaberItem(baseItemID + 101, 88)).setItemName("beamFocuser");
		pigmentGenerator = (new SaberPigment(baseItemID + 102, 192)).setItemName("pigmentGenerator");
		energyCore = (new SaberItem(baseItemID + 103, 104)).setItemName("energyCore");
		
		//Blaster
		blaster = (new SaberBlaster(baseItemID + 104)).setItemName("blaster");
		blasterBattery = (new SaberBlasterBattery(baseItemID + 105)).setItemName("blasterBattery");
		batteryCharge = (new SaberItem(baseItemID + 106, 56)).setItemName("chargeBattery");
	}
}
