package uk.co.toomuchminecraft.sabermod.client;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.EnumSet;
import org.lwjgl.input.Keyboard;

import uk.co.toomuchminecraft.sabermod.SaberMod;

import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet250CustomPayload;
import cpw.mods.fml.client.registry.KeyBindingRegistry.KeyHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.network.PacketDispatcher;

public class SaberExtendKeyHandler extends KeyHandler
{
	static KeyBinding saberExtend = new KeyBinding("Extend Saber", Keyboard.KEY_F);
	private Minecraft mc;

	public SaberExtendKeyHandler()
	{
		super(new KeyBinding[]{saberExtend}, new boolean[]{false});
		mc = Minecraft.getMinecraft();
	}
	
	@Override
	public String getLabel()
	{
		return "SaberExtend";
	}

	@Override
	public EnumSet<TickType> ticks()
	{
		return EnumSet.of(TickType.CLIENT);
	}
	
	private void sendPacket(ItemStack item, int slot, int action, int saberID)
	{
		int itemID = item.itemID;
		int itemDamage = item.getItemDamage();
        	
		ByteArrayOutputStream bos = new ByteArrayOutputStream(20);
		DataOutputStream outputStream = new DataOutputStream(bos);
		try
		{
			outputStream.writeInt(itemID);
			outputStream.writeInt(itemDamage);
			outputStream.writeInt(slot);
			outputStream.writeInt(action);
			outputStream.writeInt(saberID);
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}
		
		Packet250CustomPayload packet = new Packet250CustomPayload();
		packet.channel = "SaberExtend";
        packet.data = bos.toByteArray();
        packet.length = bos.size();
        	
        PacketDispatcher.sendPacketToServer(packet);
        sendSoundPacket(action);
    }
	
	private void sendSoundPacket(int sound)
	{
		ByteArrayOutputStream bos = new ByteArrayOutputStream(4);
		DataOutputStream outputStream = new DataOutputStream(bos);
		
		try
		{
			outputStream.writeInt(sound);
		}
		catch (Exception ex)
        {
        	ex.printStackTrace();
        }

        Packet250CustomPayload packet = new Packet250CustomPayload();
        packet.channel = "SaberSound";
        packet.data = bos.toByteArray();
        packet.length = bos.size();
        PacketDispatcher.sendPacketToServer(packet);
    }
	
	@Override
	public void keyDown(EnumSet<TickType> types, KeyBinding kb, boolean tickEnd, boolean isRepeat)
	{
		if(kb.equals(saberExtend) && mc.inGameHasFocus)
		{
		    ItemStack itemstack = mc.thePlayer.inventory.getCurrentItem();
		    if(itemstack != null)
		    {
		        if(itemstack.itemID == SaberMod.saberPurpleOn.itemID)
		        {
		            sendPacket(itemstack, mc.thePlayer.inventory.currentItem, 0, 0);
		        }
		        
		        if(itemstack.itemID == SaberMod.saberPurpleOff.itemID)
		        {
		        	sendPacket(itemstack, mc.thePlayer.inventory.currentItem, 1, 0);
		        }
		        
		        if(itemstack.itemID == SaberMod.saberRedOn.itemID)
		        {
		        	sendPacket(itemstack, mc.thePlayer.inventory.currentItem, 0, 1);
		        }
		        
		        if(itemstack.itemID == SaberMod.saberRedOff.itemID)
		        {
		        	sendPacket(itemstack, mc.thePlayer.inventory.currentItem, 1, 1);
		        }
		            
		        if(itemstack.itemID == SaberMod.saberYellowOn.itemID)
		        {
		            sendPacket(itemstack, mc.thePlayer.inventory.currentItem, 0, 2);
		        }
		        
		        if(itemstack.itemID == SaberMod.saberYellowOff.itemID)
		        {
		        	sendPacket(itemstack, mc.thePlayer.inventory.currentItem, 1, 2);
		        }
		            
		        if(itemstack.itemID == SaberMod.saberGreenOn.itemID)
		        {
		            sendPacket(itemstack, mc.thePlayer.inventory.currentItem, 0, 3);
		        }
		            
		        if(itemstack.itemID == SaberMod.saberGreenOff.itemID)
		        {
		            sendPacket(itemstack, mc.thePlayer.inventory.currentItem, 1, 3);
		        }
		            
		        if(itemstack.itemID == SaberMod.saberBlackOn.itemID)
		        {
		            sendPacket(itemstack, mc.thePlayer.inventory.currentItem, 0, 4);
		        }
		            
		        if(itemstack.itemID == SaberMod.saberBlackOff.itemID)
		        {
		            sendPacket(itemstack, mc.thePlayer.inventory.currentItem, 1, 4);
		        }
		            
		        if(itemstack.itemID == SaberMod.saberIndigoOn.itemID)
		        {
		            sendPacket(itemstack, mc.thePlayer.inventory.currentItem, 0, 5);
		        }
		            
		        if(itemstack.itemID == SaberMod.saberIndigoOff.itemID)
		        {
		            sendPacket(itemstack, mc.thePlayer.inventory.currentItem, 1, 5);
		        }
		            
		        if(itemstack.itemID == SaberMod.saberDarkBlueOn.itemID)
		        {
		            sendPacket(itemstack, mc.thePlayer.inventory.currentItem, 0, 6);
		        }
		            
		        if(itemstack.itemID == SaberMod.saberDarkBlueOff.itemID)
		        {
		            sendPacket(itemstack, mc.thePlayer.inventory.currentItem, 1, 6);
		        }
		            
		        if(itemstack.itemID == SaberMod.saberGoldOn.itemID)
		        {
		            sendPacket(itemstack, mc.thePlayer.inventory.currentItem, 0, 7);
		        }
		            
		        if(itemstack.itemID == SaberMod.saberGoldOff.itemID)
		        {
		            sendPacket(itemstack, mc.thePlayer.inventory.currentItem, 1, 7);
		        }
		            
		        if(itemstack.itemID == SaberMod.saberLightBlueOn.itemID)
		        {
		            sendPacket(itemstack, mc.thePlayer.inventory.currentItem, 0, 8);
		        }
		            
		        if(itemstack.itemID == SaberMod.saberLightBlueOff.itemID)
		        {
		            sendPacket(itemstack, mc.thePlayer.inventory.currentItem, 1, 8);
		        }
		    }
		}
	}

	@Override
	public void keyUp(EnumSet<TickType> types, KeyBinding kb, boolean tickEnd)
	{
			
	}
}