/*
 * Decompiled with CFR 0.152.
 */
package net.rubeAurora;

import java.util.ArrayList;
import java.util.Random;
import net.rubeAurora.ColorShifter;
import net.rubeAurora.EntityEnvEffect;
import net.rubeAurora.EnumColors;
import net.rubeAurora.IDebug;
import net.rubeAurora.Node;
import net.rubeAurora.RubeAurora;
import net.rubeAurora.ServerAurora;

public class Aurora
extends EntityEnvEffect
implements IDebug {
    private Random nodeRand;
    private long time;
    public Node[] array;
    public long ticksExisted;
    public float posX;
    public float posZ;
    public float ticker = 0.0f;
    public int fadeTimer = 0;
    public boolean terminate = true;
    public ServerAurora serverRep;
    private int length = 256;
    private float nodeLength = 7.0f;
    private float nodeWidth = 30.0f;
    private int bandOffset = 60;

    public Aurora(yc par1World, float x, float z, long t) {
        super(par1World);
        this.alterPresets(Preset.NORMAL);
        this.time = t;
        this.posX = x;
        this.posZ = z;
        this.ticksExisted = 0L;
        this.array = this.populateNodeListFromCenterAlt();
        this.serverRep = new ServerAurora((int)x, (int)z, t);
        this.addNodeArray(this.array);
        if (RubeAurora.multiples) {
            Node[] secondary = this.formBand(this.array, this.bandOffset);
            Node[] third = this.formBand(this.array, -this.bandOffset);
            this.addNodeArray(secondary);
            this.addNodeArray(third);
        }
    }

    @Override
    public void update() {
        if (this.fadeTimer < 1280) {
            if (this.fadeTimer % 10 == 0) {
                this.fade(this.terminate);
            }
            ++this.fadeTimer;
        }
        this.ticker = this.ticker < 360.0f ? (this.ticker += RubeAurora.auroraSpeed) : 0.0f;
        ++this.ticksExisted;
    }

    @Override
    public ArrayList getNodeList() {
        return this.nodeList;
    }

    public long getTime() {
        return this.time;
    }

    @Override
    public void translateNodeList() {
    }

    private void alterPresets(Preset pre) {
        switch (pre) {
            case NORMAL: {
                return;
            }
            case PIXILED: {
                this.length = 128;
                this.nodeWidth = 30.0f;
                this.nodeLength = 30.0f;
                this.bandOffset = 90;
                return;
            }
        }
    }

    private Node[] populateNodeListLine() {
        int length = RubeAurora.auroraLength;
        Node[] nArray = new Node[length];
        this.nodeRand = new Random(this.time);
        for (int i = 0; i < length; ++i) {
            float y = 1.0f + this.nodeRand.nextFloat();
            nArray[i] = new Node(i, y, 0.0f, 0.0f);
        }
        return nArray;
    }

    private Node[] populateRainbowArray() {
        Node[] nArray = new Node[12];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = new Node((float)(i * 2), 5.0f, 0.0f, 0.0f, EnumColors.get(i));
            nArray[i].printNode();
        }
        return nArray;
    }

    private Node[] formBand(Node[] node, int offset) {
        Node[] tet = new Node[node.length];
        for (int i = 0; i < node.length; ++i) {
            float posX = node[i].posX + (float)Math.cos(Math.toRadians(90.0f + node[i].getAngle())) * (float)offset;
            float posZ = node[i].posZ + (float)Math.sin(Math.toRadians(90.0f + node[i].getAngle())) * (float)offset;
            tet[i] = new Node(posX, node[i].posY - 2.0f, posZ, node[i].getAngle());
        }
        return this.alterWidths(tet, 10.0f);
    }

    private void fade(boolean boo) {
        int i = 1;
        if (!boo) {
            i = -1;
        }
        for (Object array : this.nodeList) {
            for (Node a : (Node[])array) {
                a.addA(i);
            }
        }
    }

    private Node[] populateNodeListFromCenterAlt() {
        float x;
        float z;
        Node[] nArray = new Node[this.length];
        this.nodeRand = new Random(this.time);
        float angleTotal = 0.0f;
        for (int i = this.length / 8 / 2 - 1; i >= 0; --i) {
            float angle = (this.nodeRand.nextFloat() - 0.5f) * 8.0f;
            if (Math.abs(angleTotal += angle) > 180.0f) {
                angle = -angle;
                angleTotal += angle;
            }
            for (int k = 7; k >= 0; --k) {
                if (i * 8 + k == this.length / 2 - 1) {
                    nArray[i * 8 + k] = new Node(0.0f, 7.0f + this.nodeRand.nextFloat(), 0.0f, angle);
                    continue;
                }
                float subAngle = nArray[i * 8 + k + 1].getAngle() + angle;
                float y = 10.0f + this.nodeRand.nextFloat() * 5.0f;
                if (i == 0) {
                    y = (float)Math.sin(0.19634954084936207 * (double)k) * 7.0f + this.nodeRand.nextFloat() / 2.0f;
                }
                z = nArray[i * 8 + k + 1].posZ - (float)(Math.sin((double)subAngle / 56.26) * (double)this.nodeLength);
                x = nArray[i * 8 + k + 1].posX - (float)(Math.cos((double)subAngle / 56.26) * (double)this.nodeLength);
                nArray[i * 8 + k] = new Node(x, y, z, subAngle);
            }
        }
        angleTotal = 0.0f;
        for (int j = this.length / 8 / 2; j < this.length / 8; ++j) {
            float angle1 = (this.nodeRand.nextFloat() - 0.5f) * 8.0f;
            if (Math.abs(angleTotal += angle1) > 180.0f) {
                angle1 = -angle1;
                angleTotal += angle1;
            }
            for (int h = 0; h < 8; ++h) {
                float y = 10.0f + this.nodeRand.nextFloat() * 5.0f;
                if (j == this.length / 8 - 1) {
                    y = (float)Math.cos(0.2243994752564138 * (double)h) * 7.0f + this.nodeRand.nextFloat() / 2.0f;
                }
                float subAngle = nArray[j * 8 + h - 1].getAngle() + angle1;
                z = nArray[j * 8 + h - 1].posZ + (float)(Math.sin((double)subAngle / 57.26) * (double)this.nodeLength);
                x = nArray[j * 8 + h - 1].posX + (float)(Math.cos((double)subAngle / 57.26) * (double)this.nodeLength);
                nArray[j * 8 + h] = new Node(x, y, z, subAngle);
            }
        }
        return this.alterWidths(nArray, this.nodeWidth);
    }

    @Override
    public Node[] translateNodeArray(Node[] node, float partialTick) {
        Node[] nArray = node;
        for (int i = 0; i < node.length; ++i) {
            float f = (float)Math.sin((double)(RubeAurora.waveLength * (float)i + this.ticker + RubeAurora.auroraSpeed * partialTick) / 57.29577);
            nArray[i].setModZ(f * RubeAurora.auroraAmplitude);
            nArray[i].setModY(f * 3.0f);
        }
        return this.findAngles(nArray);
    }

    public void shiftColorRainBow(Node[] node) {
        for (Node n : node) {
            ColorShifter.shiftColorsRange(n.color, ColorShifter.findNextColor(n.color, true), true);
        }
    }

    private Node[] alterWidths(Node[] node, float widthMax) {
        Node[] nArray = node;
        int count = 0;
        for (int i = 0; i < node.length; ++i) {
            float x = widthMax;
            if (i <= node.length / 8) {
                x = (float)Math.sin(Math.PI / (double)(node.length / 4) * (double)count) * widthMax;
                ++count;
            }
            if (i >= node.length * 7 / 8) {
                x = (float)Math.sin(Math.PI / (double)(node.length / 4) * (double)count) * widthMax;
                --count;
            }
            nArray[i].width = x;
        }
        return nArray;
    }

    private Node[] findAngles(Node[] node) {
        Node[] nArray = node;
        for (int i = 0; i < node.length; ++i) {
            float angle = 0.0f;
            float x = 0.0f;
            float x2 = 0.0f;
            float z = 0.0f;
            float z2 = 0.0f;
            if (i < node.length - 1 && i != 0) {
                angle = (float)Math.atan2(nArray[i].getModdedZ() - nArray[i + 1].getModdedZ(), nArray[i].posX - nArray[i + 1].posX);
                float deg90 = angle + 1.5707964f;
                float deg270 = deg90 + (float)Math.PI;
                x = node[i].posX + (float)Math.cos(deg90) * node[i].width;
                x2 = node[i].posX + (float)Math.cos(deg270) * node[i].width;
                z = node[i].getModdedZ() + (float)Math.sin(deg90) * node[i].width;
                z2 = node[i].getModdedZ() + (float)Math.sin(deg270) * node[i].width;
            } else {
                x2 = x = node[i].posX;
                z2 = z = node[i].getModdedZ();
            }
            nArray[i].setAngle(angle);
            nArray[i].setTet(x, x2, z, z2);
        }
        return nArray;
    }

    @Override
    public String name() {
        return "Aurora";
    }

    static enum Preset {
        NORMAL,
        PIXILED;

    }
}

