/*
 * Decompiled with CFR 0.152.
 */
package net.rubeAurora;

import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import net.rubeAurora.AuroraCommon;
import net.rubeAurora.CommonTickHandler;
import net.rubeAurora.Debug;
import net.rubeAurora.IDebug;
import net.rubeAurora.RubeAurora;
import net.rubeAurora.ServerAurora;

public class PacketHandler
implements IPacketHandler,
IDebug {
    public void onPacketData(ce manager, di packet, Player player) {
        if (packet.a.equals("auroraSending")) {
            this.handleAuroraClient(packet);
        }
        if (packet.a.equals("auroraRequest")) {
            this.handleAuroraRequest(player);
        }
    }

    private void handleAuroraRequest(Player player) {
        Debug.println(this, "Received aurora request from " + player);
        if (AuroraCommon.activeServerAuroras.size() > 0) {
            for (Object a : AuroraCommon.activeServerAuroras) {
                CommonTickHandler.sendPacket((ServerAurora)a, player);
            }
        }
    }

    private void handleAuroraClient(di packet) {
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(packet.c));
        try {
            long time = inputStream.readLong();
            int posX = inputStream.readInt();
            int posZ = inputStream.readInt();
            Debug.println(this, "Time = " + time + " Pos X = " + posX + " PosZ = " + posZ);
            RubeAurora.proxy.addAurora(time, posX, posZ);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String name() {
        return "Packet Handler";
    }
}

