/*
 * Decompiled with CFR 0.152.
 */
package net.rubeAurora;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import java.util.logging.Level;
import net.minecraftforge.common.Configuration;
import net.rubeAurora.AuroraCommon;
import net.rubeAurora.Debug;
import net.rubeAurora.IDebug;
import net.rubeAurora.PacketHandler;

@Mod(modid="RubeAurora", name="Mr. Rube's Aurora Mod", version="v1.0.1 for Mc 1.4.7")
@NetworkMod(clientSideRequired=false, serverSideRequired=false, channels={"auroraSending", "auroraRequest"}, versionBounds="1.4.7e", packetHandler=PacketHandler.class)
public class RubeAurora
implements IDebug {
    private static String defaultList = "Taiga,FrozenOcean,FrozenRiver,Ice Plains,Ice Mountains,TaigaHills";
    public static int auroraLength = 256;
    public static float auroraSpeed = 0.75f;
    public static float auroraAmplitude = 18.0f;
    public static float waveLength = 8.0f;
    public static String[] auroraBiomeList;
    public static boolean aniAuroras;
    public static boolean auroraLocking;
    public static boolean debug;
    public static boolean multiples;
    public static boolean versionChecking;
    public Configuration preInitConfig;
    public static String version;
    public static String versionURL;
    public static String dlURL;
    @SidedProxy(clientSide="net.rubeAurora.AuroraClient", serverSide="net.rubeAurora.AuroraCommon")
    public static AuroraCommon proxy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent event) {
        this.preInitConfig = new Configuration(event.getSuggestedConfigurationFile());
        try {
            this.preInitConfig.load();
            this.getBiomeList();
            this.setConfig();
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.SEVERE, (Throwable)e, (String)"Aurora has a problem loading it's configuration", (Object[])new Object[0]);
        }
        finally {
            this.preInitConfig.save();
        }
    }

    @Mod.Init
    public void load(FMLInitializationEvent event) {
        proxy.registerTickHandlers();
        Debug.println(this, "Aurora Mod initialized. OuO");
    }

    @Mod.PostInit
    public void myNewPostLoadMethod(FMLPostInitializationEvent evt) {
        Debug.println(this, "Derp");
    }

    public static void setSpeed(float f) {
        auroraSpeed = f;
    }

    public static void setAmplitude(float f) {
        auroraAmplitude = f;
    }

    public static void setWaveLength(float f) {
        waveLength = f;
    }

    private void setConfig() {
        auroraLocking = this.preInitConfig.get("general", "Aurora Y Translation", false).getBoolean(true);
        debug = this.preInitConfig.get("general", "Debug information", false).getBoolean(true);
        multiples = this.preInitConfig.get("general", "Multiple Bands", true).getBoolean(true);
        versionChecking = this.preInitConfig.get("general", "Version Checking", true).getBoolean(true);
    }

    private void getBiomeList() {
        Debug.println(this, "Attempting to get Biome List");
        String s = this.preInitConfig.get((String)"general", (String)"biome list", (String)RubeAurora.defaultList).value;
        String[] a = s.split(",");
        Debug.println(this, s);
        auroraBiomeList = a;
    }

    @Override
    public String name() {
        return "Aurora Mod";
    }

    static {
        aniAuroras = true;
        version = "1.0.1";
        versionURL = "http://mrrube.com/version/auroraversion.txt";
        dlURL = "http://www.mrrube.com/aurora-mod/download/";
    }
}

