/*
 * Decompiled with CFR 0.152.
 */
package explosionphysics;

import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.FallingBlock;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;

public class ExplosionPhysics
extends JavaPlugin
implements Listener {
    public ArrayList<Material> disallowedBlocks = new ArrayList();

    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)new ExplosionPhysics(), (Plugin)this);
        this.disallowedBlocks.clear();
        this.disallowedBlocks.add(Material.TNT);
        this.disallowedBlocks.add(Material.PISTON_BASE);
        this.disallowedBlocks.add(Material.PISTON_EXTENSION);
        this.disallowedBlocks.add(Material.PISTON_MOVING_PIECE);
        this.disallowedBlocks.add(Material.PISTON_STICKY_BASE);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onBlockExplode(EntityExplodeEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (e.blockList().isEmpty()) {
            return;
        }
        e.setYield(0.0f);
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        Location eLoc = e.getLocation();
        World w = eLoc.getWorld();
        for (int i = 0; i < e.blockList().size(); ++i) {
            Block b = (Block)e.blockList().get(i);
            Location bLoc = b.getLocation();
            if (this.disallowedBlocks.contains(b.getType())) continue;
            x = bLoc.getX() - eLoc.getX();
            y = bLoc.getY() - eLoc.getY() + 0.5;
            z = bLoc.getZ() - eLoc.getZ();
            FallingBlock fb = w.spawnFallingBlock(bLoc, b.getType(), b.getData());
            fb.setDropItem(false);
            fb.setVelocity(new Vector(x *= 1.3, y *= 1.3, z *= 1.3));
        }
    }
}

