/*
 * Decompiled with CFR 0.152.
 */
package mods.natura;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Random;
import mods.natura.CloudMaterial;
import mods.natura.common.NCommonProxy;
import mods.natura.common.NaturaContent;
import mods.natura.common.NaturaTab;
import mods.natura.common.PHNatura;
import mods.natura.worldgen.BaseCloudWorldgen;
import mods.natura.worldgen.BaseCropWorldgen;
import mods.natura.worldgen.BaseTreeWorldgen;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;

@Mod(modid="Natura", name="Natura", version="1.5.1_2.0.19")
public class Natura {
    @SidedProxy(clientSide="mods.natura.client.NClientProxy", serverSide="mods.natura.common.NCommonProxy")
    public static NCommonProxy proxy;
    @Mod.Instance(value="Natura")
    public static Natura instance;
    public static Material cloud;
    NaturaContent content;
    public static Random random;

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        PHNatura.initProps();
        this.content = new NaturaContent();
        this.content.preInit();
    }

    @Mod.Init
    public void init(FMLInitializationEvent evt) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new BaseCropWorldgen());
        GameRegistry.registerWorldGenerator((IWorldGenerator)new BaseCloudWorldgen());
        GameRegistry.registerWorldGenerator((IWorldGenerator)new BaseTreeWorldgen());
        NaturaTab.init(NaturaContent.wheatBag.field_77779_bT);
        proxy.registerRenderer();
        proxy.addNames();
    }

    @Mod.PostInit
    public void postInit(FMLPostInitializationEvent evt) {
        this.content.addModSupport();
    }

    @ForgeSubscribe
    public void bonemealEvent(BonemealEvent event) {
        if (event.ID == NaturaContent.crops.field_71990_ca) {
            if (NaturaContent.crops.boneFertilize(event.world, event.X, event.Y, event.Z)) {
                event.setResult(Event.Result.ALLOW);
            }
        }
        if (event.ID == NaturaContent.floraSapling.field_71990_ca) {
            if (NaturaContent.floraSapling.boneFertilize(event.world, event.X, event.Y, event.Z, event.world.field_73012_v)) {
                event.setResult(Event.Result.ALLOW);
            }
        }
    }

    @ForgeSubscribe
    public void interactEvent(EntityInteractEvent event) {
        if (event.target instanceof EntityCow || event.target instanceof EntitySheep) {
            ItemStack equipped = event.entityPlayer.func_71045_bC();
            EntityAnimal creature = (EntityAnimal)event.target;
            if (equipped != null && equipped.field_77993_c == NaturaContent.plantItem.field_77779_bT && equipped.func_77960_j() == 0 && creature.func_70874_b() == 0 && creature.field_70881_d <= 0) {
                EntityPlayer player = event.entityPlayer;
                if (!player.field_71075_bZ.field_75098_d) {
                    --equipped.field_77994_a;
                    if (equipped.field_77994_a <= 0) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
                    }
                }
                creature.field_70881_d = 600;
                creature.func_70784_b(null);
                for (int i = 0; i < 7; ++i) {
                    double d0 = random.nextGaussian() * 0.02;
                    double d1 = random.nextGaussian() * 0.02;
                    double d2 = random.nextGaussian() * 0.02;
                    creature.field_70170_p.func_72869_a("heart", creature.field_70165_t + (double)(random.nextFloat() * creature.field_70130_N * 2.0f) - (double)creature.field_70130_N, creature.field_70163_u + 0.5 + (double)(random.nextFloat() * creature.field_70131_O), creature.field_70161_v + (double)(random.nextFloat() * creature.field_70130_N * 2.0f) - (double)creature.field_70130_N, d0, d1, d2);
                }
            }
        }
    }

    @ForgeSubscribe
    public void spawnEvent(LivingSpawnEvent event) {
        if (event.entityLiving instanceof EntityCow || event.entityLiving instanceof EntitySheep) {
            event.entityLiving.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)event.entityLiving, 0.25f, NaturaContent.plantItem.field_77779_bT, false));
        }
        if (event.entityLiving instanceof EntityChicken) {
            event.entityLiving.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)event.entityLiving, 0.25f, NaturaContent.seeds.field_77779_bT, false));
        }
    }

    static {
        cloud = new CloudMaterial();
        random = new Random();
    }
}

