/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.dimension;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCavesHell;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.feature.WorldGenFire;
import net.minecraft.world.gen.feature.WorldGenFlowers;
import net.minecraft.world.gen.feature.WorldGenGlowStone1;
import net.minecraft.world.gen.feature.WorldGenGlowStone2;
import net.minecraft.world.gen.feature.WorldGenHellLava;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.structure.MapGenNetherBridge;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.terraingen.ChunkProviderEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class NetheriteChunkProvider
implements IChunkProvider {
    private Random random;
    private NoiseGeneratorOctaves netherNoiseGen1;
    private NoiseGeneratorOctaves netherNoiseGen2;
    private NoiseGeneratorOctaves netherNoiseGen3;
    private NoiseGeneratorOctaves slowsandGravelNoiseGen;
    private NoiseGeneratorOctaves netherrackExculsivityNoiseGen;
    public NoiseGeneratorOctaves netherNoiseGen6;
    public NoiseGeneratorOctaves netherNoiseGen7;
    private World worldObj;
    private double[] noiseField;
    public MapGenNetherBridge genNetherBridge = new MapGenNetherBridge();
    private double[] slowsandNoise = new double[256];
    private double[] gravelNoise = new double[256];
    private double[] netherrackExclusivityNoise = new double[256];
    private MapGenBase netherCaveGenerator = new MapGenCavesHell();
    double[] noiseData1;
    double[] noiseData2;
    double[] noiseData3;
    double[] noiseData4;
    double[] noiseData5;

    public NetheriteChunkProvider(World par1World, long par2) {
        this.genNetherBridge = (MapGenNetherBridge)TerrainGen.getModdedMapGen((MapGenBase)this.genNetherBridge, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.NETHER_BRIDGE);
        this.netherCaveGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.netherCaveGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.NETHER_CAVE);
        this.worldObj = par1World;
        this.random = new Random(par2);
        this.netherNoiseGen1 = new NoiseGeneratorOctaves(this.random, 16);
        this.netherNoiseGen2 = new NoiseGeneratorOctaves(this.random, 16);
        this.netherNoiseGen3 = new NoiseGeneratorOctaves(this.random, 8);
        this.slowsandGravelNoiseGen = new NoiseGeneratorOctaves(this.random, 4);
        this.netherrackExculsivityNoiseGen = new NoiseGeneratorOctaves(this.random, 4);
        this.netherNoiseGen6 = new NoiseGeneratorOctaves(this.random, 10);
        this.netherNoiseGen7 = new NoiseGeneratorOctaves(this.random, 16);
        NoiseGeneratorOctaves[] noiseGens = new NoiseGeneratorOctaves[]{this.netherNoiseGen1, this.netherNoiseGen2, this.netherNoiseGen3, this.slowsandGravelNoiseGen, this.netherrackExculsivityNoiseGen, this.netherNoiseGen6, this.netherNoiseGen7};
        noiseGens = TerrainGen.getModdedNoiseGenerators((World)par1World, (Random)this.random, (NoiseGeneratorOctaves[])noiseGens);
        this.netherNoiseGen1 = noiseGens[0];
        this.netherNoiseGen2 = noiseGens[1];
        this.netherNoiseGen3 = noiseGens[2];
        this.slowsandGravelNoiseGen = noiseGens[3];
        this.netherrackExculsivityNoiseGen = noiseGens[4];
        this.netherNoiseGen6 = noiseGens[5];
        this.netherNoiseGen7 = noiseGens[6];
    }

    public void generateNetherTerrain(int chunkX, int chunkZ, byte[] blockArray) {
        int initialSize = 4;
        int b1 = 32;
        int kay = initialSize + 1;
        int oneSeven = 17;
        int zee = initialSize + 1;
        this.noiseField = this.initializeNoiseField(this.noiseField, chunkX * initialSize, 0, chunkZ * initialSize, kay, oneSeven, zee);
        for (int iterOne = 0; iterOne < initialSize; ++iterOne) {
            for (int iterTwo = 0; iterTwo < initialSize; ++iterTwo) {
                for (int iterThree = 0; iterThree < 16; ++iterThree) {
                    double d0 = 0.125;
                    double d1 = this.noiseField[((iterOne + 0) * zee + iterTwo + 0) * oneSeven + iterThree + 0];
                    double d2 = this.noiseField[((iterOne + 0) * zee + iterTwo + 1) * oneSeven + iterThree + 0];
                    double d3 = this.noiseField[((iterOne + 1) * zee + iterTwo + 0) * oneSeven + iterThree + 0];
                    double d4 = this.noiseField[((iterOne + 1) * zee + iterTwo + 1) * oneSeven + iterThree + 0];
                    double d5 = (this.noiseField[((iterOne + 0) * zee + iterTwo + 0) * oneSeven + iterThree + 1] - d1) * d0;
                    double d6 = (this.noiseField[((iterOne + 0) * zee + iterTwo + 1) * oneSeven + iterThree + 1] - d2) * d0;
                    double d7 = (this.noiseField[((iterOne + 1) * zee + iterTwo + 0) * oneSeven + iterThree + 1] - d3) * d0;
                    double d8 = (this.noiseField[((iterOne + 1) * zee + iterTwo + 1) * oneSeven + iterThree + 1] - d4) * d0;
                    for (int idtop = 0; idtop < 8; ++idtop) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int idbase = 0; idbase < 4; ++idbase) {
                            int idInArray = idbase + iterOne * 4 << 11 | 0 + iterTwo * 4 << 7 | iterThree * 8 + idtop;
                            int short1 = 128;
                            double quarter = 0.25;
                            double d15 = d10;
                            double d16 = (d11 - d10) * quarter;
                            for (int k2 = 0; k2 < 4; ++k2) {
                                int l2 = 0;
                                if (iterThree * 8 + idtop < b1) {
                                    l2 = Block.field_71943_B.field_71990_ca;
                                }
                                if (d15 > 0.0) {
                                    l2 = Block.field_72012_bb.field_71990_ca;
                                }
                                blockArray[idInArray] = (byte)l2;
                                idInArray += short1;
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void replaceBlocksForBiome(int chunkX, int chunkZ, byte[] blockArray) {
        ChunkProviderEvent.ReplaceBiomeBlocks event = new ChunkProviderEvent.ReplaceBiomeBlocks((IChunkProvider)this, chunkX, chunkZ, blockArray, null);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return;
        }
        int b0 = 64;
        double d0 = 0.03125;
        this.slowsandNoise = this.slowsandGravelNoiseGen.func_76304_a(this.slowsandNoise, chunkX * 16, chunkZ * 16, 0, 16, 16, 1, d0, d0, 1.0);
        this.gravelNoise = this.slowsandGravelNoiseGen.func_76304_a(this.gravelNoise, chunkX * 16, 109, chunkZ * 16, 16, 1, 16, d0, 1.0, d0);
        this.netherrackExclusivityNoise = this.netherrackExculsivityNoiseGen.func_76304_a(this.netherrackExclusivityNoise, chunkX * 16, chunkZ * 16, 0, 16, 16, 1, d0 * 2.0, d0 * 2.0, d0 * 2.0);
        for (int iterX = 0; iterX < 16; ++iterX) {
            for (int iterZ = 0; iterZ < 16; ++iterZ) {
                boolean flag = this.slowsandNoise[iterX + iterZ * 16] + this.random.nextDouble() * 0.2 > 0.0;
                boolean flag1 = this.gravelNoise[iterX + iterZ * 16] + this.random.nextDouble() * 0.2 > 0.0;
                int i1 = (int)(this.netherrackExclusivityNoise[iterX + iterZ * 16] / 3.0 + 3.0 + this.random.nextDouble() * 0.25);
                int j1 = -1;
                byte b1 = (byte)Block.field_72012_bb.field_71990_ca;
                byte b2 = (byte)Block.field_72012_bb.field_71990_ca;
                for (int iterY = 255; iterY >= 0; --iterY) {
                    int blockPos = (iterZ * 16 + iterX) * 256 + iterY;
                    if (iterY < 255 - this.random.nextInt(5) && iterY > 0 + this.random.nextInt(5)) {
                        byte replaceID = blockArray[blockPos];
                        if (replaceID == 0) {
                            j1 = -1;
                            continue;
                        }
                        if (replaceID != Block.field_72012_bb.field_71990_ca) continue;
                        if (j1 == -1) {
                            if (i1 <= 0) {
                                b1 = 0;
                                b2 = (byte)Block.field_72012_bb.field_71990_ca;
                            } else if (iterY >= b0 - 4 && iterY <= b0 + 1) {
                                b1 = (byte)Block.field_72012_bb.field_71990_ca;
                                b2 = (byte)Block.field_72012_bb.field_71990_ca;
                                if (flag1) {
                                    b1 = (byte)Block.field_71940_F.field_71990_ca;
                                }
                                if (flag1) {
                                    b2 = (byte)Block.field_72012_bb.field_71990_ca;
                                }
                                if (flag) {
                                    b1 = (byte)Block.field_72013_bc.field_71990_ca;
                                }
                                if (flag) {
                                    b2 = (byte)Block.field_72013_bc.field_71990_ca;
                                }
                            }
                            if (iterY < b0 && b1 == 0) {
                                b1 = (byte)Block.field_71943_B.field_71990_ca;
                            }
                            j1 = i1;
                            if (iterY >= b0 - 1) {
                                blockArray[blockPos] = b1;
                                continue;
                            }
                            blockArray[blockPos] = b2;
                            continue;
                        }
                        if (j1 <= 0) continue;
                        --j1;
                        blockArray[blockPos] = b2;
                        continue;
                    }
                    blockArray[blockPos] = (byte)Block.field_71986_z.field_71990_ca;
                }
            }
        }
    }

    public Chunk func_73158_c(int chunkX, int chunkZ) {
        return this.func_73154_d(chunkX, chunkZ);
    }

    public Chunk func_73154_d(int chunkX, int chunkZ) {
        this.random.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        byte[] blockArray = new byte[65536];
        this.generateNetherTerrain(chunkX, chunkZ, blockArray);
        this.replaceBlocksForBiome(chunkX, chunkZ, blockArray);
        this.netherCaveGenerator.func_75036_a((IChunkProvider)this, this.worldObj, chunkX, chunkZ, blockArray);
        this.genNetherBridge.func_75036_a((IChunkProvider)this, this.worldObj, chunkX, chunkZ, blockArray);
        Chunk chunk = new Chunk(this.worldObj, blockArray, chunkX, chunkZ);
        BiomeGenBase[] abiomegenbase = this.worldObj.func_72959_q().func_76933_b((BiomeGenBase[])null, chunkX * 16, chunkZ * 16, 16, 16);
        byte[] abyte1 = chunk.func_76605_m();
        for (int k = 0; k < abyte1.length; ++k) {
            abyte1[k] = (byte)abiomegenbase[k].field_76756_M;
        }
        chunk.func_76613_n();
        return chunk;
    }

    private double[] initializeNoiseField(double[] noiseField, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ) {
        int i2;
        ChunkProviderEvent.InitNoiseField event = new ChunkProviderEvent.InitNoiseField((IChunkProvider)this, noiseField, posX, posY, posZ, sizeX, sizeY, sizeZ);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return event.noisefield;
        }
        if (noiseField == null) {
            noiseField = new double[sizeX * sizeY * sizeZ];
        }
        double d0 = 684.412;
        double d1 = 2053.236;
        this.noiseData4 = this.netherNoiseGen6.func_76304_a(this.noiseData4, posX, posY, posZ, sizeX, 1, sizeZ, 1.0, 0.0, 1.0);
        this.noiseData5 = this.netherNoiseGen7.func_76304_a(this.noiseData5, posX, posY, posZ, sizeX, 1, sizeZ, 100.0, 0.0, 100.0);
        this.noiseData1 = this.netherNoiseGen3.func_76304_a(this.noiseData1, posX, posY, posZ, sizeX, sizeY, sizeZ, d0 / 80.0, d1 / 60.0, d0 / 80.0);
        this.noiseData2 = this.netherNoiseGen1.func_76304_a(this.noiseData2, posX, posY, posZ, sizeX, sizeY, sizeZ, d0, d1, d0);
        this.noiseData3 = this.netherNoiseGen2.func_76304_a(this.noiseData3, posX, posY, posZ, sizeX, sizeY, sizeZ, d0, d1, d0);
        int k1 = 0;
        int l1 = 0;
        double[] adouble1 = new double[sizeY];
        for (i2 = 0; i2 < sizeY; ++i2) {
            adouble1[i2] = Math.cos((double)i2 * Math.PI * 6.0 / (double)sizeY) * 2.0;
            double d2 = i2;
            if (i2 > sizeY / 2) {
                d2 = sizeY - 1 - i2;
            }
            if (!(d2 < 4.0)) continue;
            d2 = 4.0 - d2;
            int n = i2;
            adouble1[n] = adouble1[n] - d2 * d2 * d2 * 10.0;
        }
        for (i2 = 0; i2 < sizeX; ++i2) {
            for (int j2 = 0; j2 < sizeZ; ++j2) {
                double d3 = (this.noiseData4[l1] + 256.0) / 512.0;
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                double d4 = 0.0;
                double d5 = this.noiseData5[l1] / 8000.0;
                if (d5 < 0.0) {
                    d5 = -d5;
                }
                if ((d5 = d5 * 3.0 - 3.0) < 0.0) {
                    if ((d5 /= 2.0) < -1.0) {
                        d5 = -1.0;
                    }
                    d5 /= 1.4;
                    d5 /= 2.0;
                    d3 = 0.0;
                } else {
                    if (d5 > 1.0) {
                        d5 = 1.0;
                    }
                    d5 /= 6.0;
                }
                d3 += 0.5;
                d5 = d5 * (double)sizeY / 16.0;
                ++l1;
                for (int k2 = 0; k2 < sizeY; ++k2) {
                    double d11;
                    double d6 = 0.0;
                    double d7 = adouble1[k2];
                    double d8 = this.noiseData2[k1] / 512.0;
                    double d9 = this.noiseData3[k1] / 512.0;
                    double d10 = (this.noiseData1[k1] / 10.0 + 1.0) / 2.0;
                    d6 = d10 < 0.0 ? d8 : (d10 > 1.0 ? d9 : d8 + (d9 - d8) * d10);
                    d6 -= d7;
                    if (k2 > sizeY - 4) {
                        d11 = (float)(k2 - (sizeY - 4)) / 3.0f;
                        d6 = d6 * (1.0 - d11) + -10.0 * d11;
                    }
                    if ((double)k2 < d4) {
                        d11 = (d4 - (double)k2) / 4.0;
                        if (d11 < 0.0) {
                            d11 = 0.0;
                        }
                        if (d11 > 1.0) {
                            d11 = 1.0;
                        }
                        d6 = d6 * (1.0 - d11) + -10.0 * d11;
                    }
                    noiseField[k1] = d6;
                    ++k1;
                }
            }
        }
        return noiseField;
    }

    public boolean func_73149_a(int par1, int par2) {
        return true;
    }

    public void func_73153_a(IChunkProvider par1IChunkProvider, int par2, int par3) {
        int j2;
        int i2;
        int l1;
        int k1;
        int j1;
        int i1;
        BlockSand.field_72192_a = true;
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre(par1IChunkProvider, this.worldObj, this.random, par2, par3, false));
        int k = par2 * 16;
        int l = par3 * 16;
        this.genNetherBridge.func_75051_a(this.worldObj, this.random, par2, par3);
        boolean doGen = TerrainGen.populate((IChunkProvider)par1IChunkProvider, (World)this.worldObj, (Random)this.random, (int)par2, (int)par3, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.NETHER_LAVA);
        for (i1 = 0; doGen && i1 < 8; ++i1) {
            j1 = k + this.random.nextInt(16) + 8;
            k1 = this.random.nextInt(120) + 4;
            l1 = l + this.random.nextInt(16) + 8;
            new WorldGenHellLava(Block.field_71942_A.field_71990_ca, false).func_76484_a(this.worldObj, this.random, j1, k1, l1);
        }
        i1 = this.random.nextInt(this.random.nextInt(10) + 1) + 1;
        doGen = TerrainGen.populate((IChunkProvider)par1IChunkProvider, (World)this.worldObj, (Random)this.random, (int)par2, (int)par3, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.FIRE);
        for (j1 = 0; doGen && j1 < i1; ++j1) {
            k1 = k + this.random.nextInt(16) + 8;
            l1 = this.random.nextInt(120) + 4;
            i2 = l + this.random.nextInt(16) + 8;
            new WorldGenFire().func_76484_a(this.worldObj, this.random, k1, l1, i2);
        }
        i1 = this.random.nextInt(this.random.nextInt(10) + 1);
        doGen = TerrainGen.populate((IChunkProvider)par1IChunkProvider, (World)this.worldObj, (Random)this.random, (int)par2, (int)par3, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.GLOWSTONE);
        for (j1 = 0; doGen && j1 < i1; ++j1) {
            k1 = k + this.random.nextInt(16) + 8;
            l1 = this.random.nextInt(120) + 4;
            i2 = l + this.random.nextInt(16) + 8;
            new WorldGenGlowStone1().func_76484_a(this.worldObj, this.random, k1, l1, i2);
        }
        for (j1 = 0; doGen && j1 < 10; ++j1) {
            k1 = k + this.random.nextInt(16) + 8;
            l1 = this.random.nextInt(128);
            i2 = l + this.random.nextInt(16) + 8;
            new WorldGenGlowStone2().func_76484_a(this.worldObj, this.random, k1, l1, i2);
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(this.worldObj, this.random, k, l));
        doGen = TerrainGen.decorate((World)this.worldObj, (Random)this.random, (int)k, (int)l, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SHROOM);
        if (doGen && this.random.nextInt(1) == 0) {
            j1 = k + this.random.nextInt(16) + 8;
            k1 = this.random.nextInt(128);
            l1 = l + this.random.nextInt(16) + 8;
            new WorldGenFlowers(Block.field_72109_af.field_71990_ca).func_76484_a(this.worldObj, this.random, j1, k1, l1);
        }
        if (doGen && this.random.nextInt(1) == 0) {
            j1 = k + this.random.nextInt(16) + 8;
            k1 = this.random.nextInt(128);
            l1 = l + this.random.nextInt(16) + 8;
            new WorldGenFlowers(Block.field_72103_ag.field_71990_ca).func_76484_a(this.worldObj, this.random, j1, k1, l1);
        }
        WorldGenMinable worldgenminable = new WorldGenMinable(Block.field_94342_cr.field_71990_ca, 13, Block.field_72012_bb.field_71990_ca);
        for (k1 = 0; k1 < 16; ++k1) {
            l1 = k + this.random.nextInt(16);
            i2 = this.random.nextInt(108) + 10;
            j2 = l + this.random.nextInt(16);
            worldgenminable.func_76484_a(this.worldObj, this.random, l1, i2, j2);
        }
        for (k1 = 0; k1 < 16; ++k1) {
            l1 = k + this.random.nextInt(16);
            i2 = this.random.nextInt(108) + 10;
            j2 = l + this.random.nextInt(16);
            new WorldGenHellLava(Block.field_71942_A.field_71990_ca, true).func_76484_a(this.worldObj, this.random, l1, i2, j2);
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(this.worldObj, this.random, k, l));
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post(par1IChunkProvider, this.worldObj, this.random, par2, par3, false));
        BlockSand.field_72192_a = false;
    }

    public boolean func_73151_a(boolean par1, IProgressUpdate par2IProgressUpdate) {
        return true;
    }

    public boolean func_73156_b() {
        return false;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "HellRandomLevelSource";
    }

    public List func_73155_a(EnumCreatureType par1EnumCreatureType, int par2, int par3, int par4) {
        if (par1EnumCreatureType == EnumCreatureType.monster && this.genNetherBridge.func_75048_a(par2, par3, par4)) {
            return this.genNetherBridge.func_75059_a();
        }
        BiomeGenBase biomegenbase = this.worldObj.func_72807_a(par2, par4);
        return biomegenbase == null ? null : biomegenbase.func_76747_a(par1EnumCreatureType);
    }

    public ChunkPosition func_73150_a(World par1World, String par2Str, int par3, int par4, int par5) {
        return null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_82695_e(int par1, int par2) {
        this.genNetherBridge.func_75036_a((IChunkProvider)this, this.worldObj, par1, par2, (byte[])null);
    }
}

