/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.worldgen;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import mods.natura.common.NaturaContent;
import mods.natura.common.PHNatura;
import mods.natura.worldgen.BloodTreeGen;
import mods.natura.worldgen.BushTreeGen;
import mods.natura.worldgen.EucalyptusTreeGenShort;
import mods.natura.worldgen.FlowerGen;
import mods.natura.worldgen.RedwoodTreeGen;
import mods.natura.worldgen.SaguaroGen;
import mods.natura.worldgen.SakuraTreeGen;
import mods.natura.worldgen.WhiteTreeGen;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class BaseTreeWorldgen
implements IWorldGenerator {
    RedwoodTreeGen genRedwood;
    BloodTreeGen genBlood;
    BushTreeGen bush;
    SakuraTreeGen pinkSakura;
    WhiteTreeGen whiteSakura;
    EucalyptusTreeGenShort eucalyptusShort;
    SaguaroGen saguaro;
    FlowerGen bluebells;
    FlowerGen lily;
    FlowerGen tulip;
    FlowerGen pansy;

    public BaseTreeWorldgen() {
        this.genRedwood = new RedwoodTreeGen(false, NaturaContent.redwood.field_71990_ca, 0);
        this.genBlood = new BloodTreeGen(3, 2);
        this.bush = new BushTreeGen(false, 2, 3, 2);
        this.pinkSakura = new SakuraTreeGen(false, 1, 0);
        this.whiteSakura = new WhiteTreeGen(false, 2, 1);
        this.eucalyptusShort = new EucalyptusTreeGenShort(0, 1);
        this.saguaro = new SaguaroGen(NaturaContent.saguaro.field_71990_ca, 0, false);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int zSpawn;
        int ySpawn;
        int xSpawn;
        int iter;
        int xPos = chunkX * 16;
        int zPos = chunkZ * 16;
        String biomeName = world.func_72959_q().func_76935_a((int)xPos, (int)zPos).field_76791_y;
        if (biomeName == "Forest" || biomeName == "AutumnWoods" || biomeName == "BirchForest" || biomeName == "PineForest" || biomeName == "Rainforest" || biomeName == "TemperateRainforest" || biomeName == "Woodlands") {
            if (PHNatura.generateSakura && random.nextInt(PHNatura.sakuraSpawnRarity * 5) == 0) {
                for (iter = 0; iter < 3; ++iter) {
                    xSpawn = xPos + random.nextInt(16);
                    ySpawn = random.nextInt(PHNatura.sakuraSpawnRange) + PHNatura.seaLevel;
                    zSpawn = zPos + random.nextInt(16);
                    this.pinkSakura.func_76484_a(world, random, xSpawn, ySpawn, zSpawn);
                }
            }
            if (PHNatura.generateSmallEucalyptus && random.nextInt(PHNatura.eucalyptusShortSpawnRarity) == 0) {
                xSpawn = xPos + random.nextInt(16);
                ySpawn = random.nextInt(PHNatura.eucalyptusShortSpawnRange) + PHNatura.seaLevel;
                zSpawn = zPos + random.nextInt(16);
                this.eucalyptusShort.func_76484_a(world, random, xSpawn, ySpawn, zSpawn);
            }
        }
        if (biomeName == "Plains" || biomeName == "Meadow") {
            if (PHNatura.generateRedwood && random.nextInt(PHNatura.redwoodSpawnRarity) == 0) {
                xSpawn = xPos + random.nextInt(16);
                zSpawn = zPos + random.nextInt(16);
                this.genRedwood.func_76484_a(world, random, xSpawn, PHNatura.seaLevel + 16, zSpawn);
            }
            if (PHNatura.generateSmallEucalyptus && random.nextInt((int)((double)PHNatura.eucalyptusShortSpawnRarity * 1.5)) == 0) {
                xSpawn = xPos + random.nextInt(16);
                ySpawn = random.nextInt(32) + PHNatura.seaLevel;
                zSpawn = zPos + random.nextInt(16);
                this.eucalyptusShort.func_76484_a(world, random, xSpawn, ySpawn, zSpawn);
            }
        }
        if (biomeName == "Extreme Hills" || biomeName == "Extreme Hills Edge" || biomeName == "ForestedHills" || biomeName == "GreenHills") {
            if (PHNatura.generateBush && random.nextInt(PHNatura.bushSpawnRarity) == 0) {
                xSpawn = xPos + random.nextInt(16) + 8;
                ySpawn = random.nextInt(PHNatura.bushSpawnRange) + PHNatura.seaLevel;
                zSpawn = zPos + random.nextInt(16) + 8;
                this.bush.func_76484_a(world, random, xSpawn, ySpawn, zSpawn);
            }
            if (PHNatura.generateSmallEucalyptus && random.nextInt(PHNatura.eucalyptusShortSpawnRarity) < 10) {
                xSpawn = xPos + random.nextInt(16) + 8;
                ySpawn = random.nextInt(PHNatura.eucalyptusShortSpawnRange) + PHNatura.seaLevel;
                zSpawn = zPos + random.nextInt(16) + 8;
                this.eucalyptusShort.func_76484_a(world, random, xSpawn, ySpawn, zSpawn);
            }
        }
        if (biomeName == "River" && PHNatura.generateSakura && random.nextInt(PHNatura.sakuraSpawnRarity) == 0) {
            for (iter = 0; iter < 3; ++iter) {
                xSpawn = xPos + random.nextInt(16);
                ySpawn = random.nextInt(PHNatura.sakuraSpawnRange) + PHNatura.seaLevel;
                zSpawn = zPos + random.nextInt(16);
                this.pinkSakura.func_76484_a(world, random, xSpawn, ySpawn, zSpawn);
            }
        }
        if ((biomeName == "Desert" || biomeName == "DesertHills") && PHNatura.generateSaguaro && random.nextInt(PHNatura.saguaroSpawnRarity) == 0) {
            xSpawn = xPos + random.nextInt(16);
            ySpawn = random.nextInt(PHNatura.seaLevel) + 16;
            zSpawn = zPos + random.nextInt(16);
            this.saguaro.func_76484_a(world, random, xSpawn, ySpawn, zSpawn);
        }
        if (biomeName.equals("Hell")) {
            if (PHNatura.generateBloodwood && random.nextInt(PHNatura.bloodSpawnRarity) == 0) {
                xSpawn = xPos + random.nextInt(16);
                ySpawn = random.nextInt(PHNatura.bloodSpawnRange) + PHNatura.bloodSpawnHeight;
                zSpawn = zPos + random.nextInt(16);
                this.genBlood.func_76484_a(world, random, xSpawn, ySpawn, zSpawn);
            }
            if (PHNatura.generateGhost && random.nextInt(PHNatura.ghostSpawnRarity) == 0) {
                for (iter = 0; iter < 3; ++iter) {
                    ySpawn = random.nextInt(PHNatura.ghostSpawnRange) + PHNatura.ghostSpawnHeight;
                    xSpawn = xPos + random.nextInt(16);
                    zSpawn = zPos + random.nextInt(16);
                    this.whiteSakura.func_76484_a(world, random, xSpawn, ySpawn, zSpawn);
                }
            }
        }
    }
}

