/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.worldgen;

import java.util.Random;
import mods.natura.common.NaturaContent;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class BloodTreeGen
extends WorldGenerator {
    private int mdWood;
    private int mdLeaves;

    public BloodTreeGen(int wood, int leaves) {
        this.mdWood = wood;
        this.mdLeaves = leaves;
    }

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        int height = this.findGround(world, x, y, z);
        return this.generateRandomTree(world, random, x, height, z);
    }

    int findGround(World world, int x, int y, int z) {
        int l = 0;
        int bID = world.func_72798_a(x, y - 1, z);
        if (!(Block.field_71970_n[world.func_72798_a(x, y, z)] || bID != Block.field_72012_bb.field_71990_ca && bID != Block.field_72013_bc.field_71990_ca)) {
            return y;
        }
        int k1 = 96;
        while (k1 >= 32) {
            int j1 = world.func_72798_a(x, k1, z);
            if (!(j1 != Block.field_72012_bb.field_71990_ca && j1 != Block.field_72013_bc.field_71990_ca || Block.field_71970_n[world.func_72798_a(x, k1 + 1, z)])) {
                l = k1 + 1;
                break;
            }
            if (--k1 > 0) continue;
        }
        return l;
    }

    public boolean generateRandomTree(World world, Random random, int x, int y, int z) {
        int treeHeight = random.nextInt(5) + 8;
        boolean flag = true;
        if (y < 1 || y + treeHeight + 1 > 256) {
            return false;
        }
        for (int i1 = y; i1 <= y + 1 + treeHeight; ++i1) {
            int byte0 = 1;
            if (i1 == y) {
                byte0 = 0;
            }
            if (i1 >= y + 1 + treeHeight - 2) {
                byte0 = 2;
            }
            block1: for (int l1 = x - byte0; l1 <= x + byte0 && flag; ++l1) {
                for (int j2 = z - byte0; j2 <= z + byte0 && flag; ++j2) {
                    if (i1 >= 0 && i1 < 256) {
                        int k2 = world.func_72798_a(l1, i1, j2);
                        if (k2 == 0 || k2 == NaturaContent.floraLeavesNoColor.field_71990_ca) continue;
                        flag = false;
                        continue block1;
                    }
                    flag = false;
                    continue block1;
                }
            }
        }
        if (!flag) {
            return false;
        }
        int j1 = world.func_72798_a(x, y - 1, z);
        if (j1 != Block.field_72012_bb.field_71990_ca && j1 != Block.field_72013_bc.field_71990_ca || y >= 256 - treeHeight - 1) {
            return false;
        }
        world.func_94575_c(x, y - 1, z, Block.field_72013_bc.field_71990_ca);
        world.func_94575_c(x + 1, y - 1, z, Block.field_72013_bc.field_71990_ca);
        world.func_94575_c(x, y - 1, z + 1, Block.field_72013_bc.field_71990_ca);
        world.func_94575_c(x + 1, y - 1, z + 1, Block.field_72013_bc.field_71990_ca);
        for (int k1 = 0; k1 < treeHeight; ++k1) {
            int i2 = world.func_72798_a(x, y + k1, z);
            if (i2 != 0 && i2 != NaturaContent.floraLeaves.field_71990_ca) continue;
            this.func_76485_a(world, x, y + k1, z, NaturaContent.bloodwood.field_71990_ca, 0);
            this.func_76485_a(world, x + 1, y + k1, z, NaturaContent.bloodwood.field_71990_ca, 1);
            this.func_76485_a(world, x, y + k1, z + 1, NaturaContent.bloodwood.field_71990_ca, 2);
            this.func_76485_a(world, x + 1, y + k1, z + 1, NaturaContent.bloodwood.field_71990_ca, 3);
        }
        this.genBranch(world, random, x, y, z, treeHeight, 1);
        this.genBranch(world, random, x + 1, y, z, treeHeight, 2);
        this.genBranch(world, random, x, y, z + 1, treeHeight, 3);
        this.genBranch(world, random, x + 1, y, z + 1, treeHeight, 4);
        this.genStraightBranch(world, random, x, y, z, treeHeight, 1);
        this.genStraightBranch(world, random, x + 1, y, z, treeHeight, 2);
        this.genStraightBranch(world, random, x, y, z + 1, treeHeight, 3);
        this.genStraightBranch(world, random, x + 1, y, z + 1, treeHeight, 4);
        return true;
    }

    private void genBranch(World world, Random random, int i, int j, int k, int l, int i1) {
        int j1 = i;
        int k1 = j + l;
        int l1 = k;
        int byte0 = 0;
        int byte1 = 0;
        switch (i1) {
            case 1: {
                byte0 = 1;
                byte1 = 1;
                break;
            }
            case 2: {
                byte0 = -1;
                byte1 = 1;
                break;
            }
            case 3: {
                byte0 = 1;
                byte1 = -1;
                break;
            }
            case 4: {
                byte0 = -1;
                byte1 = -1;
            }
        }
        int i2 = random.nextInt(15);
        for (int j2 = 4; j2 > 0; --j2) {
            if (i2 % 3 != 0) {
                j1 += byte0;
            }
            if (i2 % 3 != 1) {
                l1 += byte1;
            }
            this.generateNode(world, random, j1, k1 += i2 % 3 - 1, l1);
            i2 = random.nextInt(15);
        }
    }

    private void genStraightBranch(World world, Random random, int i, int j, int k, int l, int i1) {
        int j1 = i;
        int k1 = j + l;
        int l1 = k;
        int byte0 = 0;
        int byte1 = 0;
        switch (i1) {
            case 1: {
                byte0 = 1;
                byte1 = 0;
                break;
            }
            case 2: {
                byte0 = 0;
                byte1 = 1;
                break;
            }
            case 3: {
                byte0 = -1;
                byte1 = 0;
                break;
            }
            case 4: {
                byte0 = 0;
                byte1 = -1;
            }
        }
        int i2 = random.nextInt(5);
        for (int j2 = 4; j2 > 0; --j2) {
            if (byte0 == 0) {
                j1 = j1 + random.nextInt(3) - 1;
                l1 += byte1;
            }
            if (byte1 == 0) {
                j1 += byte0;
                l1 = l1 + random.nextInt(3) - 1;
            }
            this.generateNode(world, random, j1, k1 += i2 % 3 - 1, l1);
            i2 = random.nextInt(5);
        }
    }

    public boolean generateNode(World world, Random random, int i, int j, int k) {
        this.func_76485_a(world, i, j, k, NaturaContent.bloodwood.field_71990_ca, 15);
        for (int l = i - 1; l <= i + 1; ++l) {
            for (int k1 = k - 1; k1 <= k + 1; ++k1) {
                for (int j2 = j - 1; j2 <= j + 1; ++j2) {
                    int i3 = world.func_72798_a(l, j2, k1);
                    if (i3 == NaturaContent.floraLeaves.field_71990_ca || Block.field_71970_n[i3]) continue;
                    this.func_76485_a(world, l, j2, k1, NaturaContent.floraLeavesNoColor.field_71990_ca, this.mdLeaves);
                }
            }
        }
        for (int i1 = i - 1; i1 <= i + 1; ++i1) {
            for (int l1 = k - 2; l1 <= k + 2; ++l1) {
                int k2 = world.func_72798_a(i1, j, l1);
                if (k2 == NaturaContent.floraLeaves.field_71990_ca || Block.field_71970_n[k2]) continue;
                this.func_76485_a(world, i1, j, l1, NaturaContent.floraLeavesNoColor.field_71990_ca, this.mdLeaves);
            }
        }
        for (int j1 = i - 2; j1 <= i + 2; ++j1) {
            for (int i2 = k - 1; i2 <= k + 1; ++i2) {
                int l2 = world.func_72798_a(j1, j + 1, i2);
                if (l2 == NaturaContent.floraLeaves.field_71990_ca || Block.field_71970_n[l2]) continue;
                this.func_76485_a(world, j1, j, i2, NaturaContent.floraLeavesNoColor.field_71990_ca, this.mdLeaves);
            }
        }
        return true;
    }
}

