/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.dynamiclights.client;

import atomicstryker.dynamiclights.client.DynamicLightSourceContainer;
import atomicstryker.dynamiclights.client.IDynamicLightSource;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.KeyBindingRegistry;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

@Mod(modid="DynamicLights", name="Dynamic Lights", version="1.2.3")
public class DynamicLights {
    private atn mcinstance;
    private static DynamicLights instance;
    private aca lastWorld;
    private ConcurrentLinkedQueue<DynamicLightSourceContainer> lastList;
    private ConcurrentHashMap<abr, ConcurrentLinkedQueue<DynamicLightSourceContainer>> worldLightsMap;
    private boolean globalLightsOff;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        instance = this;
        this.globalLightsOff = false;
        this.mcinstance = FMLClientHandler.instance().getClient();
        this.worldLightsMap = new ConcurrentHashMap();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent evt) {
        TickRegistry.registerTickHandler((ITickHandler)new TickHandler(), (Side)Side.CLIENT);
        atk[] key = new atk[]{new atk("Dynamic Lights toggle", 38)};
        boolean[] repeat = new boolean[]{false};
        KeyBindingRegistry.registerKeyBinding((KeyBindingRegistry.KeyHandler)new LightsOnOffKey(key, repeat));
    }

    public static boolean globalLightsOff() {
        return DynamicLights.instance.globalLightsOff;
    }

    public static int getLightValue(aca world, int blockID, int x, int y, int z) {
        int vanillaValue;
        int n = vanillaValue = aqs.s[blockID] != null ? aqs.s[blockID].getLightValue(world, x, y, z) : 0;
        if (instance == null || DynamicLights.instance.globalLightsOff || world instanceof jp) {
            return vanillaValue;
        }
        if (!world.equals(DynamicLights.instance.lastWorld) || DynamicLights.instance.lastList == null) {
            DynamicLights.instance.lastWorld = world;
            DynamicLights.instance.lastList = DynamicLights.instance.worldLightsMap.get(world);
        }
        if (DynamicLights.instance.lastList != null && !DynamicLights.instance.lastList.isEmpty()) {
            for (DynamicLightSourceContainer light : DynamicLights.instance.lastList) {
                int dynamicValue;
                if (light.getX() != x || light.getY() != y || light.getZ() != z || (dynamicValue = light.getLightSource().getLightLevel()) <= vanillaValue) continue;
                return dynamicValue;
            }
        }
        return vanillaValue;
    }

    public static void addLightSource(IDynamicLightSource lightToAdd) {
        if (lightToAdd.getAttachmentEntity() != null) {
            if (lightToAdd.getAttachmentEntity().R()) {
                DynamicLightSourceContainer newLightContainer = new DynamicLightSourceContainer(lightToAdd);
                ConcurrentLinkedQueue<DynamicLightSourceContainer> lightList = DynamicLights.instance.worldLightsMap.get(lightToAdd.getAttachmentEntity().q);
                if (lightList != null) {
                    if (!lightList.contains(newLightContainer)) {
                        lightList.add(newLightContainer);
                    } else {
                        System.out.println("Cannot add Dynamic Light: Attachment Entity is already registered!");
                    }
                } else {
                    lightList = new ConcurrentLinkedQueue();
                    lightList.add(newLightContainer);
                    DynamicLights.instance.worldLightsMap.put(lightToAdd.getAttachmentEntity().q, lightList);
                }
            } else {
                System.err.println("Cannot add Dynamic Light: Attachment Entity is dead!");
            }
        } else {
            System.err.println("Cannot add Dynamic Light: Attachment Entity is null!");
        }
    }

    public static void removeLightSource(IDynamicLightSource lightToRemove) {
        abr world;
        if (lightToRemove != null && lightToRemove.getAttachmentEntity() != null && (world = lightToRemove.getAttachmentEntity().q) != null) {
            DynamicLightSourceContainer iterContainer = null;
            ConcurrentLinkedQueue<DynamicLightSourceContainer> lightList = DynamicLights.instance.worldLightsMap.get(world);
            if (lightList != null) {
                Iterator<DynamicLightSourceContainer> iter = lightList.iterator();
                while (iter.hasNext()) {
                    iterContainer = iter.next();
                    if (!iterContainer.getLightSource().equals(lightToRemove)) continue;
                    iter.remove();
                    break;
                }
                if (iterContainer != null) {
                    world.c(acc.b, iterContainer.getX(), iterContainer.getY(), iterContainer.getZ());
                }
            }
        }
    }

    private class LightsOnOffKey
    extends KeyBindingRegistry.KeyHandler {
        private EnumSet<TickType> tickTypes;

        public LightsOnOffKey(atk[] keyBindings, boolean[] repeatings) {
            super(keyBindings, repeatings);
            this.tickTypes = EnumSet.of(TickType.CLIENT);
        }

        public String getLabel() {
            return "DynamicLightsKey";
        }

        public void keyDown(EnumSet<TickType> types, atk kb, boolean tickEnd, boolean isRepeat) {
        }

        public void keyUp(EnumSet<TickType> types, atk kb, boolean tickEnd) {
            if (tickEnd && ((DynamicLights)DynamicLights.this).mcinstance.m == null) {
                ConcurrentLinkedQueue worldLights;
                DynamicLights.this.globalLightsOff = !DynamicLights.this.globalLightsOff;
                ((DynamicLights)DynamicLights.this).mcinstance.q.b().a("Dynamic Lights globally " + (DynamicLights.this.globalLightsOff ? "off" : "on"));
                bcu world = ((DynamicLights)DynamicLights.this).mcinstance.e;
                if (world != null && (worldLights = (ConcurrentLinkedQueue)DynamicLights.this.worldLightsMap.get(world)) != null) {
                    for (DynamicLightSourceContainer c : worldLights) {
                        world.c(acc.b, c.getX(), c.getY(), c.getZ());
                    }
                }
            }
        }

        public EnumSet<TickType> ticks() {
            return this.tickTypes;
        }
    }

    private class TickHandler
    implements ITickHandler {
        private final EnumSet<TickType> ticks = EnumSet.of(TickType.CLIENT);

        public void tickStart(EnumSet<TickType> type, Object ... tickData) {
        }

        public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
            ConcurrentLinkedQueue worldLights;
            if (((DynamicLights)DynamicLights.this).mcinstance.e != null && (worldLights = (ConcurrentLinkedQueue)DynamicLights.this.worldLightsMap.get(((DynamicLights)DynamicLights.this).mcinstance.e)) != null) {
                Iterator iter = worldLights.iterator();
                while (iter.hasNext()) {
                    DynamicLightSourceContainer tickedLightContainer = (DynamicLightSourceContainer)iter.next();
                    if (tickedLightContainer == null || !tickedLightContainer.onUpdate()) continue;
                    iter.remove();
                    ((DynamicLights)DynamicLights.this).mcinstance.e.c(acc.b, tickedLightContainer.getX(), tickedLightContainer.getY(), tickedLightContainer.getZ());
                }
            }
        }

        public EnumSet<TickType> ticks() {
            return this.ticks;
        }

        public String getLabel() {
            return "DynamicLights";
        }
    }
}

