/*
 * Decompiled with CFR 0.152.
 */
package mods.awger.smallboat;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import mods.awger.logger;
import mods.awger.smallboat.EntityBoatPart;
import mods.awger.smallboat.SmallBoat;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntitySmallBoat
extends Entity
implements IEntityAdditionalSpawnData {
    public Level LogLevel = Level.INFO;
    protected UUID ParentPersistentID;
    public static final byte ptSyncChildren = 1;
    public static final byte ptSetFlags = 2;
    public static final byte ptSetPosition = 3;
    public static final byte ptMount = 4;
    public static final byte ptDismount = 5;
    public static final byte ptOpenChest = 6;
    public static final byte bfPort = 1;
    public static final byte bfStarboard = 2;
    public static final byte bfFore = 4;
    public static final byte bfAft = 8;
    public static final byte bfTop = 16;
    public static final byte bfBottom = 32;
    public static final byte fNone = 0;
    public static final byte fPassenger = 1;
    private int trackRider = 1;
    protected boolean isUpdating = false;
    protected boolean isStationary = true;
    protected boolean Dev = false;
    private boolean Anchored;
    private boolean Docked;
    private boolean field_70279_a;
    private double field_70276_b;
    protected int Color;
    protected int Flags;
    protected double RiderXofs = 1.95;
    protected double RiderYofs = 1.95;
    protected double RiderZofs = 0.35;
    protected double Speed;
    protected double MaxSpeed;
    protected float TackAngle;
    protected float MaxTackAngle;
    protected float TackTarget;
    protected float TackSpeed;
    protected float Heel;
    protected float MaxHeel;
    protected double DefMaxYawDif;
    protected double MaxYawDif = this.DefMaxYawDif = 3.5;
    protected double Beam = 1.0;
    protected double LWL = 1.0;
    protected double Displacement = 1.0;
    protected int ItemID = 0;
    protected String Channel = "SmallBoat";
    public EntityBoatPart[] BoatParts;
    protected List Passengers;
    int savedId;
    int PartsCount;
    int SkipCount;
    boolean printInfo;
    boolean firstUpdate;

    public EntitySmallBoat(World par1World) {
        super(par1World);
        this.LogLevel = SmallBoat.LogLevel;
        this.generateParentPersistentID();
        logger.fine(SmallBoat.LogLevel, "%s: instantiating generic EntitySmallBoat(%d)", par1World.field_72995_K ? "client" : "server", this.field_70157_k);
        this.savedId = this.field_70157_k;
        this.field_70279_a = false;
        this.field_70276_b = 0.07;
        this.field_70156_m = true;
        this.func_70105_a(2.0f, 1.0f);
        this.field_70129_M = this.field_70131_O * 0.5f;
        this.field_70144_Y = 0.75f;
        this.Flags = 0;
        this.SkipCount = 0;
        this.TackAngle = 0.0f;
        this.MaxTackAngle = 45.0f;
        this.TackTarget = 0.0f;
        this.TackSpeed = 5.0f;
        this.Heel = 0.0f;
        this.MaxHeel = 10.0f;
        this.MaxSpeed = 15.0;
        this.Color = 0;
        this.Passengers = new ArrayList();
        this.field_70145_X = true;
        this.field_70158_ak = true;
        this.printInfo = true;
        this.firstUpdate = true;
    }

    public EntitySmallBoat(World par1World, double par2, double par4, double par6) {
        this(par1World);
        logger.fine(SmallBoat.LogLevel, "%s: instantiating EntitySmallBoat(%d) with children", par1World.field_72995_K ? "client" : "server", this.field_70157_k);
        this.createChildren();
        this.func_70107_b(par2, par4 + (double)this.field_70129_M, par6);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.savePositionAndRotation();
    }

    public void writeSpawnData(ByteArrayDataOutput data) {
        if (this.ParentPersistentID != null) {
            data.writeLong(this.ParentPersistentID.getMostSignificantBits());
            data.writeLong(this.ParentPersistentID.getLeastSignificantBits());
        } else {
            logger.fine(SmallBoat.LogLevel, "%s: !! writing zero ParentUUID for %d", this.field_70170_p.field_72995_K ? "client" : "server", this.field_70157_k);
            data.writeLong(0L);
            data.writeLong(0L);
        }
        data.writeInt(this.BoatParts.length);
        data.writeInt(this.Color);
        data.writeBoolean(this.Anchored);
        data.writeBoolean(this.Docked);
    }

    public void readSpawnData(ByteArrayDataInput data) {
        this.setParentPersistentID(new UUID(data.readLong(), data.readLong()));
        int count = data.readInt();
        this.BoatParts = new EntityBoatPart[count];
        this.PartsCount = 0;
        this.Color = data.readInt();
        this.Anchored = data.readBoolean();
        this.Docked = data.readBoolean();
        this.isStationary = true;
    }

    public UUID getParentPersistentID() {
        return this.ParentPersistentID;
    }

    public void generateParentPersistentID() {
        this.ParentPersistentID = UUID.randomUUID();
        logger.fine(SmallBoat.LogLevel, "%s.generateParentPersistentID for %d, = %s", this.field_70170_p.field_72995_K ? "client" : "server", this.field_70157_k, this.ParentPersistentID.toString());
    }

    public void setParentPersistentID(UUID _uuid) {
        this.ParentPersistentID = _uuid;
        logger.fine(SmallBoat.LogLevel, "%s.setParentPersistentID for %d, = %s", this.field_70170_p.field_72995_K ? "client" : "server", this.field_70157_k, this.ParentPersistentID.toString());
    }

    private void createChildren() {
        logger.fine(SmallBoat.LogLevel, "%s: createChildren() for %d", this.field_70170_p.field_72995_K ? "client" : "server", this.field_70157_k);
    }

    public void addPart(EntityBoatPart _part) {
        logger.fine(SmallBoat.LogLevel, "%s.addPart(%d)", this.field_70170_p.field_72995_K ? "client" : "server", _part.field_70157_k);
        if (this.PartsCount < this.BoatParts.length) {
            this.BoatParts[this.PartsCount] = _part;
            ++this.PartsCount;
        } else {
            logger.fine(SmallBoat.LogLevel, "\t** too many parts", new Object[0]);
        }
        if (this.PartsCount == this.BoatParts.length && !this.Dev) {
            this.isStationary = false;
            this.setDocked(true);
        }
    }

    public void addToWorld(World world) {
        world.func_72838_d((Entity)this);
        this.addChildrenToWorld(world);
    }

    public void addChildrenToWorld(World world) {
        logger.fine(SmallBoat.LogLevel, "%s.addChildrenToWorld()", this.field_70170_p.field_72995_K ? "client" : "server");
        if (this.BoatParts == null) {
            logger.fine(SmallBoat.LogLevel, "\t** BoatParts not initialized", new Object[0]);
            return;
        }
        this.syncChildren();
        for (int i = 0; i < this.BoatParts.length; ++i) {
            if (world.func_72838_d((Entity)this.BoatParts[i])) {
                logger.fine(SmallBoat.LogLevel, "\t** child %d added to world", this.BoatParts[i].field_70157_k);
                continue;
            }
            logger.fine(SmallBoat.LogLevel, "\t!! error adding child %d to world", this.BoatParts[i].field_70157_k);
        }
    }

    public boolean renderParent() {
        return true;
    }

    public boolean renderChildren() {
        return true;
    }

    public void updateChildIds() {
        this.Flags |= 1;
        this.updateServerFlags(this.Flags);
    }

    private void sendMountUpdate(Entity _child, Entity _player, byte _flags) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        logger.fine(SmallBoat.LogLevel, "%s.sendMountUpdate()", this.field_70170_p.field_72995_K ? "client" : "server");
        ByteArrayOutputStream bos = new ByteArrayOutputStream(17);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeInt(this.getItemID());
            outputStream.writeInt(this.field_70157_k);
            outputStream.writeByte(4);
            if (_child != null) {
                outputStream.writeInt(_child.field_70157_k);
            } else {
                outputStream.writeInt(0);
            }
            outputStream.writeInt(_player.field_70157_k);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Packet250CustomPayload packet = new Packet250CustomPayload();
        packet.field_73630_a = "client_" + this.getChannel();
        packet.field_73629_c = bos.toByteArray();
        packet.field_73628_b = bos.size();
        PacketDispatcher.sendPacketToAllPlayers((Packet)packet);
    }

    private void sendDismountUpdate(Entity _player) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        logger.fine(SmallBoat.LogLevel, "%s.sendDismountUpdate()", this.field_70170_p.field_72995_K ? "client" : "server");
        ByteArrayOutputStream bos = new ByteArrayOutputStream(13);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeInt(this.getItemID());
            outputStream.writeInt(this.field_70157_k);
            outputStream.writeByte(5);
            outputStream.writeInt(_player.field_70157_k);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Packet250CustomPayload packet = new Packet250CustomPayload();
        packet.field_73630_a = "client_" + this.getChannel();
        packet.field_73629_c = bos.toByteArray();
        packet.field_73628_b = bos.size();
        PacketDispatcher.sendPacketToAllPlayers((Packet)packet);
    }

    public void sendEntityPosUpdate(Entity _entity) {
        if (this.field_70170_p.field_72995_K || _entity == null) {
            return;
        }
        logger.info(SmallBoat.LogLevel, "%s.sendRiderUpdate()", this.field_70170_p.field_72995_K ? "client" : "server");
        ByteArrayOutputStream bos = new ByteArrayOutputStream(41);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeInt(this.getItemID());
            outputStream.writeInt(_entity.field_70157_k);
            outputStream.writeByte(3);
            outputStream.writeDouble(_entity.field_70165_t);
            outputStream.writeDouble(_entity.field_70163_u);
            outputStream.writeDouble(_entity.field_70161_v);
            outputStream.writeFloat(_entity.field_70177_z);
            outputStream.writeFloat(_entity.field_70125_A);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Packet250CustomPayload packet = new Packet250CustomPayload();
        packet.field_73630_a = "client_" + this.getChannel();
        packet.field_73629_c = bos.toByteArray();
        packet.field_73628_b = bos.size();
        PacketDispatcher.sendPacketToAllPlayers((Packet)packet);
    }

    private void updateServerFlags(int _flags) {
        if (!this.field_70170_p.field_72995_K) {
            return;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(13);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeInt(this.getItemID());
            outputStream.writeInt(this.field_70157_k);
            outputStream.writeByte(2);
            outputStream.writeInt(_flags);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Packet250CustomPayload packet = new Packet250CustomPayload();
        packet.field_73630_a = "server_" + this.getChannel();
        packet.field_73629_c = bos.toByteArray();
        packet.field_73628_b = bos.size();
        PacketDispatcher.sendPacketToServer((Packet)packet);
    }

    private void updateServerPosition() {
        if (!this.field_70170_p.field_72995_K) {
            return;
        }
        logger.finest(SmallBoat.LogLevel, "%s.updateServerPosition()", this.field_70170_p.field_72995_K ? "client" : "server");
        ByteArrayOutputStream bos = new ByteArrayOutputStream(41);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeInt(this.getItemID());
            outputStream.writeInt(this.field_70157_k);
            outputStream.writeByte(3);
            outputStream.writeDouble(this.field_70165_t);
            outputStream.writeDouble(this.field_70163_u);
            outputStream.writeDouble(this.field_70161_v);
            outputStream.writeFloat(this.field_70177_z);
            outputStream.writeFloat(this.field_70125_A);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Packet250CustomPayload packet = new Packet250CustomPayload();
        packet.field_73630_a = "server_" + this.getChannel();
        packet.field_73629_c = bos.toByteArray();
        packet.field_73628_b = bos.size();
        PacketDispatcher.sendPacketToServer((Packet)packet);
    }

    public void updateClientPosition() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        logger.finest(SmallBoat.LogLevel, "%s.updateClientPosition()", this.field_70170_p.field_72995_K ? "client" : "server");
        ByteArrayOutputStream bos = new ByteArrayOutputStream(41);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeInt(this.getItemID());
            outputStream.writeInt(this.field_70157_k);
            outputStream.writeByte(3);
            outputStream.writeDouble(this.field_70165_t);
            outputStream.writeDouble(this.field_70163_u);
            outputStream.writeDouble(this.field_70161_v);
            outputStream.writeFloat(this.field_70177_z);
            outputStream.writeFloat(this.field_70125_A);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Packet250CustomPayload packet = new Packet250CustomPayload();
        packet.field_73630_a = "client_" + this.getChannel();
        packet.field_73629_c = bos.toByteArray();
        packet.field_73628_b = bos.size();
        PacketDispatcher.sendPacketToAllPlayers((Packet)packet);
    }

    public void sendMountRequest(Entity _child, Entity _player, byte _flags) {
        if (!this.field_70170_p.field_72995_K) {
            return;
        }
        logger.fine(SmallBoat.LogLevel, "%s.sendMountRequest()", this.field_70170_p.field_72995_K ? "client" : "server");
        ByteArrayOutputStream bos = new ByteArrayOutputStream(18);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeInt(this.getItemID());
            outputStream.writeInt(this.field_70157_k);
            outputStream.writeByte(4);
            outputStream.writeByte(_flags);
            if (_child != null) {
                outputStream.writeInt(_child.field_70157_k);
            } else {
                outputStream.writeInt(0);
            }
            outputStream.writeInt(_player.field_70157_k);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Packet250CustomPayload packet = new Packet250CustomPayload();
        packet.field_73630_a = "server_" + this.getChannel();
        packet.field_73629_c = bos.toByteArray();
        packet.field_73628_b = bos.size();
        logger.fine(SmallBoat.LogLevel, "\tchannel=%s", packet.field_73630_a);
        PacketDispatcher.sendPacketToServer((Packet)packet);
    }

    public void sendDismountRequest(Entity _player) {
        if (!this.field_70170_p.field_72995_K) {
            return;
        }
        logger.fine(SmallBoat.LogLevel, "%s.sendDismountRequest()", this.field_70170_p.field_72995_K ? "client" : "server");
        ByteArrayOutputStream bos = new ByteArrayOutputStream(13);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeInt(this.getItemID());
            outputStream.writeInt(this.field_70157_k);
            outputStream.writeByte(5);
            outputStream.writeInt(_player.field_70157_k);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Packet250CustomPayload packet = new Packet250CustomPayload();
        packet.field_73630_a = "server_" + this.getChannel();
        packet.field_73629_c = bos.toByteArray();
        packet.field_73628_b = bos.size();
        PacketDispatcher.sendPacketToServer((Packet)packet);
    }

    public void sendOpenChest(Entity _child, Entity _player) {
        if (!this.field_70170_p.field_72995_K) {
            return;
        }
        logger.fine(SmallBoat.LogLevel, "%s.sendOpenChest()", this.field_70170_p.field_72995_K ? "client" : "server");
        ByteArrayOutputStream bos = new ByteArrayOutputStream(17);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeInt(this.getItemID());
            outputStream.writeInt(this.field_70157_k);
            outputStream.writeByte(6);
            outputStream.writeInt(_child.field_70157_k);
            outputStream.writeInt(_player.field_70157_k);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Packet250CustomPayload packet = new Packet250CustomPayload();
        packet.field_73630_a = "server_" + this.getChannel();
        packet.field_73629_c = bos.toByteArray();
        packet.field_73628_b = bos.size();
        PacketDispatcher.sendPacketToServer((Packet)packet);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(16, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(17, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(18, (Object)new Integer(1));
        this.field_70180_af.func_75682_a(19, (Object)new Integer(0));
    }

    public AxisAlignedBB func_70114_g(Entity par1Entity) {
        return null;
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    public double func_70042_X() {
        return 0.0;
    }

    public boolean func_70097_a(DamageSource par1DamageSource, int par2) {
        logger.info(SmallBoat.LogLevel, "%s(%d).attackEntityFrom()", this.field_70170_p.field_72995_K ? "client" : "server", this.field_70157_k);
        return false;
    }

    public boolean attackEntityFromPart(DamageSource par1DamageSource, int par2) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            this.setForwardDirection(-this.getForwardDirection());
            this.setTimeSinceHit(10);
            this.setDamageTaken(this.getDamageTaken() + par2 * 10);
            this.func_70018_K();
            if (par1DamageSource.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)par1DamageSource.func_76346_g()).field_71075_bZ.field_75098_d) {
                this.setDamageTaken(100);
            }
            if (this.getDamageTaken() > 40) {
                this.killBoat(true);
            }
            return true;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70057_ab() {
        this.setForwardDirection(-this.getForwardDirection());
        this.setTimeSinceHit(10);
        this.setDamageTaken(this.getDamageTaken() * 11);
    }

    protected void func_70076_C() {
        if (this.field_70153_n != null) {
            this.Dismount(this.field_70153_n.field_70157_k);
        }
        for (int i = 0; i < this.BoatParts.length; ++i) {
            if (this.BoatParts[i] == null) continue;
            this.BoatParts[i].func_70076_C();
        }
        this.func_70106_y();
    }

    public void killBoat(boolean _dropboat) {
        this.func_70076_C();
        if (_dropboat) {
            this.func_70054_a(this.getItemID(), 1, 0.0f);
        }
    }

    public void setBoundingBox() {
        float var7 = this.field_70130_N / 2.0f;
        double top = this.field_70163_u - (double)this.field_70131_O + (double)this.field_70129_M;
        double bottom = this.field_70163_u + (double)this.field_70129_M;
        this.field_70121_D.func_72324_b(this.field_70165_t - (double)var7, top, this.field_70161_v - (double)var7, this.field_70165_t + (double)var7, bottom, this.field_70161_v + (double)var7);
    }

    public void func_70107_b(double _x, double _y, double _z) {
        this.updatePosition(_x, _y, _z);
        this.setBoundingBox();
    }

    public void updatePosition(double _x, double _y, double _z) {
        this.field_70165_t = _x;
        this.field_70163_u = _y;
        this.field_70161_v = _z;
    }

    public void savePositionAndRotation() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    public void func_70080_a(double _x, double _y, double _z, float _yaw, float _pitch) {
        logger.finest(SmallBoat.LogLevel, "%s: setPositionAndRotation(%f, %f, %f, %f, %f)", this.field_70170_p.field_72995_K ? "client" : "server", _x, _y, _z, Float.valueOf(_yaw), Float.valueOf(_pitch));
        this.updatePosition(_x, _y, _z);
        this.func_70101_b(_yaw, _pitch);
    }

    public void func_70056_a(double _x, double _y, double _z, float _yaw, float _pitch, int par9) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (this.field_70153_n == mc.field_71439_g) {
            return;
        }
        logger.finest(SmallBoat.LogLevel, "%s: setPositionAndRotation2()", this.field_70170_p.field_72995_K ? "client" : "server");
        this.func_70107_b(_x, _y, _z);
        this.func_70101_b(_yaw, _pitch);
        this.isUpdating = true;
    }

    public void setPositionAndRotation3(double _x, double _y, double _z, float _yaw, float _pitch, int par9) {
        logger.finest(SmallBoat.LogLevel, "%s: setPositionAndRotation3()", this.field_70170_p.field_72995_K ? "client" : "server");
        this.func_70107_b(_x, _y, _z);
        this.func_70101_b(_yaw, _pitch);
    }

    private void syncChildren() {
        if (this.BoatParts == null) {
            return;
        }
        double cos1 = Math.cos((double)this.field_70177_z * Math.PI / 180.0);
        double sin1 = Math.sin((double)this.field_70177_z * Math.PI / 180.0);
        double cos2 = Math.cos((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0);
        double sin2 = Math.sin((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0);
        for (int i = 0; i < this.BoatParts.length; ++i) {
            if (this.BoatParts[i] == null) continue;
            double var1 = cos1 * (double)this.BoatParts[i].posOfsX + cos2 * (double)this.BoatParts[i].posOfsZ;
            double var2 = this.BoatParts[i].posOfsY;
            double var3 = sin1 * (double)this.BoatParts[i].posOfsX + sin2 * (double)this.BoatParts[i].posOfsZ;
            this.BoatParts[i].func_70012_b(this.field_70165_t + var1, this.field_70163_u - var2, this.field_70161_v + var3, this.field_70177_z, 0.0f);
        }
    }

    public void func_70071_h_() {
        double var14;
        int z;
        int y;
        int x;
        double disp_delta;
        double var8;
        double var6;
        super.func_70071_h_();
        if (this.printInfo) {
            logger.finest(SmallBoat.LogLevel, "%s.onUpdate(), Flags = %d, DamageTaken = %d", this.field_70170_p.field_72995_K ? "client" : "server", this.getFlags(), this.getDamageTaken());
            logger.finest(SmallBoat.LogLevel, "\tuuid = %s", this.getParentPersistentID().toString());
            logger.finest(SmallBoat.LogLevel, "\tentityId = %d", this.field_70157_k);
            this.printInfo = false;
        }
        if (!this.field_70170_p.field_72995_K) {
            --this.SkipCount;
            if (this.SkipCount <= 0) {
                if (this.BoatParts == null || this.PartsCount != this.BoatParts.length) {
                    this.func_70106_y();
                }
                this.SkipCount = 48;
            }
        } else if (this.BoatParts != null) {
            --this.SkipCount;
            if (this.SkipCount <= 0) {
                Minecraft mc = FMLClientHandler.instance().getClient();
                if (this.field_70153_n == mc.field_71439_g) {
                    this.updateServerPosition();
                }
                this.SkipCount = 48;
            }
        }
        if (this.BoatParts == null) {
            logger.warning(SmallBoat.LogLevel, "\t!! parent has no parts", new Object[0]);
            return;
        }
        if (this.PartsCount != this.BoatParts.length) {
            logger.warning(SmallBoat.LogLevel, "\t!! parent is missing parts", new Object[0]);
            return;
        }
        if (this.savedId != this.field_70157_k) {
            this.savedId = this.field_70157_k;
            this.updateChildIds();
        }
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0) {
            this.setDamageTaken(this.getDamageTaken() - 1);
        }
        if (this.isStationary) {
            return;
        }
        if (this.firstUpdate) {
            this.calcDisplacement();
            this.setBoundingBox();
            this.firstUpdate = false;
        }
        this.savePositionAndRotation();
        int var1 = 5;
        double var2 = 0.0;
        for (int var4 = 0; var4 < var1; ++var4) {
            double var5 = this.field_70121_D.field_72338_b + (this.field_70121_D.field_72337_e - this.field_70121_D.field_72338_b) * (double)(var4 + 0) / (double)var1 - 0.125;
            double var7 = this.field_70121_D.field_72338_b + (this.field_70121_D.field_72337_e - this.field_70121_D.field_72338_b) * (double)(var4 + 1) / (double)var1 - 0.125;
            AxisAlignedBB var9 = AxisAlignedBB.func_72332_a().func_72299_a(this.field_70121_D.field_72340_a, var5, this.field_70121_D.field_72339_c, this.field_70121_D.field_72336_d, var7, this.field_70121_D.field_72334_f);
            if (!this.field_70170_p.func_72830_b(var9, Material.field_76244_g)) continue;
            var2 += 1.0 / (double)var1;
        }
        double var24 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
        this.Speed = var24 * 60.0;
        if (var24 > 0.25) {
            var6 = Math.cos((double)this.field_70177_z * Math.PI / 180.0);
            var8 = Math.sin((double)this.field_70177_z * Math.PI / 180.0);
            int var10 = 0;
            while ((double)var10 < 1.0 + this.Speed) {
                double var17;
                double var15;
                double var11 = this.field_70146_Z.nextFloat() * 2.0f - 1.0f;
                double var13 = (double)(this.field_70146_Z.nextInt(2) * 2 - 1) * 0.7;
                if (this.field_70146_Z.nextBoolean()) {
                    var15 = this.field_70165_t - var6 * var11 * 0.8 + var8 * var13;
                    var17 = this.field_70161_v - var8 * var11 * 0.8 - var6 * var13;
                    this.field_70170_p.func_72869_a("splash", var15, this.field_70163_u - 0.125, var17, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                } else {
                    var15 = this.field_70165_t + var6 + var8 * var11 * 0.7;
                    var17 = this.field_70161_v + var8 - var6 * var11 * 0.7;
                    this.field_70170_p.func_72869_a("splash", var15, this.field_70163_u - 0.125, var17, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                }
                ++var10;
            }
        }
        if ((disp_delta = this.Displacement / 10.0) < 2.0) {
            disp_delta = 2.0;
        }
        if (this.field_70170_p.func_72799_c(x = MathHelper.func_76128_c((double)this.field_70165_t), y = MathHelper.func_76128_c((double)(this.field_70163_u - 1.0)), z = MathHelper.func_76128_c((double)this.field_70161_v))) {
            this.field_70181_x = -1.0;
        }
        if (this.field_70124_G || this.field_70122_E || this.childIsOnGround() || var2 == 0.0) {
            this.field_70181_x = 0.0;
        } else if (var2 < 0.5) {
            var6 = var2 * 2.0 - 1.0;
            this.field_70181_x += (double)0.04f * var6 / disp_delta;
        } else {
            if (this.field_70181_x < 0.0) {
                this.field_70181_x /= 2.0;
            }
            this.field_70181_x += (double)0.007f / disp_delta;
        }
        if (!this.Docked && !this.Anchored) {
            if (this.field_70153_n != null) {
                this.field_70159_w += this.field_70153_n.field_70159_w * this.field_70276_b;
                this.field_70179_y += this.field_70153_n.field_70179_y * this.field_70276_b;
            } else {
                this.field_70159_w *= 0.99;
                this.field_70181_x *= 0.99;
                this.field_70179_y *= 0.99;
            }
            var6 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
            double max_vector = this.MaxSpeed / 60.0;
            if (var6 > max_vector) {
                var8 = max_vector / var6;
                this.field_70159_w *= var8;
                this.field_70179_y *= var8;
                var6 = max_vector;
            }
            if (var6 > var24 && this.field_70276_b < 0.35) {
                this.field_70276_b += (0.35 - this.field_70276_b) / 35.0;
                if (this.field_70276_b > 0.35) {
                    this.field_70276_b = 0.35;
                }
            } else {
                this.field_70276_b -= (this.field_70276_b - 0.07) / 35.0;
                if (this.field_70276_b < 0.07) {
                    this.field_70276_b = 0.07;
                }
            }
        }
        if (this.Docked) {
            this.field_70159_w = 0.0;
            this.field_70179_y = 0.0;
        }
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (this.field_70123_F && var24 > 0.5) {
            if (!this.field_70170_p.field_72995_K) {
                int var25;
                this.killBoat(false);
                for (var25 = 0; var25 < 3; ++var25) {
                    this.func_70054_a(Block.field_71988_x.field_71990_ca, 1, 0.0f);
                }
                for (var25 = 0; var25 < 2; ++var25) {
                    this.func_70054_a(Item.field_77669_D.field_77779_bT, 1, 0.0f);
                }
            }
        } else {
            this.field_70159_w *= (double)0.99f;
            this.field_70181_x *= (double)0.95f;
            this.field_70179_y *= (double)0.99f;
        }
        this.field_70125_A = 0.0f;
        var8 = this.field_70177_z;
        double var26 = this.field_70169_q - this.field_70165_t;
        double var12 = this.field_70166_s - this.field_70161_v;
        if (var26 * var26 + var12 * var12 > 0.001) {
            var8 = (float)(Math.atan2(var12, var26) * 180.0 / Math.PI);
        }
        if ((var14 = MathHelper.func_76138_g((double)(var8 - (double)this.field_70177_z))) > this.MaxYawDif) {
            if (var14 > 65.0) {
                var14 = 0.05f;
                this.field_70159_w *= 0.25;
                this.field_70179_y *= 0.25;
            } else {
                var14 = this.MaxYawDif;
            }
        }
        if (var14 < -this.MaxYawDif) {
            if (var14 < -65.0) {
                var14 = -0.05f;
                this.field_70159_w *= 0.25;
                this.field_70179_y *= 0.25;
            } else {
                var14 = -this.MaxYawDif;
            }
        }
        this.field_70177_z = (float)((double)this.field_70177_z + var14);
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        this.setBoundingBox();
        this.syncChildren();
        if (this.field_70153_n == null) {
            this.TackTarget = 0.0f;
        } else if (var14 > 1.5) {
            this.TackTarget = this.MaxTackAngle;
        } else if (var14 < -1.5) {
            this.TackTarget = -this.MaxTackAngle;
        }
        if (this.TackAngle > this.TackTarget) {
            this.TackAngle -= this.TackSpeed;
            if (this.TackAngle < this.TackTarget) {
                this.TackAngle = this.TackTarget;
            }
        } else if (this.TackAngle < this.TackTarget) {
            this.TackAngle += this.TackSpeed;
            if (this.TackAngle > this.TackTarget) {
                this.TackAngle = this.TackTarget;
            }
        }
        float lastheel = this.Heel;
        this.Heel = this.Speed < 5.0 ? 0.0f : this.MaxHeel * (float)((this.Speed - 5.0) / this.MaxSpeed) * (float)(this.TackAngle > 0.0f ? -1 : 1);
        if (this.Heel > lastheel && this.Heel - lastheel > 1.0f) {
            this.Heel = lastheel + 1.0f;
        } else if (lastheel > this.Heel && lastheel - this.Heel > 1.0f) {
            this.Heel = lastheel - 1.0f;
        }
        if (this.Heel > this.MaxHeel) {
            this.Heel = this.MaxHeel;
        }
        if (this.Heel < -this.MaxHeel) {
            this.Heel = -this.MaxHeel;
        }
        if (!this.field_70170_p.field_72995_K && !this.Docked && !this.Anchored && this.field_70153_n != null && this.field_70153_n.field_70128_L) {
            this.field_70153_n = null;
        }
        this.updatePassengerPosition();
    }

    protected boolean childIsOnGround() {
        if (this.BoatParts != null) {
            for (int i = 0; i < this.BoatParts.length; ++i) {
                if (this.BoatParts[i] == null || !this.BoatParts[i].field_70122_E && !this.BoatParts[i].field_70124_G) continue;
                return true;
            }
        }
        return false;
    }

    public void func_70108_f(Entity par1Entity) {
        double var4;
        double var2;
        double var6;
        if (this.Docked && par1Entity instanceof EntityLiving) {
            return;
        }
        if (!this.isRider(par1Entity) && (var6 = MathHelper.func_76132_a((double)(var2 = par1Entity.field_70165_t - this.field_70165_t), (double)(var4 = par1Entity.field_70161_v - this.field_70161_v))) >= (double)0.01f) {
            var6 = MathHelper.func_76133_a((double)var6);
            var2 /= var6;
            var4 /= var6;
            double var8 = 1.0 / var6;
            if (var8 > 1.0) {
                var8 = 1.0;
            }
            var2 *= var8;
            var4 *= var8;
            var2 *= (double)0.05f;
            var4 *= (double)0.05f;
            this.func_70024_g(-((var2 *= (double)(1.0f - this.field_70144_Y)) * 0.1), 0.0, -((var4 *= (double)(1.0f - this.field_70144_Y)) * 0.1));
            par1Entity.func_70024_g(var2, 0.0, var4);
        }
    }

    public void applyBlockCollision(float x, float y, float z, float magnitude) {
        double var2 = (double)x - this.field_70165_t;
        double var4 = (double)z - this.field_70161_v;
        double var6 = MathHelper.func_76132_a((double)var2, (double)var4);
        if (!this.Docked && var6 >= (double)0.01f) {
            double var14;
            var6 = MathHelper.func_76133_a((double)var6);
            var2 /= var6;
            var4 /= var6;
            double var8 = 1.0 / var6;
            if (var8 > 1.0) {
                var8 = 1.0;
            }
            var2 *= var8;
            var4 *= var8;
            var2 *= (double)0.05f;
            var4 *= (double)0.05f;
            this.func_70024_g(-(var2 *= (double)(1.0f - this.field_70144_Y)), 0.0, -(var4 *= (double)(1.0f - this.field_70144_Y)));
            this.field_70159_w *= (double)magnitude;
            this.field_70181_x = 0.0;
            this.field_70179_y *= (double)magnitude;
            var8 = this.field_70177_z;
            double var26 = (double)x - this.field_70165_t;
            double var12 = (double)z - this.field_70161_v;
            if (var26 * var26 + var12 * var12 > 1.0) {
                var8 = (float)(Math.atan2(var12, var26) * 180.0 / Math.PI);
            }
            if ((var14 = MathHelper.func_76138_g((double)(var8 - (double)this.field_70177_z)) * (double)0.35f) > 2.5) {
                var14 = 2.5;
            }
            if (var14 < -2.5) {
                var14 = -2.5;
            }
            this.field_70177_z = (float)((double)this.field_70177_z + var14);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
        if (this.field_70124_G || this.field_70122_E || this.childIsOnGround()) {
            this.field_70181_x += (double)0.001f;
        }
    }

    public void func_70043_V() {
        this.updateRiderPosition(this.RiderXofs, this.RiderZofs);
        this.updatePassengerPosition();
    }

    public void updateRiderPosition(double _xOfs, double _zOfs) {
        if (this.field_70153_n == null) {
            logger.info(SmallBoat.LogLevel, "\t** no rider", new Object[0]);
            this.TackTarget = 0.0f;
        } else {
            double cos1 = Math.cos((double)this.field_70177_z * Math.PI / 180.0);
            double sin1 = Math.sin((double)this.field_70177_z * Math.PI / 180.0);
            double cos2 = Math.cos((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0);
            double sin2 = Math.sin((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0);
            double z = _zOfs;
            if (this.TackTarget > 0.0f) {
                z *= -1.0;
            }
            double var1 = cos1 * _xOfs + cos2 * z;
            double var3 = sin1 * _xOfs + sin2 * z;
            this.field_70153_n.func_70107_b(this.field_70165_t + var1, this.field_70163_u + this.RiderYofs + this.field_70153_n.func_70033_W(), this.field_70161_v + var3);
        }
    }

    public void updatePassengerPosition() {
        if (this.Passengers.size() > 0) {
            Iterator itr = this.Passengers.iterator();
            while (this.field_70153_n != null && itr.hasNext()) {
                Entity ent = (Entity)itr.next();
                ent.func_70107_b(ent.field_70165_t, this.field_70163_u + this.field_70153_n.func_70033_W(), ent.field_70161_v);
            }
        }
    }

    protected void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.func_74772_a("ParentUUID_MSB", this.getParentPersistentID().getMostSignificantBits());
        par1NBTTagCompound.func_74772_a("ParentUUID_LSB", this.getParentPersistentID().getLeastSignificantBits());
        par1NBTTagCompound.func_74768_a("Color", this.Color);
        par1NBTTagCompound.func_74768_a("ChildCount", this.BoatParts.length);
        par1NBTTagCompound.func_74757_a("Anchored", this.Anchored);
        par1NBTTagCompound.func_74757_a("Docked", this.Docked);
        logger.fine(SmallBoat.LogLevel, "** wrote parent %s to NBT", this.getParentPersistentID().toString());
    }

    protected void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        this.setParentPersistentID(new UUID(par1NBTTagCompound.func_74763_f("ParentUUID_MSB"), par1NBTTagCompound.func_74763_f("ParentUUID_LSB")));
        this.Color = par1NBTTagCompound.func_74762_e("Color");
        int count = par1NBTTagCompound.func_74762_e("ChildCount");
        this.BoatParts = new EntityBoatPart[count];
        this.PartsCount = 0;
        this.Anchored = par1NBTTagCompound.func_74767_n("Anchored");
        this.Docked = par1NBTTagCompound.func_74767_n("Docked");
        logger.fine(SmallBoat.LogLevel, "** read parent %s from NBT", this.getParentPersistentID().toString());
        this.SkipCount = 96;
        this.printInfo = true;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    public boolean func_70085_c(EntityPlayer par1EntityPlayer) {
        logger.info(SmallBoat.LogLevel, "%s.parent.interact()", this.field_70170_p.field_72995_K ? "client" : "server");
        return true;
    }

    public void OpenChest(int _childID, int _playerID) {
        logger.info(SmallBoat.LogLevel, "%s.OpenChest(%d, %d)", this.field_70170_p.field_72995_K ? "client" : "server", _childID, _playerID);
        Entity child = this.field_70170_p.func_73045_a(_childID);
        Entity player = this.field_70170_p.func_73045_a(_playerID);
        if (this.isChild(child)) {
            ((EntityBoatPart)child).OpenChest((EntityPlayer)player);
        } else {
            logger.info(SmallBoat.LogLevel, "\t*** not a child", new Object[0]);
        }
    }

    public void Mount(int _childID, int _playerID, byte _flags) {
        logger.info(SmallBoat.LogLevel, "%s.Mount(%d, %d, %02X)", this.field_70170_p.field_72995_K ? "client" : "server", _childID, _playerID, _flags);
        Entity seat = null;
        Entity child = this.getChildById(_childID);
        Entity player = this.field_70170_p.func_73045_a(_playerID);
        if (this.field_70157_k == _childID) {
            child = this;
        } else if (child == null && (child = this.field_70170_p.func_73045_a(_childID)) == null) {
            logger.info(SmallBoat.LogLevel, "\t!! child %d not found in world", _childID);
        }
        if (this.field_70170_p.field_72995_K) {
            logger.info(SmallBoat.LogLevel, "\t** player %d boarded %d.%d", _playerID, this.field_70157_k, _childID);
            Minecraft mc = FMLClientHandler.instance().getClient();
            if (mc.field_71439_g.field_70157_k == _playerID) {
                if (mc.field_71439_g != player) {
                    logger.info(SmallBoat.LogLevel, "\t!! mc.thePlayer != player", player.field_70154_o.field_70157_k);
                }
                if ((_flags & 2) == 0) {
                    ((EntityPlayer)player).func_71035_c("Use Shift-Right-Click to jump out");
                }
            }
            if (_flags == 0) {
                this.setAnchored(false);
                this.setDocked(false);
            } else {
                this.addPassenger(player);
            }
        } else if (player != null && (_flags & 2) == 0) {
            if ((_flags & 1) != 0) {
                this.addPassenger(player);
            } else {
                if (player.field_70154_o != null) {
                    player.func_70078_a(null);
                }
                if (this.isChild(child)) {
                    if (child.field_70153_n != null) {
                        logger.info(SmallBoat.LogLevel, "\t!! child %d already has rider %d", _childID, child.field_70153_n.field_70157_k);
                    }
                    logger.info(SmallBoat.LogLevel, "\t** mounting child %d", _childID);
                    player.func_70078_a(child);
                    seat = child;
                } else if (this.field_70153_n == null) {
                    logger.info(SmallBoat.LogLevel, "\t** mounting parent", new Object[0]);
                    player.func_70078_a((Entity)this);
                    seat = this;
                    this.setAnchored(false);
                    this.setDocked(false);
                } else if (this.BoatParts != null) {
                    logger.info(SmallBoat.LogLevel, "\t** mounting next available", new Object[0]);
                    for (int i = 0; i < this.BoatParts.length; ++i) {
                        if (this.BoatParts[i] == null || !this.BoatParts[i].hasSeat || this.BoatParts[i].field_70153_n != null) continue;
                        seat = this.BoatParts[i];
                        logger.info(SmallBoat.LogLevel, "\t** mounting %d", seat.field_70157_k);
                        player.func_70078_a(seat);
                        i = this.BoatParts.length;
                    }
                } else {
                    logger.info(SmallBoat.LogLevel, "\t** no entity to mount?", new Object[0]);
                }
            }
            if (seat != null) {
                this.sendMountUpdate(seat, player, _flags);
            }
        } else {
            logger.info(SmallBoat.LogLevel, "\t** could not get player for ID=%d", _playerID);
        }
    }

    public void Dismount(int _entityID) {
        logger.info(SmallBoat.LogLevel, "%s.Dismount(%d)", this.field_70170_p.field_72995_K ? "client" : "server", _entityID);
        logger.info(SmallBoat.LogLevel, "\theight=%f, minY=%f", Float.valueOf(this.field_70131_O), this.field_70121_D.field_72338_b);
        this.updateServerPosition();
        Entity player = this.field_70170_p.func_73045_a(_entityID);
        if (this.field_70170_p.field_72995_K) {
            logger.info(SmallBoat.LogLevel, "\t** player %d disembarked %d", player.field_70157_k, this.field_70157_k);
            this.updateRiderPosition(this.RiderXofs, this.RiderZofs + this.Beam / 2.0 + 2.0);
            ((EntityPlayer)player).func_70078_a(null);
            this.setDocked(true);
        } else if (player != null) {
            if (this.field_70153_n == player) {
                ((EntityPlayer)player).func_70078_a((Entity)this);
                this.setDocked(true);
            } else if (this.BoatParts != null) {
                for (int i = 0; i < this.BoatParts.length; ++i) {
                    if (this.BoatParts[i].field_70153_n != player) continue;
                    ((EntityPlayer)player).func_70078_a((Entity)this.BoatParts[i]);
                }
            }
            this.sendDismountUpdate((Entity)((EntityPlayer)player));
        } else {
            logger.info(SmallBoat.LogLevel, "\t** no rider?", new Object[0]);
        }
    }

    public void setFlags(int _flags) {
        this.Flags = _flags;
    }

    public int getFlags() {
        return this.Flags;
    }

    public void setDamageTaken(int par1) {
        this.field_70180_af.func_75692_b(19, (Object)par1);
    }

    public int getDamageTaken() {
        return this.field_70180_af.func_75679_c(19);
    }

    public void setTimeSinceHit(int par1) {
        this.field_70180_af.func_75692_b(17, (Object)par1);
    }

    public int getTimeSinceHit() {
        return this.field_70180_af.func_75679_c(17);
    }

    public void setForwardDirection(int par1) {
        this.field_70180_af.func_75692_b(18, (Object)par1);
    }

    public int getForwardDirection() {
        return this.field_70180_af.func_75679_c(18);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70270_d(boolean par1) {
        this.field_70279_a = par1;
    }

    public Entity[] func_70021_al() {
        boolean loaded = true;
        if (this.BoatParts != null) {
            for (int i = 0; i < this.BoatParts.length; ++i) {
                if (this.BoatParts[i] != null) continue;
                loaded = false;
            }
        } else {
            loaded = false;
        }
        if (loaded) {
            return this.BoatParts;
        }
        return null;
    }

    public Entity getChildById(int _id) {
        if (this.BoatParts != null) {
            for (int i = 0; i < this.BoatParts.length; ++i) {
                if (this.BoatParts[i] == null || this.BoatParts[i].field_70157_k != _id) continue;
                return this.BoatParts[i];
            }
        }
        return null;
    }

    public boolean isAnchored() {
        return this.Anchored;
    }

    public void setAnchored(boolean _anchored) {
        this.Anchored = _anchored;
    }

    public boolean isDocked() {
        return this.Docked;
    }

    public void setDocked(boolean _docked) {
        this.Docked = _docked;
    }

    public boolean isChild(Entity _part) {
        if (this.BoatParts != null) {
            for (int i = 0; i < this.BoatParts.length; ++i) {
                if (this.BoatParts[i] != _part) continue;
                return true;
            }
        }
        return false;
    }

    public float getTackAngle() {
        return this.TackAngle;
    }

    public double getSpeed() {
        return this.Speed;
    }

    public double getMaxSpeed() {
        return this.MaxSpeed;
    }

    public float getHeel() {
        return this.Heel;
    }

    public float getMaxHeel() {
        return this.MaxHeel;
    }

    public int getColor() {
        return this.Color;
    }

    public void setColor(int _color) {
        this.Color = _color;
    }

    public int getItemID() {
        return this.ItemID;
    }

    public void setItemID(int _id) {
        this.ItemID = _id;
    }

    public String getChannel() {
        return this.Channel;
    }

    public void setChannel(String _channel) {
        this.Channel = _channel;
    }

    public boolean isRider(Entity _entity) {
        if (_entity == null) {
            return false;
        }
        if (_entity == this.field_70153_n) {
            return true;
        }
        if (this.BoatParts != null) {
            for (int i = 0; i < this.BoatParts.length; ++i) {
                if (this.BoatParts[i] == null || !this.BoatParts[i].hasSeat || this.BoatParts[i].field_70153_n != _entity) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isRider(int _entityID) {
        if (_entityID == 0) {
            return false;
        }
        if (this.field_70153_n != null && _entityID == this.field_70153_n.field_70157_k) {
            return true;
        }
        if (this.BoatParts != null) {
            for (int i = 0; i < this.BoatParts.length; ++i) {
                if (this.BoatParts[i] == null || !this.BoatParts[i].hasSeat || this.BoatParts[i].field_70153_n == null || this.BoatParts[i].field_70153_n.field_70157_k != _entityID) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPassenger(Entity _entity) {
        return this.Passengers.contains(_entity);
    }

    public void addPassenger(Entity _entity) {
        if (!this.Passengers.contains(_entity)) {
            logger.info(SmallBoat.LogLevel, "%s.addPassenger(%d)", this.field_70170_p.field_72995_K ? "client" : "server", _entity.field_70157_k);
            this.Passengers.add(_entity);
            _entity.field_70154_o = this;
        }
    }

    public void addPassenger(int _entityID) {
        Entity player = this.field_70170_p.func_73045_a(_entityID);
        if (!this.Passengers.contains(player)) {
            logger.info(SmallBoat.LogLevel, "%s.addPassenger(%d)", this.field_70170_p.field_72995_K ? "client" : "server", player.field_70157_k);
            this.Passengers.add(player);
            player.field_70154_o = this;
        }
    }

    public void removePassenger(Entity _entity) {
        this.Passengers.remove(_entity);
    }

    public void func_70061_h(Entity par1Entity) {
        double d0 = this.field_70165_t;
        double d1 = this.field_70163_u;
        double d2 = this.field_70161_v;
        logger.info(SmallBoat.LogLevel, "unmountEntity(...)", new Object[0]);
        if (par1Entity != null) {
            d0 = par1Entity.field_70165_t;
            d1 = par1Entity.field_70121_D.field_72338_b + (double)par1Entity.field_70131_O;
            d2 = par1Entity.field_70161_v;
        }
        for (double d3 = -1.5; d3 < 2.0; d3 += 1.0) {
            for (double d4 = -1.5; d4 < 2.0; d4 += 1.0) {
                if (d3 == 0.0 && d4 == 0.0) continue;
                int i = (int)(this.field_70165_t + d3);
                int j = (int)(this.field_70161_v + d4);
                AxisAlignedBB axisalignedbb = this.field_70121_D.func_72325_c(d3, 1.0, d4);
                if (!this.field_70170_p.func_72840_a(axisalignedbb).isEmpty()) continue;
                if (this.field_70170_p.func_72797_t(i, (int)this.field_70163_u, j)) {
                    this.func_70012_b(this.field_70165_t + d3, this.field_70163_u + 1.0, this.field_70161_v + d4, this.field_70177_z, this.field_70125_A);
                    return;
                }
                if (!this.field_70170_p.func_72797_t(i, (int)this.field_70163_u - 1, j) && this.field_70170_p.func_72803_f(i, (int)this.field_70163_u - 1, j) != Material.field_76244_g) continue;
                d0 = this.field_70165_t + d3;
                d1 = this.field_70163_u + 1.0;
                d2 = this.field_70161_v + d4;
            }
        }
        this.func_70012_b(d0, d1, d2, this.field_70177_z, this.field_70125_A);
    }

    protected void calcDisplacement() {
        double min_x = 0.0;
        double min_y = 0.0;
        double min_z = 0.0;
        double max_x = 0.0;
        double max_y = 0.0;
        double max_z = 0.0;
        for (int i = 0; i < this.BoatParts.length; ++i) {
            if ((double)this.BoatParts[i].posOfsX < min_x) {
                min_x = this.BoatParts[i].posOfsX;
            }
            if ((double)this.BoatParts[i].posOfsX > max_x) {
                max_x = this.BoatParts[i].posOfsX;
            }
            if ((double)this.BoatParts[i].posOfsY < min_y) {
                min_y = this.BoatParts[i].posOfsY;
            }
            if ((double)this.BoatParts[i].posOfsY > max_y) {
                max_y = this.BoatParts[i].posOfsY;
            }
            if ((double)this.BoatParts[i].posOfsZ < min_z) {
                min_z = this.BoatParts[i].posOfsZ;
            }
            if (!((double)this.BoatParts[i].posOfsZ > max_z)) continue;
            max_z = this.BoatParts[i].posOfsZ;
        }
        double x = max_x + Math.abs(min_x);
        double y = max_y + Math.abs(min_y);
        double z = max_z + Math.abs(min_z);
        this.Beam = x;
        this.LWL = y;
        this.Displacement = x * y * z;
        if (this.Displacement <= 0.0) {
            this.Displacement = 1.0;
        }
        logger.info(SmallBoat.LogLevel, "Displacement = %f", this.Displacement);
    }
}

