/*
 * Decompiled with CFR 0.152.
 */
package mods.awger.whitehall;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import mods.awger.logger;
import mods.awger.smallboat.EntityBoatChest;
import mods.awger.smallboat.EntityBoatPart;
import mods.awger.smallboat.EntitySmallBoat;
import mods.awger.whitehall.Whitehall;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class EntityWhitehall
extends EntitySmallBoat
implements IEntityAdditionalSpawnData {
    public EntityBoatPart[] bow;
    public EntityBoatPart[] midship;
    public EntityBoatPart[] stern;
    public EntityBoatPart[] rigging;

    public EntityWhitehall(World par1World) {
        super(par1World);
        this.MaxHeel = 12.0f;
        this.MaxSpeed = 15.0;
        this.MaxYawDif = 3.5;
        this.Color = 0;
        this.RiderXofs = 1.95;
        this.RiderYofs = 0.05;
        this.RiderZofs = 0.35;
        this.setChannel("Whitehall");
    }

    public EntityWhitehall(World par1World, double par2, double par4, double par6) {
        this(par1World);
        logger.fine(Whitehall.LogLevel, "%s: instantiating EntityWhitehall(%d) with children", par1World.field_72995_K ? "client" : "server", this.field_70157_k);
        this.createChildren();
        this.func_70107_b(par2, par4 + (double)this.field_70129_M, par6);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = par2;
        this.field_70167_r = par4;
        this.field_70166_s = par6;
    }

    private void createChildren() {
        int i;
        logger.fine(Whitehall.LogLevel, "%s: createChildren() for %d", this.field_70170_p.field_72995_K ? "client" : "server", this.field_70157_k);
        int midxBow = -1;
        int midxMidship = -1;
        int midxStern = -1;
        int midxRigging = 1;
        this.bow = new EntityBoatPart[]{new EntityBoatPart(this, "Bow.0", midxBow), new EntityBoatPart(this, "Bow.1", midxBow)};
        this.midship = new EntityBoatPart[]{new EntityBoatPart(this, "Midship.0", midxMidship), new EntityBoatPart(this, "Midship.1", midxMidship), new EntityBoatChest(this, "Midship.2", 27, 3), new EntityBoatChest(this, "Midship.3", 27, 4), new EntityBoatPart(this, "Midship.4", midxMidship), new EntityBoatPart(this, "Midship.5", midxMidship), new EntityBoatPart(this, "Midship.6", midxMidship), new EntityBoatPart(this, "Midship.7", midxMidship)};
        this.stern = new EntityBoatPart[]{new EntityBoatPart(this, "Stern.0", 2), new EntityBoatPart(this, "Stern.1", midxStern)};
        this.rigging = new EntityBoatPart[]{new EntityBoatPart(this, "Mast", midxRigging)};
        this.bow[0].setPositionOffsets(-3.0f, 0.0f, -0.5f);
        this.bow[1].setPositionOffsets(-3.0f, 0.0f, 0.5f);
        this.bow[0].canInteract = false;
        this.bow[1].canInteract = false;
        this.midship[0].setPositionOffsets(-2.0f, 0.0f, -0.5f);
        this.midship[1].setPositionOffsets(-2.0f, 0.0f, 0.5f);
        this.midship[2].setPositionOffsets(-1.0f, 0.0f, -0.5f);
        this.midship[3].setPositionOffsets(-1.0f, 0.0f, 0.5f);
        this.midship[4].setPositionOffsets(0.0f, 0.0f, -0.5f);
        this.midship[5].setPositionOffsets(0.0f, 0.0f, 0.5f);
        this.midship[6].setPositionOffsets(1.0f, 0.0f, -0.5f);
        this.midship[7].setPositionOffsets(1.0f, 0.0f, 0.5f);
        this.stern[0].setPositionOffsets(2.0f, 0.0f, -0.5f);
        this.stern[0].setBoundingFlags((byte)8);
        this.stern[1].setPositionOffsets(2.0f, 0.0f, 0.5f);
        this.stern[1].setBoundingFlags((byte)8);
        this.rigging[0].setPositionOffsets(-4.0f, -1.0f, 0.0f);
        this.rigging[0].canInteract = false;
        this.midship[0].canInteract = false;
        this.midship[1].canInteract = false;
        this.midship[2].setName("Starboard");
        this.midship[3].setName("Port");
        this.midship[4].canInteract = false;
        this.midship[4].setBoundingFlags((byte)2);
        this.midship[5].canInteract = false;
        this.midship[5].setBoundingFlags((byte)1);
        this.midship[6].hasSeat = true;
        this.midship[6].setRiderOffsets(-0.2f, 0.0f, 0.0f);
        this.midship[6].setBoundingFlags((byte)32);
        this.midship[7].hasSeat = true;
        this.midship[7].setRiderOffsets(-0.2f, 0.0f, 0.0f);
        this.midship[7].setBoundingFlags((byte)32);
        int count = this.bow.length + this.midship.length + this.stern.length + this.rigging.length;
        this.BoatParts = new EntityBoatPart[count];
        for (i = 0; i < this.bow.length; ++i) {
            this.addPart(this.bow[i]);
        }
        for (i = 0; i < this.midship.length; ++i) {
            this.addPart(this.midship[i]);
        }
        for (i = 0; i < this.stern.length; ++i) {
            this.addPart(this.stern[i]);
        }
        for (i = 0; i < this.rigging.length; ++i) {
            this.addPart(this.rigging[i]);
        }
    }

    @Override
    public void writeSpawnData(ByteArrayDataOutput data) {
        super.writeSpawnData(data);
    }

    @Override
    public void readSpawnData(ByteArrayDataInput data) {
        super.readSpawnData(data);
    }

    @Override
    protected void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
    }

    @Override
    protected void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
    }
}

