/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import util.InstallAlgorithms;
import util.PrivatePrintStream;

public class Installer
extends JFrame {
    private File path;
    private static File jarPath;
    private static PrivatePrintStream pps;
    private static final int actualVersion = 13;
    private static int updateVersion;
    private static int screenWidth;
    private static int screenHeight;
    public static Installer installer;
    private JMenuItem changelogButton;
    private JButton chooseButton;
    private static JTextArea console;
    private JButton downloadModfilesButton;
    private JMenuItem fileSizeButton;
    private JMenuItem helpItem;
    private JButton installBackupButton;
    private JButton installButton;
    private JLabel jLabel1;
    private JMenu jMenu3;
    private JMenu jMenu4;
    private JMenuBar jMenuBar1;
    private JScrollPane jScrollPane1;
    private JTextField locationTextField;
    public JProgressBar progressBar;

    public Installer() {
        this.initComponents();
        pps = new PrivatePrintStream(console);
        this.setTitle("EBGInstaller by Florilu.");
        this.setDefaultCloseOperation(3);
        this.setResizable(false);
        this.setLocation(screenWidth - 200, screenHeight - 120);
        System.setOut(pps);
        this.checkForUpdate();
        this.checkForUpdater();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.locationTextField = new JTextField();
        this.chooseButton = new JButton();
        this.installButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        console = new JTextArea();
        this.installBackupButton = new JButton();
        this.downloadModfilesButton = new JButton();
        this.progressBar = new JProgressBar();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu3 = new JMenu();
        this.jMenu4 = new JMenu();
        this.helpItem = new JMenuItem();
        this.fileSizeButton = new JMenuItem();
        this.changelogButton = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setCursor(new Cursor(0));
        this.jLabel1.setText("Choose your .minecraft directory:");
        this.locationTextField.setEditable(false);
        this.locationTextField.setText("No File selected");
        this.locationTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Installer.this.locationTextFieldActionPerformed(evt);
            }
        });
        this.chooseButton.setText("Choose Folder...");
        this.chooseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Installer.this.chooseButtonActionPerformed(evt);
            }
        });
        this.installButton.setText("Install...");
        this.installButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Installer.this.installButtonActionPerformed(evt);
            }
        });
        console.setEditable(false);
        console.setColumns(20);
        console.setRows(5);
        this.jScrollPane1.setViewportView(console);
        this.installBackupButton.setText("Install Backup...");
        this.installBackupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Installer.this.installBackupButtonActionPerformed(evt);
            }
        });
        this.downloadModfilesButton.setText("Download Modfiles");
        this.downloadModfilesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Installer.this.downloadModfilesButtonActionPerformed(evt);
            }
        });
        this.jMenuBar1.add(this.jMenu3);
        this.jMenu4.setText("Help");
        this.helpItem.setText("Open Help");
        this.helpItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Installer.this.helpItemActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.helpItem);
        this.fileSizeButton.setText("Check Filesize (in development)");
        this.fileSizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Installer.this.fileSizeButtonActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.fileSizeButton);
        this.changelogButton.setText("Open Changelog");
        this.changelogButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Installer.this.changelogButtonActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.changelogButton);
        this.jMenuBar1.add(this.jMenu4);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.locationTextField).addGroup(layout.createSequentialGroup().addComponent(this.chooseButton, -2, 181, -2).addGap(6, 6, 6).addComponent(this.installButton, -2, 181, -2)).addGroup(layout.createSequentialGroup().addComponent(this.installBackupButton, -2, 181, -2).addGap(6, 6, 6).addComponent(this.downloadModfilesButton, -2, 181, -2)).addComponent(this.progressBar, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1).addComponent(this.jLabel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, 26, -2).addGap(8, 8, 8).addComponent(this.locationTextField, -2, -1, -2).addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chooseButton).addComponent(this.installButton)).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.installBackupButton).addComponent(this.downloadModfilesButton)).addGap(6, 6, 6).addComponent(this.progressBar, -2, 31, -2).addGap(6, 6, 6).addComponent(this.jScrollPane1, -2, -1, -2)));
        this.pack();
    }

    private void locationTextFieldActionPerformed(ActionEvent evt) {
    }

    private void chooseButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        System.out.println("Choosing Path...");
        chooser.setFileHidingEnabled(false);
        chooser.setCurrentDirectory(new File(System.getProperty("user.home")));
        chooser.setFileSelectionMode(1);
        chooser.showOpenDialog(null);
        this.path = chooser.getSelectedFile();
        if (this.path != null) {
            this.progressBar.setValue(33);
            System.out.println("Path has been selected...");
        } else {
            System.out.println("Please select a path!");
        }
        this.locationTextField.setText(this.path.toString());
    }

    private void installButtonActionPerformed(ActionEvent evt) {
        int result = JOptionPane.showConfirmDialog(null, "If you click on yes, you'll download the MinecraftForge Version that the mod needs to run, and the mod itself.", "Install Warning", 0);
        if (this.path != null && result == 0) {
            System.out.println();
            System.out.println("Installing in Folder: ");
            System.out.println(this.path);
            System.out.println();
            this.progressBar.setValue(66);
            try {
                if ("Done".equals(InstallAlgorithms.install(this.path, this.progressBar))) {
                    Runtime.getRuntime().exec("java -jar \"" + this.path + "/mcForgeInstaller.jar\"");
                    String url = "http://www.minecraftforge.net/forum/";
                    Runtime.getRuntime().exec("rundll32 url.dll, FileProtocolHandler " + url);
                    System.out.println("Opened MinecraftForge Website.");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            System.out.println("Please select a path to install the mod!");
        }
    }

    private void installBackupButtonActionPerformed(ActionEvent evt) {
        System.out.println("No sense to backup right now. Actually the button is just a placeholder.");
    }

    private void downloadModfilesButtonActionPerformed(ActionEvent evt) {
        if (this.path != null) {
            try {
                FileOutputStream os = new FileOutputStream(this.path + "/EBG Mod 1.6.2.zip");
                System.out.println("Downloading mod-files!");
                Installer.downloadFile("http://www.florilu.de/webspace/EBG_V1.5/EBG Mod 1.6.2.zip", os);
                System.out.println("Mod-files has been downloaded!");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Choose a directory for saving the mod-files!");
        }
    }

    private void helpItemActionPerformed(ActionEvent evt) {
        HelpFrame helpFrame = new HelpFrame();
        helpFrame.show();
    }

    private void fileSizeButtonActionPerformed(ActionEvent evt) {
    }

    private void changelogButtonActionPerformed(ActionEvent evt) {
        ChangelogFrame changelogFrame = new ChangelogFrame();
        changelogFrame.show();
    }

    private void checkForUpdate() {
        try {
            jarPath = new File(Installer.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
            jarPath = new File(jarPath.getParent());
            URL check = new URL("http://www.ni16061_1.vweb12.nitrado.net/florilu/webspace/Installer/ver/ver.txt");
            try (BufferedReader input = new BufferedReader(new InputStreamReader(check.openStream()));){
                updateVersion = Integer.valueOf(input.readLine());
            }
            if (updateVersion > 13) {
                int result = JOptionPane.showConfirmDialog(null, "A new version is available, install?", "UpdateQuestion", 0);
                if (result == 0) {
                    Installer.downloadFile("http://www.ni16061_1.vweb12.nitrado.net/florilu/webspace/Updater/InstallerUpdater.jar", new FileOutputStream(jarPath + File.separator + "InstallerUpdater.jar"));
                    Runtime.getRuntime().exec("java -jar \"" + jarPath + File.separator + "InstallerUpdater.jar\"");
                    System.exit(0);
                }
            } else {
                Thread.sleep(1000L);
                System.out.println("No new version available!");
            }
        }
        catch (IOException | IllegalStateException | InterruptedException | NumberFormatException | URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public static void downloadFile(String url_str, OutputStream os) throws IllegalStateException, MalformedURLException, ProtocolException, IOException {
        URL url = new URL(url_str.replace(" ", "%20"));
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.connect();
        int responseCode = conn.getResponseCode();
        if (responseCode == 200) {
            int n;
            byte[] tmp_buffer = new byte[4096];
            InputStream is = conn.getInputStream();
            while ((n = is.read(tmp_buffer)) > 0) {
                os.write(tmp_buffer, 0, n);
                os.flush();
            }
        } else {
            throw new IllegalStateException("HTTP response: " + responseCode);
        }
    }

    private void checkForUpdater() {
        File updater = new File("InstallerUpdater.jar");
        if (updater.exists()) {
            updater.delete();
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(Installer.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(Installer.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(Installer.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(Installer.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                installer = new Installer();
                installer.setVisible(true);
                installer.setTitle("Installer Version V13");
            }
        });
    }

    static {
        screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width / 2;
        screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height / 2;
    }
}

