/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.ByteChannel;
import java.nio.channels.FileChannel;

public class CopyFileNormal {
    public static File file(String path) {
        return new File(path);
    }

    public static void copy(File source, File destination) {
        try {
            FileInputStream fileInputStream = new FileInputStream(source);
            FileOutputStream fileOutputStream = new FileOutputStream(destination);
            FileChannel inputChannel = fileInputStream.getChannel();
            FileChannel outputChannel = fileOutputStream.getChannel();
            CopyFileNormal.transfer(inputChannel, outputChannel, source.length(), 0x2000000L, true, true);
            fileInputStream.close();
            fileOutputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void transfer(FileChannel fileChannel, ByteChannel byteChannel, long lengthInBytes, long chunckSizeInBytes, boolean verbose, boolean fromFile) throws IOException {
        long bytesTransfered;
        long time = -System.currentTimeMillis();
        for (long overallBytesTransfered = 0L; overallBytesTransfered < lengthInBytes; overallBytesTransfered += bytesTransfered) {
            bytesTransfered = 0L;
            bytesTransfered = fromFile ? fileChannel.transferTo(0L, Math.min(chunckSizeInBytes, lengthInBytes - overallBytesTransfered), byteChannel) : fileChannel.transferFrom(byteChannel, overallBytesTransfered, Math.min(chunckSizeInBytes, lengthInBytes - overallBytesTransfered));
        }
        time += System.currentTimeMillis();
        System.out.println();
    }
}

