/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures;

import java.util.Random;
import twilightforest.TFTreasure;
import twilightforest.block.TFBlocks;
import twilightforest.entity.TFCreatures;
import twilightforest.structures.StructureTFComponent;
import twilightforest.structures.TFMaze;

public class ComponentTFHedgeMaze
extends StructureTFComponent {
    static int MSIZE = 16;
    static int RADIUS = MSIZE / 2 * 3 + 1;
    static int DIAMETER = 2 * RADIUS;
    static int FLOOR_LEVEL = 3;

    public ComponentTFHedgeMaze(abw world, Random rand, int i, int x, int y, int z2) {
        super(i);
        this.setCoordBaseMode(0);
        this.f = StructureTFComponent.getComponentToAddBoundingBox(x, y, z2, -RADIUS, -3, -RADIUS, RADIUS * 2, 10, RADIUS * 2, 0);
    }

    public boolean a(abw world, Random rand, agf sbb) {
        TFMaze maze = new TFMaze(MSIZE, MSIZE);
        maze.oddBias = 2;
        maze.torchBlockID = TFBlocks.firefly.cF;
        maze.wallBlockID = TFBlocks.hedge.cF;
        maze.wallBlockMeta = 0;
        maze.type = 4;
        maze.tall = 3;
        maze.roots = 3;
        maze.setSeed(world.H() + (long)(this.f.a * this.f.c));
        for (int fx = 0; fx <= DIAMETER; ++fx) {
            for (int fz = 0; fz <= DIAMETER; ++fz) {
                this.a(world, aqz.z.cF, 0, fx, FLOOR_LEVEL - 1, fz, sbb);
            }
        }
        this.a(world, aqz.bk.cF, 1, 0, FLOOR_LEVEL, 24, sbb);
        this.a(world, aqz.bk.cF, 1, 0, FLOOR_LEVEL, 29, sbb);
        this.a(world, aqz.bk.cF, 3, 50, FLOOR_LEVEL, 24, sbb);
        this.a(world, aqz.bk.cF, 3, 50, FLOOR_LEVEL, 29, sbb);
        this.a(world, aqz.bk.cF, 2, 24, FLOOR_LEVEL, 0, sbb);
        this.a(world, aqz.bk.cF, 2, 29, FLOOR_LEVEL, 0, sbb);
        this.a(world, aqz.bk.cF, 0, 24, FLOOR_LEVEL, 50, sbb);
        this.a(world, aqz.bk.cF, 0, 29, FLOOR_LEVEL, 50, sbb);
        int nrooms = MSIZE / 3;
        int[] rcoords = new int[nrooms * 2];
        for (int i = 0; i < nrooms; ++i) {
            int rz2;
            int rx;
            while (this.isNearRoom(rx = maze.rand.nextInt(MSIZE - 2) + 1, rz2 = maze.rand.nextInt(MSIZE - 2) + 1, rcoords)) {
            }
            maze.carveRoom1(rx, rz2);
            rcoords[i * 2] = rx;
            rcoords[i * 2 + 1] = rz2;
        }
        maze.generateRecursiveBacktracker(0, 0);
        maze.add4Exits();
        maze.copyToStructure(world, 1, FLOOR_LEVEL, 1, this, sbb);
        this.decorate3x3Rooms(world, rcoords, sbb);
        return true;
    }

    protected boolean isNearRoom(int dx, int dz, int[] rcoords) {
        if (dx == 1 && dz == 1) {
            return true;
        }
        for (int i = 0; i < rcoords.length / 2; ++i) {
            int rx = rcoords[i * 2];
            int rz2 = rcoords[i * 2 + 1];
            if (rx == 0 && rz2 == 0 || Math.abs(dx - rx) >= 3 || Math.abs(dz - rz2) >= 3) continue;
            return true;
        }
        return false;
    }

    void decorate3x3Rooms(abw world, int[] rcoords, agf sbb) {
        for (int i = 0; i < rcoords.length / 2; ++i) {
            int dx = rcoords[i * 2];
            int dz = rcoords[i * 2 + 1];
            dx = dx * 3 + 3;
            dz = dz * 3 + 3;
            this.decorate3x3Room(world, dx, dz, sbb);
        }
    }

    void decorate3x3Room(abw world, int x, int z2, agf sbb) {
        Random roomRNG = new Random(world.H() ^ (long)(x + z2));
        this.roomJackO(world, roomRNG, x, z2, 8, sbb);
        if (roomRNG.nextInt(4) == 0) {
            this.roomJackO(world, roomRNG, x, z2, 8, sbb);
        }
        this.roomSpawner(world, roomRNG, x, z2, 8, sbb);
        this.roomTreasure(world, roomRNG, x, z2, 8, sbb);
        if (roomRNG.nextInt(4) == 0) {
            this.roomTreasure(world, roomRNG, x, z2, 8, sbb);
        }
    }

    private void roomSpawner(abw world, Random rand, int x, int z2, int diameter, agf sbb) {
        String mobID;
        int rx = x + rand.nextInt(diameter) - diameter / 2;
        int rz2 = z2 + rand.nextInt(diameter) - diameter / 2;
        switch (rand.nextInt(3)) {
            case 1: {
                mobID = TFCreatures.getSpawnerNameFor("Swarm Spider");
                break;
            }
            case 2: {
                mobID = TFCreatures.getSpawnerNameFor("Hostile Wolf");
                break;
            }
            default: {
                mobID = TFCreatures.getSpawnerNameFor("Hedge Spider");
            }
        }
        this.placeSpawnerAtCurrentPosition(world, rand, rx, FLOOR_LEVEL, rz2, mobID, sbb);
    }

    private void roomTreasure(abw world, Random rand, int x, int z2, int diameter, agf sbb) {
        int rx = x + rand.nextInt(diameter) - diameter / 2;
        int rz2 = z2 + rand.nextInt(diameter) - diameter / 2;
        this.placeTreasureAtCurrentPosition(world, rand, rx, FLOOR_LEVEL, rz2, TFTreasure.hedgemaze, sbb);
    }

    private void roomJackO(abw world, Random rand, int x, int z2, int diameter, agf sbb) {
        int rx = x + rand.nextInt(diameter) - diameter / 2;
        int rz2 = z2 + rand.nextInt(diameter) - diameter / 2;
        this.a(world, aqz.bk.cF, rand.nextInt(4), rx, FLOOR_LEVEL, rz2, sbb);
    }
}

