/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import java.util.Random;
import twilightforest.block.TFBlocks;
import twilightforest.world.TFTreeGenerator;
import twilightforest.world.TFWorld;

public class TFGenDarkCanopyTree
extends TFTreeGenerator {
    public TFGenDarkCanopyTree() {
        this(false);
    }

    public TFGenDarkCanopyTree(boolean par1) {
        super(par1);
        this.treeBlock = TFBlocks.log.cF;
        this.treeMeta = 3;
        this.branchMeta = 15;
        this.leafBlock = TFBlocks.hedge.cF;
        this.leafMeta = 1;
        this.rootBlock = TFBlocks.root.cF;
        this.rootMeta = 0;
    }

    @Override
    public boolean a(abw world, Random random, int x, int y, int z2) {
        boolean foundDirt = false;
        for (int dy = y; dy >= TFWorld.SEALEVEL; --dy) {
            akc materialUnder = world.g(x, dy - 1, z2);
            if (materialUnder == akc.b || materialUnder == akc.c) {
                foundDirt = true;
                y = dy;
                break;
            }
            if (materialUnder == akc.e || materialUnder == akc.p) break;
        }
        if (!foundDirt) {
            return false;
        }
        if (world.g(x + 1, y, z2 + 0) == akc.d || world.g(x - 1, y, z2 + 0) == akc.d || world.g(x + 0, y, z2 + 1) == akc.d || world.g(x + 0, y, z2 - 1) == akc.d) {
            return false;
        }
        int treeHeight = 4 + random.nextInt(3);
        this.drawBresehnam(world, x, y, z2, x, y + treeHeight, z2, this.treeBlock, this.treeMeta, true);
        int numBranches = 4;
        double offset = random.nextFloat();
        for (int b = 0; b < numBranches; ++b) {
            this.buildBranch(world, x, y, z2, treeHeight - numBranches + b / 2, 8.0, 0.23 * (double)b + offset, 0.23, random);
        }
        if (this.hasAirAround((acf)world, x, y - 1, z2)) {
            this.a(world, x, y - 1, z2, this.treeBlock, this.treeMeta);
        } else {
            this.a(world, x, y - 1, z2, this.rootBlock, this.rootMeta);
        }
        int numRoots = 3 + random.nextInt(2);
        offset = random.nextDouble();
        for (int b = 0; b < numRoots; ++b) {
            this.buildRoot(world, x, y, z2, offset, b);
        }
        return true;
    }

    void buildBranch(abw world, int x, int y, int z2, int height, double length, double angle, double tilt, Random random) {
        int[] src = new int[]{x, y + height, z2};
        int[] dest = TFGenDarkCanopyTree.translate(src[0], src[1], src[2], length, angle, tilt);
        this.drawBresehnam(world, src[0], src[1], src[2], dest[0], dest[1], dest[2], this.treeBlock, this.branchMeta, true);
        int leafSize = 4;
        if (random.nextInt(3) == 0) {
            leafSize = (byte)(leafSize + (random.nextInt(3) - 1));
        }
        if (world.a(dest[0], dest[1] - 1, dest[2]) == 0 || world.a(dest[0], dest[1] + 1, dest[2]) == 0 || world.a(dest[0] + 4, dest[1], dest[2]) == 0 || world.a(dest[0] - 4, dest[1], dest[2]) == 0 || world.a(dest[0], dest[1], dest[2] + 4) == 0 || world.a(dest[0], dest[1], dest[2] - 4) == 0) {
            this.drawCircle(world, dest[0], dest[1] - 1, dest[2], leafSize, this.leafBlock, this.leafMeta, false);
            this.drawCircle(world, dest[0], dest[1], dest[2], leafSize + 1, this.leafBlock, this.leafMeta, false);
            this.drawCircle(world, dest[0], dest[1] + 1, dest[2], leafSize, this.leafBlock, this.leafMeta, false);
            this.drawCircle(world, dest[0], dest[1] + 2, dest[2], leafSize - 2, this.leafBlock, this.leafMeta, false);
        }
    }

    void nullifySkyLightUnderBranch(abw world, int sx, int sy, int sz, int rad) {
        for (int dx = 0; dx <= rad; dx = (int)((byte)(dx + 1))) {
            for (int dz = 0; dz <= rad; dz = (int)((byte)(dz + 1))) {
                int dist = Math.max(dx, dz) + (Math.min(dx, dz) >> 1);
                if (dist > rad) continue;
                this.nullifySkyLightColumn(world, sx + dx, sy, sz + dz);
                this.nullifySkyLightColumn(world, sx + dx, sy, sz - dz);
                this.nullifySkyLightColumn(world, sx - dx, sy, sz + dz);
                this.nullifySkyLightColumn(world, sx - dx, sy, sz - dz);
            }
        }
    }

    void nullifySkyLightColumn(abw world, int dx, int dy, int dz) {
        for (int y = dy; y >= 0; --y) {
            world.b(ach.a, dx, y, dz, 0);
        }
    }
}

