/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import java.util.Random;
import twilightforest.block.TFBlocks;
import twilightforest.world.TFTreeGenerator;

public class TFGenMangroveTree
extends TFTreeGenerator {
    boolean checkForWater;

    public TFGenMangroveTree() {
        this(false);
    }

    public TFGenMangroveTree(boolean par1) {
        super(par1);
        this.checkForWater = !par1;
        this.treeBlock = TFBlocks.log.cF;
        this.treeMeta = 2;
        this.branchMeta = 14;
        this.leafBlock = TFBlocks.leaves.cF;
        this.leafMeta = 2;
        this.rootBlock = TFBlocks.root.cF;
        this.rootMeta = 0;
    }

    @Override
    public boolean a(abw world, Random random, int x, int y, int z2) {
        if (this.checkForWater && world.a(x, y - 1, z2) != aqz.G.cF || y >= 109) {
            return false;
        }
        this.buildBranch(world, random, x, y, z2, 5, 6 + random.nextInt(3), 0.0, 0.0, true);
        int numBranches = random.nextInt(3);
        double offset = random.nextDouble();
        for (int b = 0; b < numBranches; ++b) {
            this.buildBranch(world, random, x, y, z2, 7 + b, 6 + random.nextInt(2), 0.3 * (double)b + offset, 0.25, false);
        }
        int numRoots = 3 + random.nextInt(2);
        offset = random.nextDouble();
        for (int i = 0; i < numRoots; ++i) {
            double rTilt = 0.75 + random.nextDouble() * 0.1;
            this.buildRoot(world, x, y, z2, 5, 12.0, 0.4 * (double)i + offset, rTilt);
        }
        this.addFirefly(world, x, y, z2, 5 + random.nextInt(5), random.nextDouble());
        return true;
    }

    void buildBranch(abw world, Random random, int x, int y, int z2, int height, double length, double angle, double tilt, boolean trunk) {
        int[] src = new int[]{x, y + height, z2};
        int[] dest = TFGenMangroveTree.translate(src[0], src[1], src[2], length, angle, tilt);
        this.drawBresehnam(world, src[0], src[1], src[2], dest[0], dest[1], dest[2], this.treeBlock, trunk ? this.treeMeta : this.branchMeta, true);
        int bSize = 2 + random.nextInt(3);
        if (bSize > 2) {
            this.putBlockAndMetadata(world, dest[0] + 1, dest[1], dest[2], this.treeBlock, this.branchMeta, true);
            this.putBlockAndMetadata(world, dest[0] - 1, dest[1], dest[2], this.treeBlock, this.branchMeta, true);
            this.putBlockAndMetadata(world, dest[0], dest[1], dest[2] + 1, this.treeBlock, this.branchMeta, true);
            this.putBlockAndMetadata(world, dest[0], dest[1], dest[2] - 1, this.treeBlock, this.branchMeta, true);
        }
        this.drawCircle(world, dest[0], dest[1] - 1, dest[2], (byte)(bSize - 1), this.leafBlock, this.leafMeta, false);
        this.drawCircle(world, dest[0], dest[1], dest[2], (byte)bSize, this.leafBlock, this.leafMeta, false);
        this.drawCircle(world, dest[0], dest[1] + 1, dest[2], (byte)(bSize - 2), this.leafBlock, this.leafMeta, false);
    }

    void buildRoot(abw world, int x, int y, int z2, int height, double length, double angle, double tilt) {
        int[] src = new int[]{x, y + height, z2};
        int[] dest = TFGenMangroveTree.translate(src[0], src[1], src[2], length, angle, tilt);
        int[] lineArray = TFGenMangroveTree.getBresehnamArray(src[0], src[1], src[2], dest[0], dest[1], dest[2]);
        boolean stillAboveGround = true;
        for (int i = 0; i < lineArray.length; i += 3) {
            if (stillAboveGround && this.hasAirAround((acf)world, lineArray[i + 0], lineArray[i + 1], lineArray[i + 2])) {
                this.a(world, lineArray[i + 0], lineArray[i + 1], lineArray[i + 2], this.treeBlock, this.branchMeta);
                this.a(world, lineArray[i + 0], lineArray[i + 1] - 1, lineArray[i + 2], this.treeBlock, this.branchMeta);
                continue;
            }
            this.placeRootBlock(world, lineArray[i + 0], lineArray[i + 1], lineArray[i + 2], this.rootBlock, this.rootMeta);
            this.placeRootBlock(world, lineArray[i + 0], lineArray[i + 1] - 1, lineArray[i + 2], this.rootBlock, this.rootMeta);
            stillAboveGround = false;
        }
    }

    private void addFirefly(abw world, int x, int y, int z2, int height, double angle) {
        int iAngle = (int)(angle * 4.0);
        if (iAngle == 0) {
            this.putBlockAndMetadata(world, x + 1, y + height, z2, TFBlocks.firefly.cF, 0, false);
        } else if (iAngle == 1) {
            this.putBlockAndMetadata(world, x - 1, y + height, z2, TFBlocks.firefly.cF, 0, false);
        } else if (iAngle == 2) {
            this.putBlockAndMetadata(world, x, y + height, z2 + 1, TFBlocks.firefly.cF, 0, false);
        } else if (iAngle == 3) {
            this.putBlockAndMetadata(world, x, y + height, z2 - 1, TFBlocks.firefly.cF, 0, false);
        }
    }
}

