/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import java.util.Random;

public abstract class TFGenerator
extends afe {
    public TFGenerator() {
        this(false);
    }

    public TFGenerator(boolean par1) {
        super(par1);
    }

    public abstract boolean a(abw var1, Random var2, int var3, int var4, int var5);

    protected boolean putBlock(abw world, int dx, int dy, int dz, int blockValue, boolean priority) {
        return this.putBlockAndMetadata(world, dx, dy, dz, blockValue, 0, priority);
    }

    protected boolean putBlockAndMetadata(abw world, int dx, int dy, int dz, int blockValue, int metaValue, boolean priority) {
        if (priority) {
            this.a(world, dx, dy, dz, blockValue, metaValue);
        } else {
            int whatsThere = world.a(dx, dy, dz);
            if (whatsThere == 0) {
                this.a(world, dx, dy, dz, blockValue, metaValue);
            } else {
                return false;
            }
        }
        return true;
    }

    protected void putBlockAndMetadata(abw world, int[] pixel, int blockValue, int metaValue, boolean priority) {
        this.putBlockAndMetadata(world, pixel[0], pixel[1], pixel[2], blockValue, metaValue, priority);
    }

    protected void putBlock(abw world, int[] pixel, int blockValue, boolean priority) {
        this.putBlockAndMetadata(world, pixel[0], pixel[1], pixel[2], blockValue, 0, priority);
    }

    public static int[] translate(int sx, int sy, int sz, double distance, double angle, double tilt) {
        int[] dest = new int[]{sx, sy, sz};
        double rangle = angle * 2.0 * Math.PI;
        double rtilt = tilt * Math.PI;
        dest[0] = (int)((long)dest[0] + Math.round(Math.sin(rangle) * Math.sin(rtilt) * distance));
        dest[1] = (int)((long)dest[1] + Math.round(Math.cos(rtilt) * distance));
        dest[2] = (int)((long)dest[2] + Math.round(Math.cos(rangle) * Math.sin(rtilt) * distance));
        return dest;
    }

    protected void drawBresehnam(abw world, int x1, int y1, int z1, int x2, int y2, int z2, int blockValue, boolean priority) {
        this.drawBresehnam(world, x1, y1, z1, x2, y2, z2, blockValue, 0, priority);
    }

    protected void drawBresehnamX(abw world, int x1, int y1, int z1, int x2, int y2, int z2, int blockValue, int metaValue, boolean priority) {
        int[] pixel = new int[]{x1, y1, z1};
        int dx = x2 - x1;
        int dy = y2 - y1;
        int dz = z2 - z1;
        int x_inc = dx < 0 ? -1 : 1;
        int l = Math.abs(dx);
        int y_inc = dy < 0 ? -1 : 1;
        int m = Math.abs(dy);
        int z_inc = dz < 0 ? -1 : 1;
        int n = Math.abs(dz);
        int dx2 = l << 1;
        int dy2 = m << 1;
        int dz2 = n << 1;
        if (l >= m && l >= n) {
            int err_1 = dy2 - l;
            int err_2 = dz2 - l;
            for (int i = 0; i < l; ++i) {
                this.putBlockAndMetadata(world, pixel, blockValue, metaValue, priority);
                if (err_1 > 0) {
                    pixel[1] = pixel[1] + y_inc;
                    err_1 -= dx2;
                }
                if (err_2 > 0) {
                    pixel[2] = pixel[2] + z_inc;
                    err_2 -= dx2;
                }
                err_1 += dy2;
                err_2 += dz2;
                pixel[0] = pixel[0] + x_inc;
            }
        } else if (m >= l && m >= n) {
            int err_1 = dx2 - m;
            int err_2 = dz2 - m;
            for (int i = 0; i < m; ++i) {
                this.putBlockAndMetadata(world, pixel, blockValue, metaValue, priority);
                if (err_1 > 0) {
                    pixel[0] = pixel[0] + x_inc;
                    err_1 -= dy2;
                }
                if (err_2 > 0) {
                    pixel[2] = pixel[2] + z_inc;
                    err_2 -= dy2;
                }
                err_1 += dx2;
                err_2 += dz2;
                pixel[1] = pixel[1] + y_inc;
            }
        } else {
            int err_1 = dy2 - n;
            int err_2 = dx2 - n;
            for (int i = 0; i < n; ++i) {
                this.putBlockAndMetadata(world, pixel, blockValue, metaValue, priority);
                if (err_1 > 0) {
                    pixel[1] = pixel[1] + y_inc;
                    err_1 -= dz2;
                }
                if (err_2 > 0) {
                    pixel[0] = pixel[0] + x_inc;
                    err_2 -= dz2;
                }
                err_1 += dy2;
                err_2 += dx2;
                pixel[2] = pixel[2] + z_inc;
            }
        }
        this.putBlockAndMetadata(world, pixel, blockValue, metaValue, priority);
    }

    protected void drawBresehnam(abw world, int x1, int y1, int z1, int x2, int y2, int z2, int blockValue, int metaValue, boolean priority) {
        int[] lineArray = TFGenerator.getBresehnamArray(x1, y1, z1, x2, y2, z2);
        for (int i = 0; i < lineArray.length; i += 3) {
            this.putBlockAndMetadata(world, lineArray[i + 0], lineArray[i + 1], lineArray[i + 2], blockValue, metaValue, priority);
        }
    }

    public static int[] getBresehnamArray(int x1, int y1, int z1, int x2, int y2, int z2) {
        int[] lineArray;
        int[] pixel = new int[]{x1, y1, z1};
        int dx = x2 - x1;
        int dy = y2 - y1;
        int dz = z2 - z1;
        int x_inc = dx < 0 ? -1 : 1;
        int l = Math.abs(dx);
        int y_inc = dy < 0 ? -1 : 1;
        int m = Math.abs(dy);
        int z_inc = dz < 0 ? -1 : 1;
        int n = Math.abs(dz);
        int dx2 = l << 1;
        int dy2 = m << 1;
        int dz2 = n << 1;
        if (l >= m && l >= n) {
            int err_1 = dy2 - l;
            int err_2 = dz2 - l;
            lineArray = new int[3 * l + 3];
            for (int i = 0; i < l * 3; i += 3) {
                lineArray[i + 0] = pixel[0];
                lineArray[i + 1] = pixel[1];
                lineArray[i + 2] = pixel[2];
                if (err_1 > 0) {
                    pixel[1] = pixel[1] + y_inc;
                    err_1 -= dx2;
                }
                if (err_2 > 0) {
                    pixel[2] = pixel[2] + z_inc;
                    err_2 -= dx2;
                }
                err_1 += dy2;
                err_2 += dz2;
                pixel[0] = pixel[0] + x_inc;
            }
        } else if (m >= l && m >= n) {
            int err_1 = dx2 - m;
            int err_2 = dz2 - m;
            lineArray = new int[3 * m + 3];
            for (int i = 0; i < m * 3; i += 3) {
                lineArray[i + 0] = pixel[0];
                lineArray[i + 1] = pixel[1];
                lineArray[i + 2] = pixel[2];
                if (err_1 > 0) {
                    pixel[0] = pixel[0] + x_inc;
                    err_1 -= dy2;
                }
                if (err_2 > 0) {
                    pixel[2] = pixel[2] + z_inc;
                    err_2 -= dy2;
                }
                err_1 += dx2;
                err_2 += dz2;
                pixel[1] = pixel[1] + y_inc;
            }
        } else {
            int err_1 = dy2 - n;
            int err_2 = dx2 - n;
            lineArray = new int[3 * n + 3];
            for (int i = 0; i < n * 3; i += 3) {
                lineArray[i + 0] = pixel[0];
                lineArray[i + 1] = pixel[1];
                lineArray[i + 2] = pixel[2];
                if (err_1 > 0) {
                    pixel[1] = pixel[1] + y_inc;
                    err_1 -= dz2;
                }
                if (err_2 > 0) {
                    pixel[0] = pixel[0] + x_inc;
                    err_2 -= dz2;
                }
                err_1 += dy2;
                err_2 += dx2;
                pixel[2] = pixel[2] + z_inc;
            }
        }
        lineArray[lineArray.length - 3] = pixel[0];
        lineArray[lineArray.length - 2] = pixel[1];
        lineArray[lineArray.length - 1] = pixel[2];
        return lineArray;
    }

    public void drawCircle(abw world, int sx, int sy, int sz, int rad, int blockValue, int metaValue, boolean priority) {
        for (int dx = 0; dx <= rad; dx = (int)((byte)(dx + 1))) {
            for (int dz = 0; dz <= rad; dz = (int)((byte)(dz + 1))) {
                int dist = Math.max(dx, dz) + (Math.min(dx, dz) >> 1);
                if (dx == 3 && dz == 3) {
                    dist = 6;
                }
                if (dist > rad) continue;
                this.putBlockAndMetadata(world, sx + dx, sy, sz + dz, blockValue, metaValue, priority);
                this.putBlockAndMetadata(world, sx + dx, sy, sz - dz, blockValue, metaValue, priority);
                this.putBlockAndMetadata(world, sx - dx, sy, sz + dz, blockValue, metaValue, priority);
                this.putBlockAndMetadata(world, sx - dx, sy, sz - dz, blockValue, metaValue, priority);
            }
        }
    }

    public void drawDiameterCircle(abw world, int sx, int sy, int sz, int diam, int block, int meta, boolean priority) {
        byte rad = (byte)((diam - 1) / 2);
        if (diam % 2 == 1) {
            this.drawCircle(world, sx, sy, sz, rad, (byte)block, meta, priority);
        } else {
            this.drawCircle(world, sx, sy, sz, rad, (byte)block, meta, priority);
            this.drawCircle(world, sx + 1, sy, sz, rad, (byte)block, meta, priority);
            this.drawCircle(world, sx, sy, sz + 1, rad, (byte)block, meta, priority);
            this.drawCircle(world, sx + 1, sy, sz + 1, rad, (byte)block, meta, priority);
        }
    }

    protected byte randStone(Random rand, int howMuch) {
        return rand.nextInt(howMuch) >= 1 ? (byte)aqz.B.cF : (byte)aqz.at.cF;
    }

    protected boolean isAreaClear(abw world, Random rand, int x, int y, int z2, int dx, int dy, int dz) {
        boolean flag = true;
        for (int cx = 0; cx < dx; ++cx) {
            for (int cz = 0; cz < dy; ++cz) {
                akc m = world.g(x + cx, y - 1, z2 + cz);
                if (m != akc.c && m != akc.b && m != akc.e) {
                    flag = false;
                }
                for (int cy = 0; cy < dz; ++cy) {
                    if (world.c(x + cx, y + cy, z2 + cz)) continue;
                    flag = false;
                }
            }
        }
        return flag;
    }

    protected void fill(abw world, int dx, int dy, int dz, int width, int height, int depth, int blockID, int meta) {
        for (int cx = 0; cx < width; ++cx) {
            for (int cy = 0; cy < height; ++cy) {
                for (int cz = 0; cz < depth; ++cz) {
                    this.a(world, dx + cx, dy + cy, dz + cz, blockID, meta);
                }
            }
        }
    }

    public void drawBlob(abw world, int sx, int sy, int sz, int rad, int blockValue, int metaValue, boolean priority) {
        for (int dx = 0; dx <= rad; dx = (int)((byte)(dx + 1))) {
            for (int dy = 0; dy <= rad; dy = (int)((byte)(dy + 1))) {
                for (int dz = 0; dz <= rad; dz = (int)((byte)(dz + 1))) {
                    int dist = 0;
                    dist = dx >= dy && dx >= dz ? dx + (Math.max(dy, dz) >> 1) + (Math.min(dy, dz) >> 2) : (dy >= dx && dy >= dz ? dy + (Math.max(dx, dz) >> 1) + (Math.min(dx, dz) >> 2) : dz + (Math.max(dx, dy) >> 1) + (Math.min(dx, dy) >> 2));
                    if (dist > rad) continue;
                    this.putBlockAndMetadata(world, sx + dx, sy + dy, sz + dz, blockValue, metaValue, priority);
                    this.putBlockAndMetadata(world, sx + dx, sy + dy, sz - dz, blockValue, metaValue, priority);
                    this.putBlockAndMetadata(world, sx - dx, sy + dy, sz + dz, blockValue, metaValue, priority);
                    this.putBlockAndMetadata(world, sx - dx, sy + dy, sz - dz, blockValue, metaValue, priority);
                    this.putBlockAndMetadata(world, sx + dx, sy - dy, sz + dz, blockValue, metaValue, priority);
                    this.putBlockAndMetadata(world, sx + dx, sy - dy, sz - dz, blockValue, metaValue, priority);
                    this.putBlockAndMetadata(world, sx - dx, sy - dy, sz + dz, blockValue, metaValue, priority);
                    this.putBlockAndMetadata(world, sx - dx, sy - dy, sz - dz, blockValue, metaValue, priority);
                }
            }
        }
    }

    protected boolean hasAirAround(acf world, int bx, int by2, int bz) {
        boolean airAround = false;
        if (world.a(bx + 1, by2, bz) == 0) {
            airAround = true;
        }
        if (world.a(bx - 1, by2, bz) == 0) {
            airAround = true;
        }
        if (world.a(bx, by2, bz + 1) == 0) {
            airAround = true;
        }
        if (world.a(bx, by2, bz - 1) == 0) {
            airAround = true;
        }
        if (world.a(bx, by2 + 1, bz) == 0) {
            airAround = true;
        }
        return airAround;
    }

    protected static boolean isNearSolid(acf world, int bx, int by2, int bz) {
        boolean nearSolid = false;
        if (world.g(bx + 1, by2, bz).a()) {
            nearSolid = true;
        }
        if (world.g(bx - 1, by2, bz).a()) {
            nearSolid = true;
        }
        if (world.g(bx, by2, bz + 1).a()) {
            nearSolid = true;
        }
        if (world.g(bx, by2, bz - 1).a()) {
            nearSolid = true;
        }
        return nearSolid;
    }
}

