/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import twilightforest.block.TFBlocks;
import twilightforest.world.TFGenerator;

public abstract class TFTreeGenerator
extends TFGenerator {
    protected int treeBlock;
    protected int treeMeta;
    protected int branchMeta;
    protected int leafBlock;
    protected int leafMeta;
    protected int rootBlock;
    protected int rootMeta;

    public TFTreeGenerator() {
        this(false);
    }

    public TFTreeGenerator(boolean par1) {
        super(par1);
        this.treeBlock = TFBlocks.log.cF;
        this.treeMeta = 3;
        this.branchMeta = 15;
        this.leafBlock = TFBlocks.hedge.cF;
        this.leafMeta = 1;
        this.rootBlock = TFBlocks.root.cF;
        this.rootMeta = 0;
    }

    protected void buildRoot(abw world, int x, int y, int z2, double offset, int b) {
        int[] dest = TFTreeGenerator.translate(x, y - b - 2, z2, 5.0, 0.3 * (double)b + offset, 0.8);
        int[] lineArray = TFTreeGenerator.getBresehnamArray(x, y - b - 2, z2, dest[0], dest[1], dest[2]);
        for (int i = 0; i < lineArray.length; i += 3) {
            this.placeRootBlock(world, lineArray[i + 0], lineArray[i + 1], lineArray[i + 2], this.rootBlock, this.rootMeta);
        }
    }

    protected void placeRootBlock(abw world, int x, int y, int z2, int block, int meta) {
        if (TFTreeGenerator.canRootGrowIn(world, x, y, z2)) {
            this.a(world, x, y, z2, block, meta);
        }
    }

    public static boolean canRootGrowIn(abw world, int x, int y, int z2) {
        int blockID = world.a(x, y, z2);
        if (blockID == 0) {
            return TFTreeGenerator.isNearSolid((acf)world, x, y, z2);
        }
        return blockID != aqz.E.cF && blockID != aqz.au.cF && blockID != TFBlocks.shield.cF;
    }
}

