package info.jbcs.minecraft.chisel;

import info.jbcs.minecraft.chisel.utilities.Sounds;
import info.jbcs.minecraft.utilities.BlockTexturedOreRenderer;
import net.minecraft.client.renderer.entity.RenderSnowball;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.MinecraftForge;
import cpw.mods.fml.client.registry.RenderingRegistry;

public class ProxyClient extends Proxy {
	ItemChiselRenderer renderer = new ItemChiselRenderer();

	@Override
	public void preInit() {
		MinecraftForge.EVENT_BUS.register(new Sounds() {
			@Override
			public void addSounds() {
				addSound("random/chisel", "/assets/Chisel/sounds/chisel.ogg");

				addSound("random/chisel-wood2", "/assets/Chisel/sounds/chisel-wood-2.ogg");
				addSound("random/chisel-wood3", "/assets/Chisel/sounds/chisel-wood-3.ogg");
				addSound("random/chisel-wood4", "/assets/Chisel/sounds/chisel-wood-4.ogg");
				addSound("random/chisel-wood5", "/assets/Chisel/sounds/chisel-wood-5.ogg");
				addSound("random/chisel-wood8", "/assets/Chisel/sounds/chisel-wood-8.ogg");
				addSound("random/chisel-wood9", "/assets/Chisel/sounds/chisel-wood-9.ogg");
				addSound("random/chisel-wood11","/assets/Chisel/sounds/chisel-wood-11.ogg");
	/*			
				addSound("random/holystone1", "/assets/Chisel/sounds/holystone-1.ogg");
				addSound("random/holystone2", "/assets/Chisel/sounds/holystone-2.ogg");
				addSound("random/holystone3", "/assets/Chisel/sounds/holystone-3.ogg");
				addSound("random/holystone5", "/assets/Chisel/sounds/holystone-5.ogg");
				addSound("random/holystone7", "/assets/Chisel/sounds/holystone-7.ogg");
				*/
				addSound("step/holystone1", "/assets/Chisel/sounds/holystone-1.ogg");
				addSound("step/holystone2", "/assets/Chisel/sounds/holystone-2.ogg");
				addSound("step/holystone3", "/assets/Chisel/sounds/holystone-3.ogg");
				addSound("step/holystone5", "/assets/Chisel/sounds/holystone-5.ogg");
				addSound("step/holystone7", "/assets/Chisel/sounds/holystone-7.ogg");
				addSound("dig/holystone1", "/assets/Chisel/sounds/holystone-1.ogg");
				addSound("dig/holystone2", "/assets/Chisel/sounds/holystone-2.ogg");
				addSound("dig/holystone3", "/assets/Chisel/sounds/holystone-3.ogg");
				addSound("dig/holystone5", "/assets/Chisel/sounds/holystone-5.ogg");
				addSound("dig/holystone7", "/assets/Chisel/sounds/holystone-7.ogg");
			}
		});
	}

	@Override
	public void init() {
		RenderingRegistry.registerBlockHandler(new BlockMarbleStairsRenderer());
		RenderingRegistry.registerBlockHandler(new BlockMarblePaneRenderer());
		RenderingRegistry.registerBlockHandler(new BlockRoadLineRenderer());
		RenderingRegistry.registerBlockHandler(new BlockSnakeStoneRenderer());
		RenderingRegistry.registerBlockHandler(new BlockNoCTMRenderer());
		RenderingRegistry.registerBlockHandler(new BlockSpikesRenderer());
		RenderingRegistry.registerBlockHandler(new BlockMarblePillarRenderer());
		
		RenderingRegistry.registerBlockHandler(new BlockTexturedOreRenderer());

		RenderingRegistry.registerEntityRenderingHandler(EntityCloudInABottle.class, new RenderSnowball(Chisel.itemCloudInABottle));

		MinecraftForgeClient.registerItemRenderer(Chisel.chisel.itemID, renderer);

	}
}
