/**
 * Block class for the statue
 */

package info.jbcs.minecraft.statues;

import java.util.Random;

import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockStatue extends BlockContainer {
	public BlockStatue(int i, Material material) {
		super(i, material);
	}

    @Override
	public int quantityDropped(Random par1Random){
        return 0;
    }

	@Override
	public boolean isOpaqueCube() {
		return false;
	}

	@Override
	public boolean renderAsNormalBlock() {
		return false;
	}
	
	@Override
	public int getRenderType() {
		return -1;
	}
	
    @Override
	public void setBlockBoundsBasedOnState(IBlockAccess world, int x, int y, int z){
    	int meta=world.getBlockMetadata(x, y, z);
    	
    	if((meta&4)==0){
    		setBlockBounds(0.2F, 0F, 0.2F, 0.8F, 2F, 0.8F);
    	} else{
    		setBlockBounds(0.2F, -1F, 0.2F, 0.8F, 1F, 0.8F);
    	}
    }
    
	
	@Override
	public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer entityplayer, int par6, float par7, float par8, float par9) {
		if(world.isRemote) return true;
   	
    	if((world.getBlockMetadata(x, y, z)&4)!=0)
    		y--;
		
		TileEntityStatue statue = (TileEntityStatue) world.getBlockTileEntity(x, y, z);
		if (statue instanceof TileEntityStatue)
			Statues.guiStatue.open(entityplayer, world, x, y, z);
		
		return true;
	}
	
	@Override
	public void breakBlock(World world, int x, int y, int z, int id, int meta) {
		if((meta&4)==0){
			world.setBlock(x,y+1,z,0);
			TileEntity tile = world.getBlockTileEntity(x, y, z);
			if(tile instanceof TileEntityStatue) ((TileEntityStatue)tile).inventory.throwItems(world, x, y, z);
		} else{
			world.setBlock(x,y-1,z,0);
		}
		super.breakBlock(world, x, y, z, id, meta);
	}

	@Override
	public TileEntity createNewTileEntity(World var1) {
		return new TileEntityStatue();
	}
	
	
    @Override
	public Icon getIcon(int side, int meta){
        return Block.stone.getIcon(0,0);
    }

}
