package info.jbcs.minecraft.statues;

import java.awt.image.BufferedImage;
import java.io.IOException;

import javax.imageio.ImageIO;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureObject;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.ResourceManager;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.world.World;

public class EntityFakePlayer extends AbstractClientPlayer {
	static ResourceLocation emptySkin=new ResourceLocation("statues:textures/steve.png");
	static ResourceLocation emptyCape=new ResourceLocation("statues:textures/cape.png");
	static ThreadDownloadImageData dataEmptySkin=getDownloadImageSkin(emptySkin,"");
	static ThreadDownloadImageData dataEmptyCape=getDownloadImageCape(emptyCape,"");
	String					skinName	= "";
	ResourceLocation		skin;
	ThreadDownloadImageData	dataSkin;
	
	StatueParameters pose;
	
	class ThreadDownloadLocalImageData extends ThreadDownloadImageData{
		BufferedImage image;
		IImageBuffer effect;
		ResourceLocation base;
		
		public ThreadDownloadLocalImageData(String par1Str, ResourceLocation b, IImageBuffer e) {
			super(par1Str, b, e);
			effect=e;
			base=b;
		}
	
		@Override
		public void loadTexture(ResourceManager resourcemanager) throws IOException {
			BufferedImage origImage=ImageIO.read(resourcemanager.getResource(base).getInputStream());
			image=effect.parseUserSkin(origImage);
		}
	
		@Override
		public int getGlTextureId() {
	        if(glTextureId == -1){
	            glTextureId = TextureUtil.glGenTextures();
	        }
	
	        TextureUtil.uploadTextureImage(glTextureId, image);
	
	        return glTextureId;
		}
	};

	
	public EntityFakePlayer(World world, String username) {
		super(world, username);
	}

	@Override
	public void sendChatToPlayer(ChatMessageComponent chatmessagecomponent) {

	}

	@Override
	public boolean canCommandSenderUseCommand(int i, String s) {
		return false;
	}

	@Override
	public ChunkCoordinates getPlayerCoordinates() {
		return null;
	}

	public void applySkin(String name,Block block,int side,int meta) {
		ResourceLocation steveSkin = new ResourceLocation("statues:textures/steve.png|B"+block.blockID+","+side+","+meta);
		ThreadDownloadLocalImageData steveDataSkin = getDataForSteve(steveSkin,new ResourceLocation("statues:textures/steve.png"),block,side,meta);;
		if (name != null && !name.isEmpty()) {
			skin=new ResourceLocation("skins/" + StringUtils.stripControlCodes(name)+"|B"+block.blockID+","+side+","+meta);
			dataSkin = getDataForSkin(skin,steveDataSkin,name,block,side,meta);
		} else{
			skin = steveSkin;
			dataSkin = steveDataSkin;
		}
	}

    @Override
	protected void setupCustomSkin(){
    }


	@Override
	public ThreadDownloadImageData getTextureSkin() {
		return dataSkin;
	}

	@Override
	public ThreadDownloadImageData getTextureCape() {
		return dataEmptyCape;
	}

	@Override
	public ResourceLocation getLocationSkin() {
		return skin;
	}

	@Override
	public ResourceLocation getLocationCape() {
		return emptyCape;
	}

	public ThreadDownloadImageData getDataForSkin(ResourceLocation skin, final ThreadDownloadLocalImageData fallbackSkin, String name, Block block, int side, int meta) {
    	TextureManager texturemanager = Minecraft.getMinecraft().getTextureManager();
        Object object = texturemanager.getTexture(skin);
        
        if (object == null){
        	final ImageStatueBufferDownload effect=new ImageStatueBufferDownload(this,block,side,meta);
	        object = new ThreadDownloadImageData(getSkinUrl(name), emptySkin, new ImageStatueBufferDownload(this,block,side,meta)){
	        	@Override
				public void loadTexture(ResourceManager manager) throws IOException{
	        		super.loadTexture(manager);
	        		
	                TextureUtil.uploadTextureImageAllocate(glTextureId, fallbackSkin.image, false, false);
		        }
	        };
	        texturemanager.loadTexture(skin, (TextureObject)object);
        }
        
    	return (ThreadDownloadImageData)object;
	}

	public ThreadDownloadLocalImageData getDataForSteve(ResourceLocation skin, final ResourceLocation base, Block block, int side, int meta) {
    	TextureManager texturemanager = Minecraft.getMinecraft().getTextureManager();
        Object object = texturemanager.getTexture(skin);
        
        if (object == null){
        	final ImageStatueBufferDownload effect=new ImageStatueBufferDownload(this,block,side,meta);
        	object = new ThreadDownloadLocalImageData("",base,effect);
	        texturemanager.loadTexture(skin, (ThreadDownloadLocalImageData)object);
        }
        
    	return (ThreadDownloadLocalImageData)object;
	}

    
}
