/**
 * GUI class for the basic GUI of the statue
 */

package info.jbcs.minecraft.statues;

import info.jbcs.minecraft.utilities.GeneralClient;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.world.World;

import org.lwjgl.opengl.GL11;

public class GuiStatue extends GuiContainer {
	public final InventoryPlayer	invg;
	public final TileEntityStatue	tile;

	public GuiStatue(InventoryPlayer inv, TileEntityStatue testatue, World par2, int i, int j, int k) {
		super(new ContainerStatue(inv, testatue));
		invg = inv;
		tile = testatue;
		xSize = 176;
		ySize = 226;
	}

	/**
	 * Draw the background layer for the GuiContainer (everything behind the
	 * items)
	 */
	@Override
	protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {
		GeneralClient.bind("statues:textures/gui-statue.png");
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		int w = (width - xSize) / 2;
		int h = (height - ySize) / 2;
		drawTexturedModalRect(w, h, 0, 0, xSize, ySize);
	}
}
