/**
 * Item Class for the hammer
 */

package info.jbcs.minecraft.statues;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemMarteau extends Item {
	public ItemMarteau(int par1) {
		super(par1);
		maxStackSize = 1;
		this.setCreativeTab(CreativeTabs.tabTools);
	}

	@Override
	public boolean isFull3D() {
		return true;
	}

	@Override
	public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hx, float hy, float hz) {
		int id=world.getBlockId(x,y,z);
		if(! Statues.canSculpt(id))
			return false;
		int meta=world.getBlockMetadata(x,y,z);
		
		if(id==world.getBlockId(x,y+1,z) && meta==world.getBlockMetadata(x,y+1,z)){
			Statues.guiSculpt.open(player, world, x, y, z);
			return true;
		}
		
		if(id==world.getBlockId(x,y-1,z) && meta==world.getBlockMetadata(x,y-1,z)){
			Statues.guiSculpt.open(player, world, x, y-1, z);
			return true;
		}
		
		return true;
	}

}