package info.jbcs.minecraft.statues;

import info.jbcs.minecraft.statues.utilities.GeneralStatueClient;
import info.jbcs.minecraft.utilities.General;
import info.jbcs.minecraft.utilities.packets.PacketData;
import info.jbcs.minecraft.utilities.packets.PacketHandler;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.packet.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.tileentity.TileEntity;

public class Packets {

	static PacketHandler sculpt = new PacketHandler("Sculpture creation packet") {
		@Override
		public void onData(DataInputStream stream, EntityPlayer player) throws IOException {
			if (player.inventory.getCurrentItem() == null || player.inventory.getCurrentItem().itemID != Statues.hammer.itemID)
				return;

			final int x = stream.readInt();
			final int y = stream.readInt();
			final int z = stream.readInt();
			int face = stream.readByte();
			
			final int id=player.worldObj.getBlockId(x,y,z);
			if(! Statues.canSculpt(id)) return;

			final int meta=player.worldObj.getBlockMetadata(x,y,z);
			if(id!=player.worldObj.getBlockId(x,y+1,z) || meta !=player.worldObj.getBlockMetadata(x,y+1,z)) return;
			
			player.worldObj.setBlock(x, y+1, z, Statues.statue.blockID, face|4,3);
			player.worldObj.setBlock(x, y, z, Statues.statue.blockID,face,3);
			
			TileEntity tileEntity = player.worldObj.getBlockTileEntity(x, y, z);
			if (!(tileEntity instanceof TileEntityStatue))
				return;
			TileEntityStatue entity = (TileEntityStatue) tileEntity;

			entity.pose.read(stream);
			entity.skinName=Packet.readString(stream, 16);
			entity.block=General.getBlock(id);
			entity.meta=meta;
			entity.facing=2;
			
			player.worldObj.markBlockForUpdate(x, y, z);
			
			ServerConfigurationManager mgr = MinecraftServer.getServer().getConfigurationManager();
			for (int j = 0; j < mgr.playerEntityList.size(); ++j) {
				EntityPlayerMP p = (EntityPlayerMP) mgr.playerEntityList.get(j);

				if (p.dimension != player.dimension) continue;
				if (! General.isInRange(30.0f, p.posX, p.posY, p.posZ, x, y, z)) continue;

				sculpted.sendToPlayer(p,new PacketData(){
					@Override
					public void data(DataOutputStream stream) throws IOException {
						stream.writeInt(x);
						stream.writeInt(y);
						stream.writeInt(z);
						stream.writeShort(id);
						stream.writeByte(meta);
					}
				});
			}

		}
	};

	static PacketHandler sculpted = new PacketHandler("A block has been sculpted") {
		@Override
		public void onData(DataInputStream stream, EntityPlayer player) throws IOException {
			final int x=stream.readInt();
			final int y=stream.readInt();
			final int z=stream.readInt();
			final short id=stream.readShort();
			final byte meta=stream.readByte();
			
			GeneralStatueClient.spawnSculptEffect(x, y, z, id, meta);
			GeneralStatueClient.spawnSculptEffect(x, y+1, z, id, meta);
		}
	};

}
