package info.jbcs.minecraft.statues;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import net.minecraft.nbt.NBTTagCompound;

public class StatueParameters {
	float armLeftA;
	float armLeftB;
	float armRightA;
	float armRightB;
	float legLeftA;
	float legLeftB;
	float legRightA;
	float legRightB;
	float headA;
	float headB;
	float bodyA;
	float bodyB;
	
	StatueParameters(){
		armLeftA=2.0f/3;
		armRightA=2.0f/3;
		
		legLeftA=1.0f;
		legLeftB=0.5f;
		legRightA=1.0f;
		legRightB=0.5f;
		
		headA=0.5f;
		headB=0.5f;
		bodyA=0.5f;
		bodyB=0.5f;
	}

	void write(DataOutputStream stream) throws IOException{
		stream.writeFloat(armLeftA);
		stream.writeFloat(armLeftB);
		stream.writeFloat(armRightA);
		stream.writeFloat(armRightB);
		stream.writeFloat(legLeftA);
		stream.writeFloat(legLeftB);
		stream.writeFloat(legRightA);
		stream.writeFloat(legRightB);
		stream.writeFloat(headA);
		stream.writeFloat(headB);
		stream.writeFloat(bodyA);
		stream.writeFloat(bodyB);		
	}
	
	void read(DataInputStream stream) throws IOException{
		armLeftA=stream.readFloat();
		armLeftB=stream.readFloat();
		armRightA=stream.readFloat();
		armRightB=stream.readFloat();
		legLeftA=stream.readFloat();
		legLeftB=stream.readFloat();
		legRightA=stream.readFloat();
		legRightB=stream.readFloat();
		headA=stream.readFloat();
		headB=stream.readFloat();
		bodyA=stream.readFloat();
		bodyB=stream.readFloat();				
	}

	public void readFromNBT(NBTTagCompound tag) {
		if(!tag.hasKey("ala")) return;
		
		armLeftA=tag.getFloat("ala");
		armLeftB=tag.getFloat("alb");
		armRightA=tag.getFloat("ara");
		armRightB=tag.getFloat("arb");
		legLeftA=tag.getFloat("lla");
		legLeftB=tag.getFloat("llb");
		legRightA=tag.getFloat("lra");
		legRightB=tag.getFloat("lrb");
		headA=tag.getFloat("ha");
		headB=tag.getFloat("hb");
		bodyA=tag.getFloat("ba");
		bodyB=tag.getFloat("bb");			
	}

	public void writeToNBT(NBTTagCompound tag) {
		tag.setFloat("ala",armLeftA);
		tag.setFloat("alb",armLeftB);
		tag.setFloat("ara",armRightA);
		tag.setFloat("arb",armRightB);
		tag.setFloat("lla",legLeftA);
		tag.setFloat("llb",legLeftB);
		tag.setFloat("lra",legRightA);
		tag.setFloat("lrb",legRightB);
		tag.setFloat("ha",headA);
		tag.setFloat("hb",headB);
		tag.setFloat("ba",bodyA);
		tag.setFloat("bb",bodyB);					
	}
	
	
}
