package info.jbcs.minecraft.statues;


import info.jbcs.minecraft.utilities.General;
import info.jbcs.minecraft.utilities.GuiHandler;
import info.jbcs.minecraft.utilities.packets.PacketHandler;

import java.io.File;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.src.ModLoader;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.Instance;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(modid = "Statues", name = "Statues", version = "2.0.2")
@NetworkMod(clientSideRequired = true, serverSideRequired = true, channels={ PacketHandler.channel }, packetHandler = Statues.class)
public class Statues implements IPacketHandler{
	static Configuration				config;

	@Instance("Statues")
	public static Statues instance;

	@SidedProxy(clientSide = "info.jbcs.minecraft.statues.ProxyClient", serverSide = "info.jbcs.minecraft.statues.Proxy")
	public static Proxy proxy;

	public static Block			statue;
	public static Block			showcase;
	public static Item			hammer;
	public static Item			itemStatue;
	public static Item			itemShowcase;

	public static Icon					slotHand;
	
	public static GuiHandler	guiShowcase;
	public static GuiHandler	guiStatue;
	public static GuiHandler	guiSculpt;
	
/*	static Block blocksAllowedForSculpting[]={
		Block.stone, Block.dirt, Block.cobblestone, Block.planks, 
		Block.sand, Block.gravel, Block.wood,
		Block.sponge, Block.coalBlock, Block.sandStone, Block.cloth, 
		Block.blockGold, Block.blockIron, Block.brick, Block.stoneDoubleSlab, 
		Block.cobblestoneMossy, Block.obsidian, Block.blockDiamond, Block.blockSnow, 
		Block.cactus, Block.blockClay, Block.pumpkin, Block.netherrack, 
		Block.slowSand, Block.glowStone, Block.netherBrick, Block.whiteStone, 
		Block.blockEmerald, Block.blockRedstone, Block.stainedClay, Block.hay, 
		Block.hardenedClay,
	};
	static HashMap<Integer,Integer> blocksAllowedForSculptingMap=new HashMap<Integer,Integer>();
*/
	@PreInit
	public void preInit(FMLPreInitializationEvent event) {
		File configFile=event.getSuggestedConfigurationFile();
		config = new Configuration(configFile);
		config.load();
		
		proxy.preInit();
 	}
	
	int getBlock(String name,int id){
		return config.getBlock(name, id).getInt(id);
	}
	
	int getItem(String name,int id){
		return config.getItem(name, id).getInt(id);
	}
	@Init
	public void init(FMLInitializationEvent event) {
		statue				= new BlockStatue(getBlock("statue",1500), Material.rock).setHardness(1F).setResistance(1F).setUnlocalizedName("statue").setStepSound(Block.soundStoneFootstep);
		showcase			= new BlockShowcase(getBlock("showcase",1501), Material.wood).setHardness(1F).setResistance(1F).setUnlocalizedName("showcase").setStepSound(Block.soundWoodFootstep);
		hammer				= new ItemMarteau(getItem("marteau",5002)).setTextureName("statues:marteau").setUnlocalizedName("marteau");
		itemShowcase		= new ItemShowcase(getItem("itemshowcase",5004), showcase).setTextureName("statues:itemshowcase").setUnlocalizedName("itemshowcase");
		
		LanguageRegistry.addName(statue, "Statue");
		LanguageRegistry.addName(showcase, "Showcase");
		LanguageRegistry.addName(itemShowcase, "Showcase");
		
		LanguageRegistry.addName(hammer, "Hammer");
		
        GameRegistry.registerTileEntity(TileEntityStatue.class, "TileEntityStatue");
        GameRegistry.registerTileEntity(TileEntityShowcase.class, "TileEntityShowcase");
        
		ModLoader.addRecipe(new ItemStack(hammer, 1), new Object[] { " I ", " SI", "S  ", Character.valueOf('S'), Item.stick, Character.valueOf('I'), Item.ingotIron });
		ModLoader.addRecipe(new ItemStack(itemShowcase, 1), new Object[] { "GGG", "W W", "S S", Character.valueOf('S'), Item.stick, Character.valueOf('W'), Block.wood, Character.valueOf('G'), Block.thinGlass});

		MinecraftForge.setBlockHarvestLevel(showcase, "axe", 0);
        /*
		for(int i=0;i<blocksAllowedForSculpting.length;i++){
			blocksAllowedForSculptingMap.put(blocksAllowedForSculpting[i].blockID,1);
		}*/
		
        guiShowcase=new GuiHandler("showcase"){
			@Override
			public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
		        TileEntity tileEntity = world.getBlockTileEntity(x, y, z);

		        if(! (tileEntity instanceof TileEntityShowcase))
		        	return null;
		        
		        TileEntityShowcase e=(TileEntityShowcase) tileEntity;
		        
		        return new ContainerShowcase(player.inventory, e);
			}

			@Override
			public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
                TileEntity tileEntity = world.getBlockTileEntity(x, y, z);

		        if(! (tileEntity instanceof TileEntityShowcase))
		        	return null;
		        
		        TileEntityShowcase e=(TileEntityShowcase) tileEntity;

                return new GuiShowcase(player.inventory,e,world,x,y,z);
			}
		};
        
        guiStatue=new GuiHandler("statue"){
			@Override
			public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
		        TileEntity tileEntity = world.getBlockTileEntity(x, y, z);

		        if(! (tileEntity instanceof TileEntityStatue))
		        	return null;
		        
		        TileEntityStatue e=(TileEntityStatue) tileEntity;
		        
		        return new ContainerStatue(player.inventory, e);
			}

			@Override
			public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
                TileEntity tileEntity = world.getBlockTileEntity(x, y, z);

		        if(! (tileEntity instanceof TileEntityStatue))
		        	return null;
		        
		        TileEntityStatue e=(TileEntityStatue) tileEntity;

                return new GuiStatue(player.inventory,e,world,x,y,z);
			}
		};
		
		guiSculpt=new GuiHandler("sculpt"){
			@Override
			public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
		        return new DummyContainer();
			}

			@Override
			public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
				int face = MathHelper.floor_double((player.rotationYaw * 4F) / 360F + 0.5D) & 3;

                return new GuiSculpt(world,x,y,z,player,face);
			}
		};

		GuiHandler.register(this);
        
		Packets.sculpt.create();
		Packets.sculpted.create();
		PacketHandler.register(this);
		
        proxy.init();
	}
	

	@Override
	public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player player) {
        PacketHandler.onPacketData(manager,packet,(EntityPlayer)player);
	}

	public static boolean canSculpt(int id) {
		Block block=General.getBlock(id);
		if(block==null) return false;
		
		return block.isOpaqueCube();
	}
	
}