/**
 * TileEntity class of the statue
 */

package info.jbcs.minecraft.statues;

import info.jbcs.minecraft.statues.utilities.InventoryStatic;
import info.jbcs.minecraft.utilities.General;

import java.util.Random;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;

public class TileEntityStatue extends TileEntity implements IInventory {
	String		skinName="";
	StatueParameters pose=new StatueParameters();
	
	Block	block=Block.stone;
	int		meta=0;
	int		facing=0;
	
	InventoryStatic inventory = new InventoryStatic(36) {
		@Override
		public String getInvName() {
			return "Statue";
		}
		
		@Override
		public boolean isUseableByPlayer(EntityPlayer entityplayer) {
			if (worldObj.getBlockTileEntity(xCoord, yCoord, zCoord) != TileEntityStatue.this) {
				return false;
			} else {
				return entityplayer.getDistanceSq(xCoord + 0.5D, yCoord + 0.5D, zCoord + 0.5D) <= 64D;
			}
		}
	};

	void randomize(Random rand){
	}

	@Override
	public int getSizeInventory() {
		return inventory.getSizeInventory();
	}

	@Override
	public ItemStack getStackInSlot(int i) {
		return inventory.getStackInSlot(i);
	}

	@Override
	public ItemStack decrStackSize(int i, int j) {
		return inventory.decrStackSize(i, j);
	}

	@Override
	public void setInventorySlotContents(int i, ItemStack itemstack) {
		inventory.setInventorySlotContents(i, itemstack);
	}

	@Override
	public String getInvName() {
		return inventory.getInvName();
	}

	@Override
	public int getInventoryStackLimit() {
		return inventory.getInventoryStackLimit();
	}

	@Override
	public boolean isUseableByPlayer(EntityPlayer entityplayer) {
		return inventory.isUseableByPlayer(entityplayer);
	}

	@Override
	public void readFromNBT(NBTTagCompound nbttagcompound) {
		super.readFromNBT(nbttagcompound);

		if(nbttagcompound.hasKey("items")){
			inventory.clear();
			inventory.readFromNBT(nbttagcompound);
		}

		skinName = nbttagcompound.getString("skin");
		pose.readFromNBT(nbttagcompound);
		
		block=General.getBlock(nbttagcompound.getShort("blockId"));
		if(block==null) block=Block.stone;
		meta=nbttagcompound.getByte("meta");
		facing=nbttagcompound.getByte("face");

	}

	@Override
	public void writeToNBT(NBTTagCompound nbttagcompound) {
		super.writeToNBT(nbttagcompound);
		
		inventory.writeToNBT(nbttagcompound);
		nbttagcompound.setString("skin", skinName);
		pose.writeToNBT(nbttagcompound);
		
		nbttagcompound.setShort("blockId",(short)block.blockID);
		nbttagcompound.setByte("meta",(byte)meta);
		nbttagcompound.setByte("face",(byte)facing);
	}

	@Override
	public void onInventoryChanged() {
		worldObj.markBlockForUpdate(xCoord, yCoord, zCoord);
	}

	@Override
	public void openChest() {

	}

	@Override
	public void closeChest() {

	}

	@Override
	public boolean isInvNameLocalized() {
		return false;
	}

	@Override
	public boolean isItemValidForSlot(int i, ItemStack itemstack) {
		return true;
	}

	@Override
	public Packet getDescriptionPacket() {
		if ((worldObj.getBlockMetadata(xCoord, yCoord, zCoord) & 4) != 0)
			return null;

		NBTTagCompound tag = new NBTTagCompound();
		writeToNBT(tag);
		return new Packet132TileEntityData(xCoord, yCoord, zCoord, 1, tag);
	}

	@Override
	public void onDataPacket(INetworkManager net, Packet132TileEntityData pkt) {
		readFromNBT(pkt.data);
	}

	@Override
	public ItemStack getStackInSlotOnClosing(int i) {
		return null;
	}

}