package info.jbcs.minecraft.statues.utilities;

import info.jbcs.minecraft.utilities.General;

import java.util.Random;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class GeneralStatueClient {
	static Random rand=new Random();
	
	public static EntityDiggingFX addBlockHitEffects(World world, int x, int y, int z, int id, int meta, int side) {
		EffectRenderer renderer = Minecraft.getMinecraft().effectRenderer;

		Block block = General.getBlock(id);
		if(block==null) return null;
		
		float f = 0.1F;
		double d0 = x + rand.nextDouble() * (block.getBlockBoundsMaxX() - block.getBlockBoundsMinX() - f * 2.0F) + f + block.getBlockBoundsMinX();
		double d1 = y + rand.nextDouble() * (block.getBlockBoundsMaxY() - block.getBlockBoundsMinY() - f * 2.0F) + f + block.getBlockBoundsMinY();
		double d2 = z + rand.nextDouble() * (block.getBlockBoundsMaxZ() - block.getBlockBoundsMinZ() - f * 2.0F) + f + block.getBlockBoundsMinZ();

		switch (side) {
		case 0:
			d1 = y + block.getBlockBoundsMinY() - f;
			break;
		case 1:
			d1 = y + block.getBlockBoundsMaxY() + f;
			break;
		case 2:
			d2 = z + block.getBlockBoundsMinZ() - f;
			break;
		case 3:
			d2 = z + block.getBlockBoundsMaxZ() + f;
			break;
		case 4:
			d0 = x + block.getBlockBoundsMinX() - f;
			break;
		case 5:
			d0 = x + block.getBlockBoundsMaxX() + f;
			break;
		}

		EntityDiggingFX res = new EntityDiggingFX(world, d0, d1, d2, 0.0D, 0.0D, 0.0D, block, meta, side);
		res.motionX = d0 - (x + 0.5);
		res.motionY = d1 - (y + 0.5);
		res.motionZ = d2 - (z + 0.5);

		renderer.addEffect(res);

		return res;
	}

	public static void spawnSculptEffect(int x, int y, int z, short id, byte meta) {
		Block block = General.getBlock(id);
		if(block==null) return;
		
		World world = Minecraft.getMinecraft().theWorld;
		for (int side = 0; side < 6; side++) {
			for (int j = 0; j < 32; j++) {
				EntityDiggingFX fx = addBlockHitEffects(Minecraft.getMinecraft().theWorld, x, y, z, id, meta, side);
				if(fx==null) return;
				
				fx.multipleParticleScaleBy(0.25f + 0.5f * rand.nextFloat());
				fx.multiplyVelocity(0.3f * rand.nextFloat());
			}
		}

		Minecraft.getMinecraft().theWorld.playSound(x + 0.5, y + 0.5, z + 0.5, block.stepSound.getBreakSound(), 1.0f, 0.6f + 0.4f * rand.nextFloat(), true);
	}
	
	public static ResourceLocation getBlockIcon(Block block, int side, int meta) {
		String textureName=block.getIcon(side,meta).getIconName();
		String domain="";
		int index=textureName.indexOf(":"); if(index!=-1){
			domain=textureName.substring(0,index+1).toLowerCase();
			textureName=textureName.substring(index+1);
		}
		return new ResourceLocation(domain+"textures/blocks/"+textureName+".png");
	}


}
