/*
 * Decompiled with CFR 0.152.
 */
package panoramakit.converter;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import panoramakit.converter.Interpolator;
import panoramakit.converter.PositionMapper;
import panoramakit.converter.data.Bounds;
import panoramakit.converter.data.ColorData;
import panoramakit.converter.data.PixelCoordinate;
import panoramakit.converter.data.Position;
import panoramakit.converter.interpolators.BilinearInterpolator;
import panoramakit.engine.render.ImageLink;
import panoramakit.engine.util.ProgressTracker;
import panoramakit.mod.PanoramaKit;

public class ProjectionConverter {
    private final Logger L;
    private PositionMapper positionMapper;
    private Interpolator interpolator;
    private File imageFileInput;
    private File imageFileOutput;
    private BufferedImage inputImage;
    private BufferedImage outputImage;
    private ProgressTracker progressTracker;
    private ImageLink imageLink;
    private boolean stop;

    public ProjectionConverter(PositionMapper positionMapper, File imageFileInput, File imageFileOutput) {
        this.L = PanoramaKit.instance.L;
        this.stop = false;
        this.positionMapper = positionMapper;
        this.imageFileInput = imageFileInput;
        this.imageFileOutput = imageFileOutput;
        this.setInterpolator(new BilinearInterpolator());
    }

    public ProjectionConverter(PositionMapper positionMapper, File imageFileOverwrite) {
        this(positionMapper, imageFileOverwrite, imageFileOverwrite);
    }

    public void setImageLink(ImageLink imageLink) {
        this.imageLink = imageLink;
    }

    public void setInterpolator(Interpolator interpolator) {
        this.interpolator = interpolator;
    }

    private void loadImage(File imageFile) throws IOException, IllegalArgumentException {
        this.inputImage = this.imageLink != null && this.imageLink.getImage() != null ? this.imageLink.getImage() : ImageIO.read(imageFile);
        int width = this.inputImage.getWidth();
        int height = this.inputImage.getHeight();
        this.positionMapper.setResolution(width, height);
        this.positionMapper.setProjectionBounds();
        if (!this.positionMapper.hasValidProportions()) {
            throw new IllegalArgumentException("Image has bad proportions");
        }
        this.outputImage = new BufferedImage(this.positionMapper.getWidth(), this.positionMapper.getHeight(), this.inputImage.getType());
    }

    private void saveImage(File imageFile) throws IOException {
        if (!imageFile.exists()) {
            imageFile.mkdirs();
            imageFile.createNewFile();
        }
        ImageIO.write((RenderedImage)this.outputImage, "png", imageFile);
    }

    public void convert() throws IOException, IllegalArgumentException, InterruptedException {
        this.L.info("Converting...");
        long startTime = System.currentTimeMillis();
        this.loadImage(this.imageFileInput);
        int xOutput = 0;
        while (xOutput < this.outputImage.getWidth()) {
            if (this.stop) {
                throw new InterruptedException();
            }
            double progress = (double)xOutput / (double)this.outputImage.getWidth();
            if (this.progressTracker != null) {
                this.progressTracker.setCurrentProgress(progress);
            }
            int yOutput = 0;
            while (yOutput < this.outputImage.getHeight()) {
                Position position = this.positionMapper.getPosition(xOutput, yOutput);
                if (position == null) {
                    this.outputImage.setRGB(xOutput, yOutput, 0);
                } else {
                    double xFraction = position.getXFraction();
                    double yFraction = position.getYFraction();
                    PixelCoordinate[][] pixelData = this.positionMapper.getPixelCoordinates(position, this.inputImage.getWidth(), this.inputImage.getHeight(), this.interpolator.sampleSize);
                    ColorData[][] pixels = new ColorData[pixelData.length][pixelData.length];
                    int i = 0;
                    while (i < pixels.length) {
                        int j = 0;
                        while (j < pixels.length) {
                            Bounds edge = this.positionMapper.getPixelSampler().edge;
                            int x = edge.getCappedX(pixelData[i][j].x);
                            int y = edge.getCappedY(pixelData[i][j].y);
                            int pixel = this.inputImage.getRGB(x, y);
                            pixels[i][j] = new ColorData(pixel);
                            ++j;
                        }
                        ++i;
                    }
                    int pixelValue = this.interpolator.getPixelValue(xFraction, yFraction, pixels);
                    this.outputImage.setRGB(xOutput, yOutput, pixelValue);
                }
                ++yOutput;
            }
            ++xOutput;
        }
        this.saveImage(this.imageFileOutput);
        this.L.info("Projection \"" + this.positionMapper.getClass().getSimpleName() + "\": " + (System.currentTimeMillis() - startTime) + "ms");
        this.L.info("Done");
    }

    public void setProgressTracker(ProgressTracker progressTracker) {
        this.progressTracker = progressTracker;
    }

    public void stop() {
        this.stop = true;
    }

    public String getImageName() {
        return this.imageFileOutput.getName();
    }
}

