/*
 * Decompiled with CFR 0.152.
 */
package panoramakit.converter.interpolators;

import panoramakit.converter.Interpolator;
import panoramakit.converter.data.ColorData;
import panoramakit.converter.interpolators.BicubicInterpolation;

public class BicubicInterpolator
extends Interpolator {
    public BicubicInterpolator() {
        super(4);
    }

    @Override
    public int getPixelValue(double xFraction, double yFraction, ColorData[][] pixels) {
        double[] colorChannelData = new double[4];
        int colorChannel = 0;
        while (colorChannel < 4) {
            double[][] componentColorChannels = this.getColorChannelData(pixels, colorChannel);
            colorChannelData[colorChannel] = new BicubicInterpolation().getValue(componentColorChannels, xFraction, yFraction);
            ++colorChannel;
        }
        ColorData outputPixel = new ColorData(colorChannelData);
        return outputPixel.getIntValue();
    }

    public double[][] getColorChannelData(ColorData[][] pixels, int colorChannel) {
        double[][] colorChannels = new double[pixels.length][pixels.length];
        int x = 0;
        while (x < pixels.length) {
            int y = 0;
            while (y < pixels.length) {
                colorChannels[x][y] = pixels[x][y].colorChannels[colorChannel];
                ++y;
            }
            ++x;
        }
        return colorChannels;
    }
}

