/*
 * Decompiled with CFR 0.152.
 */
package panoramakit.converter.projections;

import panoramakit.converter.PositionMapper;
import panoramakit.converter.data.Position;
import panoramakit.converter.samplers.FlatSampler;

public class EquirectToCylindrical
extends PositionMapper {
    public boolean customResolution = true;
    public int newWidth;
    public int newHeight;

    public EquirectToCylindrical(PositionMapper preProjection, int newWidth, int newHeight) {
        super(preProjection, new FlatSampler());
        this.newWidth = newWidth;
        this.newHeight = newHeight;
    }

    public EquirectToCylindrical(PositionMapper preProjection) {
        this(preProjection, 0, 0);
        this.customResolution = false;
    }

    public EquirectToCylindrical(int newWidth, int newHeight) {
        this(null, newWidth, newHeight);
    }

    public EquirectToCylindrical() {
        this(null, 0, 0);
        this.customResolution = false;
    }

    @Override
    public int getNewWidth(int width, int height) {
        if (this.customResolution) {
            return this.newWidth;
        }
        return width;
    }

    @Override
    public int getNewHeight(int width, int height) {
        if (this.customResolution) {
            return this.newHeight;
        }
        return height;
    }

    @Override
    public boolean testValidProportions() {
        return true;
    }

    @Override
    public Position getProjectedPosition(double x, double y) {
        x += 0.5;
        double scale = (double)this.inputWidth / (double)this.outputWidth;
        double centeredScaledY = ((y += 0.5) - (double)(this.outputHeight / 2)) * scale;
        double radius = (double)this.inputHeight / Math.PI;
        double angle = Math.atan(centeredScaledY / radius);
        double relativeY = (double)this.inputHeight * (angle / Math.PI);
        y = relativeY + (double)(this.inputHeight / 2);
        x *= scale;
        return new Position(x -= 0.5, y -= 0.5);
    }
}

