/*
 * Decompiled with CFR 0.152.
 */
package panoramakit.converter.projections;

import panoramakit.converter.PositionMapper;
import panoramakit.converter.data.Position;
import panoramakit.converter.samplers.FlatSampler;

public class EquirectToPolar
extends PositionMapper {
    public static final boolean PLANET = true;
    public static final boolean WELL = false;
    public boolean invert;

    public EquirectToPolar(PositionMapper preProjection, boolean type) {
        super(preProjection, new FlatSampler());
        this.invert = type;
    }

    public EquirectToPolar(boolean type) {
        this(null, type);
    }

    @Override
    public int getNewWidth(int width, int height) {
        return width;
    }

    @Override
    public int getNewHeight(int width, int height) {
        return width;
    }

    @Override
    public boolean testValidProportions() {
        if (this.inputWidth % 2 != 0) {
            return false;
        }
        return this.inputWidth / 2 == this.inputHeight / 1;
    }

    @Override
    public Position getProjectedPosition(double x, double y) {
        x += 0.5;
        y += 0.5;
        double angle = Math.atan2(y -= (double)(this.outputHeight / 2), x -= (double)(this.outputWidth / 2));
        double radius = Math.abs(x) > Math.abs(y) ? x / Math.cos(angle) : y / Math.sin(angle);
        double relativeX = (double)this.inputWidth * (angle / (Math.PI * 2));
        double xOut = relativeX + (double)(this.inputWidth / 2);
        double yOut = radius;
        if (yOut - 0.5 > (double)this.inputHeight) {
            return null;
        }
        if (this.invert) {
            yOut = (double)this.inputHeight - yOut;
            xOut = (double)this.inputWidth - xOut;
        }
        x -= 0.5;
        y -= 0.5;
        return new Position(xOut, yOut);
    }
}

