/*
 * Decompiled with CFR 0.152.
 */
package panoramakit.converter.samplers;

import panoramakit.converter.PixelSampler;
import panoramakit.converter.data.Bounds;
import panoramakit.converter.data.PixelCoordinate;
import panoramakit.converter.data.Position;

public class CubicSampler
extends PixelSampler {
    public Bounds equator;
    public Bounds northPole;
    public Bounds southPole;

    @Override
    public PixelCoordinate[][] getSamplePixels(Position position, int width, int height, int sampleSize) {
        int yPos = (int)Math.round(position.y);
        Bounds currentBounds = yPos < height / 3 ? this.northPole : (yPos < 2 * height / 3 ? this.equator : this.southPole);
        PixelCoordinate[][] sampledPixels = new PixelCoordinate[sampleSize][sampleSize];
        int xBaseIndex = (int)Math.floor(position.x) - (sampleSize / 2 - 1);
        int yBaseIndex = (int)Math.floor(position.y) - (sampleSize / 2 - 1);
        int xDelta = 0;
        while (xDelta < sampleSize) {
            int yDelta = 0;
            while (yDelta < sampleSize) {
                int x = currentBounds.getCappedX(xBaseIndex + xDelta);
                int y = currentBounds.getCappedY(yBaseIndex + yDelta);
                sampledPixels[xDelta][yDelta] = new PixelCoordinate(x, y);
                ++yDelta;
            }
            ++xDelta;
        }
        return sampledPixels;
    }

    @Override
    public void setBounds(int width, int height) {
        super.setBounds(width, height);
        this.northPole = new Bounds(width / 4, 2 * width / 4, 0, height / 3);
        this.equator = new Bounds(0, width, height / 3, 2 * height / 3);
        this.southPole = new Bounds(width / 4, 2 * width / 4, 2 * height / 3, 3 * height / 3);
    }
}

