/*
 * Decompiled with CFR 0.152.
 */
package panoramakit.converter.samplers;

import panoramakit.converter.PixelSampler;
import panoramakit.converter.data.PixelCoordinate;
import panoramakit.converter.data.Position;

public class FlatSampler
extends PixelSampler {
    @Override
    public PixelCoordinate[][] getSamplePixels(Position position, int width, int height, int sampleSize) {
        int xBase = (int)Math.floor(position.x) - (sampleSize / 2 - 1);
        int yBase = (int)Math.floor(position.y) - (sampleSize / 2 - 1);
        PixelCoordinate[][] sampledPixels = new PixelCoordinate[sampleSize][sampleSize];
        int xDelta = 0;
        while (xDelta < sampleSize) {
            int yDelta = 0;
            while (yDelta < sampleSize) {
                int x = this.edge.getCappedX(xBase + xDelta);
                int y = this.edge.getCappedY(yBase + yDelta);
                sampledPixels[xDelta][yDelta] = new PixelCoordinate(x, y);
                ++yDelta;
            }
            ++xDelta;
        }
        return sampledPixels;
    }
}

