/*
 * Decompiled with CFR 0.152.
 */
package panoramakit.engine.accessor;

import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.util.Timer;

public class MinecraftAccessor {
    private static final Logger L = Logger.getLogger(MinecraftAccessor.class.getName());
    private static final int FIELD_TIMER;
    private static final int FIELD_SNDMANAGER;
    private static final int FIELD_EFFECTRENDERER;
    private final Minecraft mc;

    static {
        Field[] fields = Minecraft.class.getDeclaredFields();
        int fieldTimer = 8;
        int fieldSndManager = 0;
        int fieldEffectRenderer = 0;
        int i = 0;
        while (i < fields.length) {
            if (fields[i].getType() == Timer.class) {
                fieldTimer = i;
            }
            if (fields[i].getType() == SoundManager.class) {
                fieldSndManager = i;
            }
            if (fields[i].getType() == EffectRenderer.class) {
                fieldEffectRenderer = i;
            }
            ++i;
        }
        FIELD_TIMER = fieldTimer;
        FIELD_SNDMANAGER = fieldSndManager;
        FIELD_EFFECTRENDERER = fieldEffectRenderer;
    }

    public MinecraftAccessor(Minecraft mc) {
        this.mc = mc;
    }

    public MinecraftAccessor() {
        this(Minecraft.func_71410_x());
    }

    public Minecraft getMinecraftInstance() {
        return this.mc;
    }

    public void setTimer(Timer timer) {
        try {
            ReflectionHelper.setPrivateValue(Minecraft.class, (Object)this.mc, (Object)timer, (int)FIELD_TIMER);
        }
        catch (Exception ex) {
            L.log(Level.SEVERE, "Couldn't set timer!", ex);
        }
    }

    public Timer getTimer() {
        try {
            return (Timer)ReflectionHelper.getPrivateValue(Minecraft.class, (Object)this.mc, (int)FIELD_TIMER);
        }
        catch (Exception ex) {
            L.log(Level.SEVERE, "Couldn't get timer!", ex);
            return null;
        }
    }

    public void setSoundManager(SoundManager sndManager) {
        try {
            ReflectionHelper.setPrivateValue(Minecraft.class, (Object)this.mc, (Object)sndManager, (int)FIELD_SNDMANAGER);
        }
        catch (Exception ex) {
            L.log(Level.SEVERE, "Couldn't set sound manager!", ex);
        }
    }

    public SoundManager getSoundManager() {
        try {
            return (SoundManager)ReflectionHelper.getPrivateValue(Minecraft.class, (Object)this.mc, (int)FIELD_SNDMANAGER);
        }
        catch (Exception ex) {
            L.log(Level.SEVERE, "Couldn't get sound manager!", ex);
            return null;
        }
    }

    public void setEffectRenderer(EffectRenderer effectRenderer) {
        try {
            ReflectionHelper.setPrivateValue(Minecraft.class, (Object)this.mc, (Object)effectRenderer, (int)FIELD_EFFECTRENDERER);
        }
        catch (Exception ex) {
            L.log(Level.SEVERE, "Couldn't set effect renderer!", ex);
        }
    }

    public EffectRenderer getEffectRenderer() {
        try {
            return (EffectRenderer)ReflectionHelper.getPrivateValue(Minecraft.class, (Object)this.mc, (int)FIELD_EFFECTRENDERER);
        }
        catch (Exception ex) {
            L.log(Level.SEVERE, "Couldn't get effect renderer!", ex);
            return null;
        }
    }
}

