/*
 * Decompiled with CFR 0.152.
 */
package panoramakit.engine.render;

import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.MouseHelper;
import panoramakit.engine.accessor.EntityRendererAccessor;
import panoramakit.engine.render.ImageLink;
import panoramakit.engine.render.TiledScreenshot;
import panoramakit.engine.util.ChatPrinter;
import panoramakit.engine.util.LockableMouseHelper;

public abstract class CompositeImageRenderer {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private EntityRendererAccessor era = new EntityRendererAccessor();
    private boolean hideGui;
    private boolean advancedOpengl;
    private MouseHelper mouseHelper;
    private float fieldOfView;
    private float pitch;
    private float yaw;
    private int screenshotWidth;
    private int screenshotHeight;
    private TiledScreenshot screenshot;
    protected ImageLink imageLink;
    protected ChatPrinter chat;

    public CompositeImageRenderer(int screenshotWidth, int screenshotHeight) {
        this.screenshotWidth = screenshotWidth;
        this.screenshotHeight = screenshotHeight;
    }

    public void setImageLink(ImageLink imageLink) {
        this.imageLink = imageLink;
    }

    public void setChatPrinter(ChatPrinter chat) {
        this.chat = chat;
    }

    public final void render() throws IOException {
        this.screenshot = new TiledScreenshot(this.screenshotWidth, this.screenshotHeight, CompositeImageRenderer.mc.field_71443_c, CompositeImageRenderer.mc.field_71440_d);
        this.applyMods();
        try {
            this.assembleImage();
        }
        finally {
            this.restoreMods();
        }
    }

    public abstract void assembleImage() throws IOException;

    public int[] captureScreenshot() {
        this.screenshot.capture();
        return this.screenshot.getScreenshot();
    }

    public void rotatePlayer(float yaw, float pitch, float roll) {
        CompositeImageRenderer.mc.field_71439_g.field_70177_z = CompositeImageRenderer.mc.field_71439_g.field_70126_B = yaw;
        CompositeImageRenderer.mc.field_71439_g.field_70125_A = CompositeImageRenderer.mc.field_71439_g.field_70127_C = pitch;
        this.era.setCameraRoll(roll);
    }

    private void applyMods() {
        this.hideGui = CompositeImageRenderer.mc.field_71474_y.field_74319_N;
        CompositeImageRenderer.mc.field_71474_y.field_74319_N = true;
        this.advancedOpengl = CompositeImageRenderer.mc.field_71474_y.field_74349_h;
        this.fieldOfView = CompositeImageRenderer.mc.field_71474_y.field_74334_X;
        CompositeImageRenderer.mc.field_71474_y.field_74334_X = (90.0f / CompositeImageRenderer.mc.field_71439_g.func_71151_f() - 70.0f) / 40.0f;
        this.yaw = CompositeImageRenderer.mc.field_71439_g.field_70177_z;
        this.pitch = CompositeImageRenderer.mc.field_71439_g.field_70125_A;
        LockableMouseHelper mouseHelperLocked = new LockableMouseHelper();
        mouseHelperLocked.setGrabbing(false);
        mouseHelperLocked.setLocked(true);
        this.mouseHelper = CompositeImageRenderer.mc.field_71417_B;
        CompositeImageRenderer.mc.field_71417_B = mouseHelperLocked;
        for (Object obj : CompositeImageRenderer.mc.field_71441_e.field_72996_f) {
            Entity ent = (Entity)obj;
            ent.field_70158_ak = true;
            ent.field_70155_l = 16.0;
        }
    }

    private void restoreMods() {
        if (this.era != null) {
            this.era.setCameraZoom(1.0);
            this.era.setCameraOffsetX(0.0);
            this.era.setCameraOffsetY(0.0);
            this.era.setCameraRoll(0.0f);
        }
        CompositeImageRenderer.mc.field_71439_g.field_70177_z = CompositeImageRenderer.mc.field_71439_g.field_70126_B = this.yaw;
        CompositeImageRenderer.mc.field_71439_g.field_70125_A = CompositeImageRenderer.mc.field_71439_g.field_70127_C = this.pitch;
        CompositeImageRenderer.mc.field_71474_y.field_74319_N = this.hideGui;
        CompositeImageRenderer.mc.field_71474_y.field_74349_h = this.advancedOpengl;
        CompositeImageRenderer.mc.field_71474_y.field_74334_X = this.fieldOfView;
        CompositeImageRenderer.mc.field_71417_B = this.mouseHelper;
        for (Object obj : CompositeImageRenderer.mc.field_71441_e.field_72996_f) {
            Entity ent = (Entity)obj;
            ent.field_70158_ak = false;
            ent.field_70155_l = 1.0;
        }
    }
}

