/*
 * Decompiled with CFR 0.152.
 */
package panoramakit.engine.task;

import java.util.logging.Level;
import java.util.logging.Logger;
import panoramakit.engine.task.Task;
import panoramakit.engine.task.TaskManager;
import panoramakit.engine.util.ProgressTracker;
import panoramakit.mod.PanoramaKit;

public abstract class ThreadedTask
extends Task
implements Runnable {
    public final ProgressTracker progressTracker = new ProgressTracker();
    private final Logger L;

    public ThreadedTask() {
        this.L = PanoramaKit.instance.L;
    }

    public void start() {
        Thread task = new Thread(this);
        task.start();
    }

    @Override
    public final void run() {
        try {
            this.performThreaded();
        }
        catch (InterruptedException ex) {
            this.L.warning("Threaded task stopped.");
            this.setStopped();
            return;
        }
        catch (Exception ex) {
            this.L.log(Level.SEVERE, "Threaded task has failed", ex);
            PanoramaKit.instance.printChat("Current task failed: " + ex, new Object[0]);
            TaskManager.instance.halt();
            this.setStopped();
            return;
        }
        this.setCompleted();
    }

    public abstract void performThreaded() throws Exception;

    @Override
    public void perform() {
    }
}

