/*
 * Decompiled with CFR 0.152.
 */
package panoramakit.engine.tools;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageSlicer {
    private File imageFile;
    private File outputFolder;
    private int xTiles;
    private int yTiles;
    private int tileWidth;
    private int tileHeight;

    public ImageSlicer(File imageFile, File outputFolder, int xTiles, int yTiles) {
        this.imageFile = imageFile;
        this.outputFolder = outputFolder;
        this.xTiles = xTiles;
        this.yTiles = yTiles;
    }

    public void slice() throws IOException, Exception {
        BufferedImage image = ImageIO.read(this.imageFile);
        this.tileWidth = image.getWidth() / this.xTiles;
        this.tileHeight = image.getHeight() / this.yTiles;
        if (this.tileWidth * this.xTiles != image.getWidth() || this.tileHeight * this.yTiles != image.getHeight()) {
            throw new IllegalArgumentException("Image not evenly divisible by the number of tiles!");
        }
        int xTile = 0;
        while (xTile < this.xTiles) {
            int yTile = 0;
            while (yTile < this.yTiles) {
                this.createTile(image, xTile, yTile);
                ++yTile;
            }
            ++xTile;
        }
    }

    private void createTile(BufferedImage image, int xTile, int yTile) throws IOException {
        BufferedImage imageTile = image.getSubimage(xTile * this.tileWidth, yTile * this.tileHeight, this.tileWidth, this.tileHeight);
        File imageTileFile = new File(this.outputFolder, this.getTileName(xTile, yTile));
        if (imageTileFile.getParentFile().exists()) {
            imageTileFile.mkdirs();
        }
        if (imageTileFile.exists()) {
            imageTileFile.createNewFile();
        }
        ImageIO.write((RenderedImage)imageTile, "png", imageTileFile);
    }

    private String getTileName(int xTile, int yTile) {
        return String.valueOf(xTile) + "_" + yTile + ".png";
    }
}

