/*
 * Decompiled with CFR 0.152.
 */
package panoramakit.gui;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import panoramakit.engine.task.TaskManager;
import panoramakit.mod.PanoramaKit;

public class PreviewRenderer {
    private BufferedImage image;
    private DynamicTexture previewTexture;
    private ResourceLocation resourceLocation;
    private TextureManager textureManager;

    public PreviewRenderer(TextureManager textureManager) {
        this.textureManager = textureManager;
    }

    public static File getPreviewFile() {
        return new File(PanoramaKit.instance.getTempRenderDir(), "Preview.png");
    }

    public void clearPreview() {
        File preview = PreviewRenderer.getPreviewFile();
        if (preview.exists()) {
            preview.delete();
        }
    }

    public boolean previewAvailable() {
        return PreviewRenderer.getPreviewFile().exists() && !TaskManager.instance.hasTasks();
    }

    private boolean loadPreview() {
        try {
            this.image = ImageIO.read(PreviewRenderer.getPreviewFile());
            this.previewTexture = new DynamicTexture(this.image);
            this.resourceLocation = this.textureManager.func_110578_a("preivew", this.previewTexture);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void drawCenteredImage(int xPos, int yPos, int width, int height) {
        double boxRatio;
        boolean successful;
        if (this.previewTexture == null && !(successful = this.loadPreview())) {
            return;
        }
        double ratio = (double)this.image.getWidth() / (double)this.image.getHeight();
        int imageWidth = ratio > (boxRatio = (double)width / (double)height) ? width : (int)((double)width * ratio);
        int imageHeight = ratio < boxRatio ? height : (int)((double)height / ratio);
        this.drawImage(xPos + (width - imageWidth) / 2, yPos + (height - imageHeight) / 2, imageWidth, imageHeight);
    }

    private void drawImage(int xPos, int yPos, int width, int height) {
        this.previewTexture.func_110564_a();
        Tessellator tessellator = Tessellator.field_78398_a;
        this.textureManager.func_110577_a(this.resourceLocation);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)1, (int)771);
        GL11.glDisable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)xPos, (double)(yPos + height), 0.0, 0.0, 1.0);
        tessellator.func_78374_a((double)(xPos + width), (double)(yPos + height), 0.0, 1.0, 1.0);
        tessellator.func_78374_a((double)(xPos + width), (double)yPos, 0.0, 1.0, 0.0);
        tessellator.func_78374_a((double)xPos, (double)yPos, 0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
    }
}

