/*
 * Decompiled with CFR 0.152.
 */
package panoramakit.gui.screens.settingsscreens;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraftforge.common.Configuration;
import panoramakit.gui.PreviewRenderer;
import panoramakit.gui.menuitems.GuiCustomButton;
import panoramakit.gui.menuitems.GuiCustomTextField;
import panoramakit.gui.menuitems.HoverTips;
import panoramakit.mod.PanoramaKit;

public abstract class GuiScreenSettings
extends GuiScreen {
    protected static Minecraft field_73882_e = Minecraft.func_71410_x();
    private String screenLabel;
    protected ArrayList<GuiCustomTextField> textFieldList = new ArrayList();
    protected PreviewRenderer previewRenderer;
    private boolean capturingPreview;
    private boolean hasDrawnOverlayMessage;
    protected boolean disableInput;
    protected String tipMessage;

    public GuiScreenSettings(String screenLabel) {
        this.previewRenderer = new PreviewRenderer(Minecraft.func_71410_x().field_71446_o);
        this.capturingPreview = false;
        this.hasDrawnOverlayMessage = false;
        this.disableInput = false;
        this.tipMessage = "";
        this.screenLabel = screenLabel;
    }

    protected void func_73875_a(GuiButton guibutton) {
        int currentOption = 0;
        if (guibutton instanceof GuiCustomButton) {
            GuiCustomButton customButton = (GuiCustomButton)guibutton;
            customButton.cycleOptions();
            currentOption = customButton.getCurrentOption();
        }
        this.buttonPressed(guibutton, guibutton.field_73741_f, currentOption);
    }

    protected void func_73869_a(char character, int keyCode) {
        block5: {
            block4: {
                super.func_73869_a(character, keyCode);
                if (this.textFieldList.isEmpty()) {
                    return;
                }
                if (character != '\t') break block4;
                int activeTextField = -1;
                int i = 0;
                while (i < this.textFieldList.size()) {
                    if (this.textFieldList.get(i).func_73806_l()) {
                        activeTextField = i;
                        break;
                    }
                    ++i;
                }
                if (activeTextField < 0) break block5;
                this.textFieldList.get(activeTextField).func_73796_b(false);
                int nextTextField = (activeTextField + 1) % this.textFieldList.size();
                this.textFieldList.get(nextTextField).func_73796_b(true);
                break block5;
            }
            for (GuiCustomTextField textfield : this.textFieldList) {
                boolean successfullyTyped = textfield.func_73802_a(character, keyCode);
                if (!successfullyTyped) continue;
                textfield.setError(false);
                this.textFieldUpdated(textfield, textfield.id, textfield.func_73781_b());
                break;
            }
        }
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        super.func_73864_a(par1, par2, par3);
        for (GuiTextField guiTextField : this.textFieldList) {
            guiTextField.func_73793_a(par1, par2, par3);
        }
    }

    public void buttonPressed(GuiButton button, int id, int currentOption) {
    }

    public void sliderMoved(int id, float value) {
    }

    public void textFieldUpdated(GuiCustomTextField textField, int id, String value) {
    }

    public GuiCustomTextField getTextField(int id) {
        for (GuiCustomTextField textfield : this.textFieldList) {
            if (textfield.id != id) continue;
            return textfield;
        }
        return null;
    }

    public boolean setTextField(int id, String value) {
        GuiCustomTextField textfield = this.getTextField(id);
        if (textfield == null) {
            return false;
        }
        textfield.func_73782_a(value);
        return true;
    }

    public void func_73863_a(int x, int y, float z) {
        for (GuiCustomTextField textfield : this.textFieldList) {
            textfield.func_73795_f();
        }
        super.func_73863_a(x, y, z);
        if (this.capturingPreview) {
            this.func_73873_v_();
            this.func_73732_a(this.field_73886_k, "Rendering Preview...", this.field_73880_f / 2, this.field_73881_g / 2, 0xE0E0E0);
            if (this.hasDrawnOverlayMessage) {
                Minecraft.func_71410_x().func_71373_a(null);
            }
            this.hasDrawnOverlayMessage = true;
        }
    }

    protected void capturePreview() {
        this.capturingPreview = true;
    }

    public void func_73876_c() {
        for (GuiTextField guiTextField : this.textFieldList) {
            guiTextField.func_73780_a();
        }
        this.updateTipMessage();
    }

    public void func_73874_b() {
        Configuration config = PanoramaKit.instance.getConfig();
        if (config.hasChanged()) {
            config.save();
        }
        this.previewRenderer.clearPreview();
    }

    public String toString() {
        return this.screenLabel;
    }

    protected void updateTipMessage() {
        for (Object button : this.field_73887_h) {
            if (!(button instanceof HoverTips) || !((HoverTips)button).isHovered()) continue;
            this.tipMessage = ((HoverTips)button).getTipMessage();
            return;
        }
        for (GuiCustomTextField textfield : this.textFieldList) {
            if (!(textfield instanceof HoverTips) || !((HoverTips)((Object)textfield)).isHovered()) continue;
            this.tipMessage = ((HoverTips)((Object)textfield)).getTipMessage();
            return;
        }
        this.tipMessage = "";
    }
}

