/*
 * Decompiled with CFR 0.152.
 */
package panoramakit.gui.screens.settingsscreens;

import java.io.File;
import java.util.logging.Logger;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSmallButton;
import panoramakit.engine.render.renderers.BackgroundRenderer;
import panoramakit.engine.task.TaskManager;
import panoramakit.engine.task.tasks.RenderTask;
import panoramakit.engine.task.threadedtasks.ZipTask;
import panoramakit.gui.menuitems.GuiCustomButton;
import panoramakit.gui.menuitems.GuiCustomSliderOrientation;
import panoramakit.gui.menuitems.GuiCustomTextField;
import panoramakit.gui.screens.GuiRenderNotice;
import panoramakit.gui.screens.menuscreens.GuiMenuMain;
import panoramakit.gui.screens.settingsscreens.GuiScreenSettings;
import panoramakit.gui.settings.BackgroundSettings;
import panoramakit.gui.settings.SharedSettings;
import panoramakit.gui.util.FileNumerator;
import panoramakit.mod.PanoramaKit;

public class GuiSettingsBackground
extends GuiScreenSettings {
    private static Logger L = PanoramaKit.instance.L;
    private static String screenTitle = "Main Menu Background";
    private static String screenLabel = "Make a Background";
    private static final int RESOLUTION = 0;
    private static final int ORIENTATION = 1;
    private static final int MODE = 2;
    private static final int BACK = 3;
    private static final int CREATE = 4;
    private BackgroundSettings settings = new BackgroundSettings();

    public GuiSettingsBackground() {
        super(screenLabel);
    }

    public void func_73866_w_() {
        this.field_73887_h.clear();
        this.textFieldList.clear();
        int leftCol = this.field_73880_f / 2 - 75 - 5;
        int rightCol = this.field_73880_f / 2 + 75 + 5;
        int contentStart = this.field_73881_g / 2 - 60;
        int bottomRow = this.field_73881_g / 2 + 60;
        int rowHeight = 24;
        int currentY = contentStart + 12;
        GuiCustomTextField fieldWidth = new GuiCustomTextField(this.field_73886_k, 0, this.field_73880_f / 2 - 10, currentY, 80, 20, true);
        fieldWidth.func_73782_a(String.valueOf(this.settings.getResolution()));
        this.textFieldList.add(fieldWidth);
        this.field_73887_h.add(new GuiCustomSliderOrientation(1, this.field_73880_f / 2 - 75, currentY += 24, this, "Orientation", "What you can see is where it will start rotating.", -180.0f, 180.0f, 0.0f, SharedSettings.getOrientation()));
        this.field_73887_h.add(new GuiCustomButton(2, this.field_73880_f / 2 - 75, currentY += 24, 150, 20, null, "The option \"Add To The Game\" will be added after Minecraft 1.7", BackgroundSettings.modes, this.settings.getMode()));
        this.field_73887_h.add(new GuiSmallButton(3, leftCol - 75, bottomRow, "Back"));
        this.field_73887_h.add(new GuiSmallButton(4, rightCol - 75, bottomRow, "Create"));
        this.updateView(SharedSettings.getOrientation());
    }

    @Override
    public void func_73863_a(int x, int y, float z) {
        int contentStart = this.field_73881_g / 2 - 60;
        int bottomRow = this.field_73881_g / 2 + 60;
        this.func_73873_v_();
        this.func_73732_a(this.field_73886_k, screenTitle, this.field_73880_f / 2, contentStart - 24, 0xFFFFFF);
        this.func_73731_b(this.field_73886_k, "Resolution", this.field_73880_f / 2 - 75 + 5, contentStart + 12 + 6, 0xA0A0A0);
        this.func_73732_a(this.field_73886_k, this.tipMessage, this.field_73880_f / 2, bottomRow - 12, 0xFFCF33);
        super.func_73863_a(x, y, z);
    }

    @Override
    public void buttonPressed(GuiButton button, int id, int currentOption) {
        if (id == 2) {
            this.settings.setMode(currentOption);
        }
        if (id == 3) {
            field_73882_e.func_71373_a((GuiScreen)new GuiMenuMain());
        }
        if (id == 4) {
            if (BackgroundSettings.modes[currentOption] == BackgroundSettings.saveBackground) {
                L.info("Create new background");
                File renderDir = new File(PanoramaKit.instance.getTempRenderDir(), "assets/minecraft/textures/gui/title/background/");
                BackgroundRenderer renderer = new BackgroundRenderer(this.settings.getResolution(), renderDir, SharedSettings.getOrientation());
                TaskManager.instance.addTask(new RenderTask(renderer));
                File bgDir = new File(PanoramaKit.instance.getTempRenderDir(), "assets/");
                File zipFile = new File(PanoramaKit.instance.getRenderDir(), "backgrounds/CustomBackground.zip");
                TaskManager.instance.addTask(new ZipTask(bgDir, FileNumerator.increment(zipFile)));
                field_73882_e.func_71373_a((GuiScreen)new GuiRenderNotice());
            }
            String cfr_ignored_0 = BackgroundSettings.modes[currentOption];
        }
    }

    @Override
    public void sliderMoved(int id, float value) {
        if (id == 1) {
            SharedSettings.setOrientation(value);
            this.updateView(value);
        }
    }

    public void updateView(float orientation) {
        GuiSettingsBackground.field_73882_e.field_71439_g.field_70177_z = GuiSettingsBackground.field_73882_e.field_71439_g.field_70126_B = orientation;
        GuiSettingsBackground.field_73882_e.field_71439_g.field_70127_C = 0.0f;
        GuiSettingsBackground.field_73882_e.field_71439_g.field_70125_A = 0.0f;
    }

    @Override
    public void textFieldUpdated(GuiCustomTextField textField, int id, String value) {
        int intValue = -1;
        try {
            intValue = Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (id == 0) {
            if (intValue > 0) {
                this.settings.setResolution(intValue);
            } else {
                textField.setError(true);
            }
        }
    }
}

