/*
 * Decompiled with CFR 0.152.
 */
package panoramakit.gui.screens.settingsscreens;

import java.io.File;
import java.util.logging.Logger;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSmallButton;
import panoramakit.converter.ProjectionConverter;
import panoramakit.converter.projections.CubicToEquirect;
import panoramakit.engine.render.ImageLink;
import panoramakit.engine.render.renderers.CubicRenderer;
import panoramakit.engine.task.TaskManager;
import panoramakit.engine.task.tasks.DisplayGuiScreenTask;
import panoramakit.engine.task.tasks.RenderTask;
import panoramakit.engine.task.threadedtasks.ProjectionConverterTask;
import panoramakit.gui.PreviewRenderer;
import panoramakit.gui.menuitems.GuiCustomSlider;
import panoramakit.gui.menuitems.GuiCustomSliderOrientation;
import panoramakit.gui.menuitems.GuiCustomSliderSample;
import panoramakit.gui.menuitems.GuiCustomTextField;
import panoramakit.gui.screens.GuiRenderNotice;
import panoramakit.gui.screens.menuscreens.GuiMenuPanoramas;
import panoramakit.gui.screens.settingsscreens.GuiScreenSettings;
import panoramakit.gui.settings.EquirectSettings;
import panoramakit.gui.settings.SharedSettings;
import panoramakit.gui.util.FileNumerator;
import panoramakit.mod.PanoramaKit;

public class GuiSettingsEquirect
extends GuiScreenSettings {
    private static Logger L = PanoramaKit.instance.L;
    private static String screenTitle = "Equirectangular Panorama";
    private static String screenLabel = "Equirectangular";
    private static final int WIDTH = 0;
    private static final int HEIGHT = 1;
    private static final int SAMPLE_SIZE = 2;
    private static final int ORIENTATION = 3;
    private static final int ANGLE = 4;
    private static final int PREVIEW = 5;
    private static final int BACK = 6;
    private static final int CAPTURE = 7;
    private EquirectSettings settings = new EquirectSettings();

    public GuiSettingsEquirect() {
        super(screenLabel);
    }

    public void func_73866_w_() {
        this.field_73887_h.clear();
        this.textFieldList.clear();
        int leftCol = this.field_73880_f / 2 - 75 - 5;
        int rightCol = this.field_73880_f / 2 + 75 + 5;
        int contentStart = this.field_73881_g / 2 - 84;
        int bottomRow = this.field_73881_g / 2 + 84;
        int rowHeight = 24;
        int currentY = contentStart + 12;
        GuiCustomTextField fieldWidth = new GuiCustomTextField(this.field_73886_k, 0, leftCol - 12 - 64, currentY, 64, 20, true);
        GuiCustomTextField fieldHeight = new GuiCustomTextField(this.field_73886_k, 1, leftCol + 12, currentY, 64, 20, true);
        fieldWidth.func_73782_a(String.valueOf(this.settings.getResolution() * 4));
        fieldHeight.func_73782_a(String.valueOf(this.settings.getResolution() * 2));
        this.textFieldList.add(fieldWidth);
        this.textFieldList.add(fieldHeight);
        this.field_73887_h.add(new GuiCustomSliderSample(2, leftCol - 75, currentY += 24, this, "Sample Size", "Warning! Large samples eat lots of RAM!", 1.0f, 8.0f, 0.5f, this.settings.getSampleSize()));
        this.field_73887_h.add(new GuiCustomSliderOrientation(3, leftCol - 75, currentY += 24, this, "Orientation", "", -180.0f, 180.0f, 0.0f, SharedSettings.getOrientation()));
        this.field_73887_h.add(new GuiCustomSlider(4, leftCol - 75, currentY += 24, this, "Angle", "", -90.0f, 90.0f, 0.0f, this.settings.getAngle()));
        this.field_73887_h.add(new GuiButton(5, rightCol - 40, contentStart + 128 + 6, 80, 20, "Preview"));
        this.field_73887_h.add(new GuiSmallButton(6, leftCol - 75, bottomRow, "Back"));
        this.field_73887_h.add(new GuiSmallButton(7, rightCol - 75, bottomRow, "Capture"));
    }

    @Override
    public void func_73863_a(int x, int y, float z) {
        int leftCol = this.field_73880_f / 2 - 75 - 5;
        int rightCol = this.field_73880_f / 2 + 75 + 5;
        int contentStart = this.field_73881_g / 2 - 84;
        int bottomRow = this.field_73881_g / 2 + 84;
        this.func_73873_v_();
        this.func_73732_a(this.field_73886_k, screenTitle, this.field_73880_f / 2, contentStart - 24, 0xFFFFFF);
        this.func_73732_a(this.field_73886_k, "Width", leftCol - 32 - 12, contentStart, 0xA0A0A0);
        this.func_73732_a(this.field_73886_k, "Height", leftCol + 32 + 12, contentStart, 0xA0A0A0);
        this.func_73731_b(this.field_73886_k, "x", leftCol - 2, contentStart + 16, 0xFFFFFF);
        GuiSettingsEquirect.func_73734_a((int)(rightCol - 64 - 1), (int)(contentStart - 1), (int)(rightCol - 64 + 128 + 1), (int)(contentStart + 128 + 1), (int)-16777216);
        GuiSettingsEquirect.func_73734_a((int)(rightCol - 64), (int)contentStart, (int)(rightCol - 64 + 128), (int)(contentStart + 128), (int)-14145496);
        if (this.previewRenderer.previewAvailable()) {
            this.previewRenderer.drawCenteredImage(rightCol - 64, contentStart, 128, 128);
        }
        int sampleResolution = (int)((float)this.settings.getResolution() * this.settings.getSampleSize());
        int sampleWidth = sampleResolution * 4;
        int sampleHeight = sampleResolution * 3;
        this.func_73732_a(this.field_73886_k, "Sampled image: " + sampleWidth + "x" + sampleHeight, leftCol, bottomRow - 24 - 4, 0xA0A0A0);
        this.func_73732_a(this.field_73886_k, this.tipMessage, this.field_73880_f / 2, bottomRow - 12, 0xFFCF33);
        super.func_73863_a(x, y, z);
    }

    @Override
    public void buttonPressed(GuiButton button, int id, int value) {
        if (id == 6) {
            field_73882_e.func_71373_a((GuiScreen)new GuiMenuPanoramas());
        }
        if (id == 7) {
            L.info("Render equirectangular panorama");
            File renderFile = new File(PanoramaKit.instance.getRenderDir(), "Equirectangular.png");
            renderFile = FileNumerator.numberFile(renderFile);
            CubicToEquirect panorama = new CubicToEquirect(this.settings.getResolution());
            ProjectionConverter converter = new ProjectionConverter(panorama, renderFile);
            int sampleResolution = (int)((float)this.settings.getResolution() * this.settings.getSampleSize());
            CubicRenderer renderer = new CubicRenderer(sampleResolution, renderFile, SharedSettings.getOrientation(), this.settings.getAngle());
            TaskManager.instance.addTask(new RenderTask(renderer));
            TaskManager.instance.addTask(new ProjectionConverterTask(converter));
            ImageLink imageLink = new ImageLink();
            renderer.setImageLink(imageLink);
            converter.setImageLink(imageLink);
            field_73882_e.func_71373_a((GuiScreen)new GuiRenderNotice());
        }
        if (id == 5) {
            L.info("Render preview panorama");
            File previewFile = PreviewRenderer.getPreviewFile();
            int previewSize = 256;
            int resolution = previewSize / 4;
            CubicToEquirect panorama = new CubicToEquirect(resolution);
            ProjectionConverter converter = new ProjectionConverter(panorama, previewFile);
            int sampleResolution = 256;
            CubicRenderer renderer = new CubicRenderer(sampleResolution, previewFile, SharedSettings.getOrientation(), this.settings.getAngle());
            TaskManager.instance.addTask(new RenderTask(renderer));
            TaskManager.instance.addTask(new DisplayGuiScreenTask(((Object)((Object)this)).getClass()));
            ProjectionConverterTask projectionTask = new ProjectionConverterTask(converter);
            projectionTask.setSilent();
            TaskManager.instance.addTask(projectionTask);
            ImageLink imageLink = new ImageLink();
            renderer.setImageLink(imageLink);
            converter.setImageLink(imageLink);
            this.capturePreview();
        }
    }

    @Override
    public void sliderMoved(int id, float value) {
        if (id == 2) {
            this.settings.setSampleSize(value);
        }
        if (id == 3) {
            SharedSettings.setOrientation(value);
        }
        if (id == 4) {
            this.settings.setAngle(value);
        }
    }

    @Override
    public void textFieldUpdated(GuiCustomTextField textField, int id, String value) {
        int intValue = -1;
        try {
            intValue = Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (id == 0) {
            if (intValue >= 4) {
                this.settings.setResolution(intValue / 4);
                this.setTextField(1, String.valueOf(this.settings.getResolution() * 2));
            } else {
                textField.setError(true);
            }
        }
        if (id == 1) {
            if (intValue >= 2) {
                this.settings.setResolution(intValue / 2);
                this.setTextField(0, String.valueOf(this.settings.getResolution() * 4));
            } else {
                textField.setError(true);
            }
        }
    }
}

