/*
 * Decompiled with CFR 0.152.
 */
package eekysam.festivities.debugutils;

import eekysam.utils.perlin.Perlin;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class PerlinTest
extends Perlin {
    public long seed;
    public int num;
    public float mult;

    public PerlinTest(long seed, int num, float mult) {
        this.seed = seed;
        this.num = num;
        this.mult = mult;
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public float getMult(int layer) {
        float m = 1.0f;
        for (int i = 1; i < layer; ++i) {
            m *= this.mult;
        }
        return m;
    }

    @Override
    public int numLayers() {
        return this.num;
    }

    public void saveImg(String file, int w, int h) {
        BufferedImage bi = new BufferedImage(w, h, 1);
        float[] grid = this.getGrid(null, 100, 100, w, h);
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                float v = grid[i + j * w];
                if ((v /= 2.0f) > 1.0f) {
                    v = 1.0f;
                }
                if (v < 0.0f) {
                    v = 0.0f;
                }
                Color c = new Color(v, v, v);
                bi.setRGB(i, j, c.getRGB());
            }
        }
        try {
            File outputfile = new File(file);
            ImageIO.write((RenderedImage)bi, "png", outputfile);
        }
        catch (IOException e) {
            // empty catch block
        }
    }
}

