/*
 * Decompiled with CFR 0.152.
 */
package eekysam.utils.draw;

import eekysam.utils.draw.IRenderer;

public abstract class BoxDraw {
    protected int domainW = 16;
    protected int domainH = 16;
    protected int domainL = 16;
    protected float xpos;
    protected float ypos;
    protected float zpos;
    protected int ixpos;
    protected int iypos;
    protected int izpos;
    protected float width;
    protected float height;
    protected float length;
    protected int iwidth;
    protected int iheight;
    protected int ilength;
    protected int textureWidth;
    protected int textureHeight;
    protected float textureU;
    protected float textureV;
    protected int itextureU;
    protected int itextureV;
    protected IRenderer parent;
    protected boolean inside = false;
    public bfq tess;

    public BoxDraw(IRenderer parent) {
        this.parent = parent;
        this.tess = bfq.a;
    }

    public void faceOut() {
        this.inside = false;
    }

    public void faceIn() {
        this.inside = true;
    }

    public void setPos(int x, int y, int z2) {
        this.ixpos = x;
        this.iypos = y;
        this.izpos = z2;
        this.xpos = (float)x / (float)this.domainW;
        this.ypos = (float)y / (float)this.domainH;
        this.zpos = (float)z2 / (float)this.domainL;
    }

    public void cube(int x, int y, int z2, int width, int height, int length) {
        this.setPos(x, y, z2);
        this.cube(width, height, length);
    }

    public void cube(int width, int height, int length) {
        this.iwidth = width;
        this.iheight = height;
        this.ilength = length;
        this.width = (float)width / (float)this.domainW;
        this.height = (float)height / (float)this.domainH;
        this.length = (float)length / (float)this.domainL;
    }

    public void setDomain(int width, int height, int length) {
        this.domainW = width;
        this.domainH = height;
        this.domainL = length;
    }

    public void setTexture(String id, String texture, int width, int height) {
        this.textureWidth = width;
        this.textureHeight = height;
        this.parent.rendererBindTexture(new bjo(id, texture));
    }

    public void selectV(int v) {
        this.itextureV = v;
        this.textureV = (float)v / (float)this.textureHeight;
    }

    public void selectU(int u) {
        this.itextureU = u;
        this.textureU = (float)u / (float)this.textureWidth;
    }

    public void selectUV(int u, int v) {
        this.itextureU = u;
        this.itextureV = v;
        this.textureU = (float)u / (float)this.textureWidth;
        this.textureV = (float)v / (float)this.textureHeight;
    }

    public abstract void XUp();

    public abstract void XDown();

    public abstract void YUp();

    public abstract void YDown();

    public abstract void ZUp();

    public abstract void ZDown();

    public void drawAll() {
        this.XUp();
        this.XDown();
        this.YUp();
        this.YDown();
        this.ZUp();
        this.ZDown();
    }

    public void drawSidesSameTexture() {
        this.XUp();
        this.XDown();
        this.ZUp();
        this.ZDown();
    }

    public void drawSidesGroupedTexture() {
        float u = this.textureU;
        float v = this.textureV;
        this.XUp();
        this.textureU += (float)this.iwidth / (float)this.textureWidth;
        this.ZUp();
        this.textureU += (float)this.ilength / (float)this.textureWidth;
        this.XDown();
        this.textureU += (float)this.iwidth / (float)this.textureWidth;
        this.ZDown();
        this.textureU = u;
        this.textureV = v;
    }

    public void drawAllNormalTextureShape() {
        float u = this.textureU;
        float v = this.textureV;
        this.textureU += (float)this.iwidth / (float)this.textureWidth;
        this.YUp();
        this.textureU += (float)this.iwidth / (float)this.textureWidth;
        this.YDown();
        this.textureU = u;
        this.textureV = v;
        this.textureV += (float)this.ilength / (float)this.textureHeight;
        this.drawSidesGroupedTexture();
        this.textureU = u;
        this.textureV = v;
    }

    public void drawAllLeftJustTextureShape(boolean topfirst) {
        float u = this.textureU;
        float v = this.textureV;
        if (topfirst) {
            this.YUp();
        } else {
            this.YDown();
        }
        this.textureU += (float)this.iwidth / (float)this.textureWidth;
        if (!topfirst) {
            this.YUp();
        } else {
            this.YDown();
        }
        this.textureU = u;
        this.textureV = v;
        this.textureV += (float)this.ilength / (float)this.textureHeight;
        this.drawSidesGroupedTexture();
        this.textureU = u;
        this.textureV = v;
    }

    public void reTess() {
        if (this.tess.z) {
            this.tess.a();
            this.tess.b();
        } else {
            this.tess.b();
        }
    }

    public void startTess() {
        if (!this.tess.z) {
            this.tess.b();
        }
    }

    public void setTess(boolean draw) {
        if (this.tess.z != draw) {
            if (draw) {
                this.tess.b();
            } else {
                this.tess.a();
            }
        }
    }
}

