/*
 * Decompiled with CFR 0.152.
 */
package simcraft.core.sound;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.net.URL;
import paulscode.sound.SoundSystem;
import simcraft.core.SimCraft;
import simcraft.core.sound.SndPositionPlayer;
import simcraft.core.sound.SoundPositionAudio;
import simcraft.core.sound.SoundSource;
import simcraft.core.sound.SoundsManagerClient;

@SideOnly(value=Side.CLIENT)
public final class SoundSourceClient
extends SoundSource {
    private SoundSystem soundSystem;
    private String sourceName;
    private boolean valid = false;
    private boolean culled = false;
    private Object obj;
    private SndPositionPlayer sndPositionPlayer;
    private SoundPositionAudio PositionAudio;
    private float configuredVolume;
    private float realVolume;
    private boolean isPlaying = false;
    private SoundPositionAudio position;

    public SoundSourceClient(SoundSystem var1, String var2, Object var3, SndPositionPlayer var4, String var5, boolean var6, boolean var7, float var8) {
        this.soundSystem = var1;
        this.sourceName = var2;
        this.obj = var3;
        this.sndPositionPlayer = var4;
        URL var9 = SoundSourceClient.class.getClassLoader().getResource("simcraft/sounds/" + var5);
        if (var9 == null) {
            System.out.println("Invalid sound file: " + var5);
        } else {
            this.position = SoundPositionAudio.getFrom(var3, var4);
            var1.newSource(var7, var2, var9, var5, var6, this.position.x, this.position.y, this.position.z, 2, ((SoundsManagerClient)SimCraft.soundsManager).fadingDistance * Math.max(var8, 1.0f));
            this.valid = true;
            if (var8 < 1.0f) {
                this.setVolume(var8);
            }
        }
    }

    public int compareTo(SoundSourceClient var1) {
        return this.culled ? (int)((this.realVolume * 0.9f - var1.realVolume) * 128.0f) : (int)((this.realVolume - var1.realVolume) * 128.0f);
    }

    @Override
    public void remove() {
        if (this.valid) {
            this.stop();
            this.soundSystem.removeSource(this.sourceName);
            this.sourceName = null;
        }
    }

    @Override
    public void play() {
        if (this.valid) {
            this.isPlaying = true;
            this.soundSystem.play(this.sourceName);
        }
    }

    @Override
    public void pause() {
        if (this.valid && this.isPlaying) {
            this.soundSystem.pause(this.sourceName);
        }
    }

    @Override
    public void stop() {
        if (this.valid && this.isPlaying) {
            this.soundSystem.stop(this.sourceName);
        }
    }

    @Override
    public void flush() {
        if (this.valid && this.isPlaying) {
            this.soundSystem.flush(this.sourceName);
        }
    }

    @Override
    public void cull() {
        if (this.valid && !this.culled) {
            this.soundSystem.cull(this.sourceName);
            this.culled = true;
        }
    }

    @Override
    public void activate() {
        if (this.valid && this.culled) {
            this.soundSystem.activate(this.sourceName);
            this.culled = false;
        }
    }

    @Override
    public float getVolume() {
        return !this.valid ? 0.0f : this.soundSystem.getVolume(this.sourceName);
    }

    @Override
    public void setVolume(float var1) {
        if (this.valid) {
            this.configuredVolume = var1;
            this.soundSystem.setVolume(this.sourceName, 0.001f);
        }
    }

    @Override
    public float getRealVolume() {
        return this.realVolume;
    }

    @Override
    public void setPitch(float var1) {
        if (this.valid) {
            this.soundSystem.setPitch(this.sourceName, var1);
        }
    }

    @Override
    public void updatePosition() {
        if (this.valid) {
            SoundPositionAudio var1 = SoundPositionAudio.getFrom(this.obj, this.sndPositionPlayer);
            this.soundSystem.setPosition(this.sourceName, var1.x, var1.y, var1.z);
        }
    }

    @Override
    public void updateVolume(ue var1) {
        if (this.valid && this.isPlaying) {
            float var8;
            float var11;
            float var10;
            float var9;
            float var2 = ((SoundsManagerClient)SimCraft.soundsManager).fadingDistance * Math.max(this.configuredVolume, 1.0f);
            float var3 = 1.0f;
            float var4 = 1.0f;
            float var5 = (float)var1.u;
            float var6 = (float)var1.v;
            float var7 = (float)var1.w;
            if (this.PositionAudio.world == var1.q) {
                var9 = this.PositionAudio.x - var5;
                var10 = this.PositionAudio.y - var6;
                var11 = this.PositionAudio.z - var7;
                var8 = (float)Math.sqrt(var9 * var9 + var10 * var10 + var11 * var11);
            } else {
                var8 = Float.POSITIVE_INFINITY;
            }
            if (var8 > var2) {
                this.realVolume = 0.0f;
                this.cull();
            } else {
                if (var8 < var4) {
                    var8 = var4;
                }
                var9 = 1.0f - var3 * (var8 - var4) / (var2 - var4);
                var10 = var9 * this.configuredVolume * SimCraft.soundsManager.getMasterVolume();
                var11 = (this.PositionAudio.x - var5) / var8;
                float var12 = (this.PositionAudio.y - var6) / var8;
                float var13 = (this.PositionAudio.z - var7) / var8;
                if ((double)var10 > 0.1) {
                    int var14 = 0;
                    while ((float)var14 < var8) {
                        int var15 = var1.q.a((int)var5, (int)var6, (int)var7);
                        if (var15 != 0) {
                            var10 = aqw.t[var15] ? (var10 *= 0.6f) : (var10 *= 0.8f);
                        }
                        var5 += var11;
                        var6 += var12;
                        var7 += var13;
                        ++var14;
                    }
                }
                if ((double)Math.abs(this.realVolume / var10 - 1.0f) > 0.06) {
                    this.soundSystem.setVolume(this.sourceName, SimCraft.soundsManager.getMasterVolume() * Math.min(var10, 1.0f));
                }
                this.realVolume = var10;
            }
        } else {
            this.realVolume = 0.0f;
        }
    }
}

